/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal;

import android.app.Activity;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.os.Build;
import android.util.AndroidRuntimeException;
import android.util.Log;
import java.util.HashMap;
import org.xwalk.core.internal.XWalkContentsClientBridge;
import org.xwalk.core.internal.XWalkNotificationService;
import org.xwalk.core.internal.XWalkViewInternal;

public class XWalkNotificationServiceImpl
implements XWalkNotificationService {
    private static final String TAG = "XWalkNotificationServiceImpl";
    private static final String XWALK_ACTION_CLICK_NOTIFICATION_SUFFIX = ".notification.click";
    private static final String XWALK_ACTION_CLOSE_NOTIFICATION_SUFFIX = ".notification.close";
    private static final String XWALK_INTENT_EXTRA_KEY_NOTIFICATION_ID = "xwalk.NOTIFICATION_ID";
    private static final String XWALK_INTENT_EXTRA_KEY_DELEGATE = "xwalk.DELEGATE";
    private static final String XWALK_INTENT_CATEGORY_NOTIFICATION_PREFIX = "notification_";
    private Context mContext;
    private XWalkContentsClientBridge mBridge;
    private XWalkViewInternal mView;
    private NotificationManager mNotificationManager;
    private BroadcastReceiver mNotificationCloseReceiver;
    private IntentFilter mNotificationCloseIntentFilter;
    private HashMap<Integer, Notification.Builder> mExistNotificationIds;

    public XWalkNotificationServiceImpl(Context context, XWalkViewInternal view) {
        this.mContext = context;
        this.mView = view;
        this.mNotificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        this.mNotificationManager.cancelAll();
        this.mExistNotificationIds = new HashMap();
    }

    public void setBridge(XWalkContentsClientBridge bridge) {
        this.mBridge = bridge;
    }

    private static String getCategoryFromNotificationId(int id2) {
        return XWALK_INTENT_CATEGORY_NOTIFICATION_PREFIX + id2;
    }

    private void notificationChanged() {
        this.unregisterReceiver();
        if (this.mExistNotificationIds.isEmpty()) {
            Log.i((String)TAG, (String)"notifications are all cleared,unregister broadcast receiver for close pending intent");
        } else {
            this.registerReceiver();
        }
    }

    private void registerReceiver() {
        this.mNotificationCloseReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                XWalkNotificationServiceImpl.this.mView.onNewIntent(intent);
            }
        };
        this.mNotificationCloseIntentFilter = new IntentFilter(this.mView.getActivity().getPackageName() + XWALK_ACTION_CLOSE_NOTIFICATION_SUFFIX);
        for (Integer id2 : this.mExistNotificationIds.keySet()) {
            this.mNotificationCloseIntentFilter.addCategory(XWalkNotificationServiceImpl.getCategoryFromNotificationId(id2));
        }
        try {
            this.mView.getActivity().registerReceiver(this.mNotificationCloseReceiver, this.mNotificationCloseIntentFilter);
        }
        catch (AndroidRuntimeException e) {
            this.mNotificationCloseReceiver = null;
            Log.w((String)TAG, (String)e.getLocalizedMessage());
        }
    }

    private void unregisterReceiver() {
        if (this.mNotificationCloseReceiver != null) {
            this.mView.getActivity().unregisterReceiver(this.mNotificationCloseReceiver);
            this.mNotificationCloseReceiver = null;
        }
    }

    public void shutdown() {
        this.unregisterReceiver();
        this.mBridge = null;
    }

    public boolean maybeHandleIntent(Intent intent) {
        if (intent.getAction() == null) {
            return false;
        }
        int notificationId = intent.getIntExtra(XWALK_INTENT_EXTRA_KEY_NOTIFICATION_ID, -1);
        long delegate = intent.getLongExtra(XWALK_INTENT_EXTRA_KEY_DELEGATE, -1L);
        if (notificationId <= 0) {
            return false;
        }
        if (intent.getAction().equals(this.mView.getActivity().getPackageName() + XWALK_ACTION_CLOSE_NOTIFICATION_SUFFIX)) {
            this.onNotificationClose(notificationId, true, delegate);
            return true;
        }
        if (intent.getAction().equals(this.mView.getActivity().getPackageName() + XWALK_ACTION_CLICK_NOTIFICATION_SUFFIX)) {
            this.onNotificationClick(notificationId, delegate);
            return true;
        }
        return false;
    }

    public void updateNotificationIcon(int notificationId, Bitmap icon) {
        Notification.Builder builder = this.mExistNotificationIds.get(notificationId);
        if (builder != null) {
            int originalWidth = icon.getWidth();
            int originalHeight = icon.getHeight();
            if (originalWidth == 0 || originalHeight == 0) {
                return;
            }
            int targetWidth = this.mContext.getResources().getDimensionPixelSize(0x1050005);
            int targetHeight = this.mContext.getResources().getDimensionPixelSize(17104902);
            if (originalWidth > targetWidth && originalHeight > targetHeight) {
                if (originalWidth * targetHeight > originalHeight * targetWidth) {
                    targetHeight = originalHeight * targetWidth / originalWidth;
                } else {
                    targetWidth = originalWidth * targetHeight / originalHeight;
                }
            }
            builder.setLargeIcon(Bitmap.createScaledBitmap((Bitmap)icon, (int)targetWidth, (int)targetHeight, (boolean)true));
            Notification notification = Build.VERSION.SDK_INT >= 16 ? builder.build() : builder.getNotification();
            this.doShowNotification(notificationId, notification);
            this.mExistNotificationIds.put(notificationId, builder);
        }
    }

    public void showNotification(String title, String message, int notificationId, long delegate) {
        Activity activity = this.mView.getActivity();
        String category = XWalkNotificationServiceImpl.getCategoryFromNotificationId(notificationId);
        Intent clickIntent = new Intent((Context)activity, activity.getClass());
        clickIntent.setAction(activity.getPackageName() + XWALK_ACTION_CLICK_NOTIFICATION_SUFFIX);
        clickIntent.putExtra(XWALK_INTENT_EXTRA_KEY_NOTIFICATION_ID, notificationId);
        clickIntent.putExtra(XWALK_INTENT_EXTRA_KEY_DELEGATE, delegate);
        clickIntent.setFlags(0x20100000);
        clickIntent.addCategory(category);
        PendingIntent pendingClickIntent = PendingIntent.getActivity((Context)activity, (int)0, (Intent)clickIntent, (int)0x8000000);
        Intent closeIntent = new Intent(activity.getPackageName() + XWALK_ACTION_CLOSE_NOTIFICATION_SUFFIX);
        closeIntent.putExtra(XWALK_INTENT_EXTRA_KEY_NOTIFICATION_ID, notificationId);
        closeIntent.putExtra(XWALK_INTENT_EXTRA_KEY_DELEGATE, delegate);
        closeIntent.addCategory(category);
        PendingIntent pendingCloseIntent = PendingIntent.getBroadcast((Context)activity, (int)0, (Intent)closeIntent, (int)0x8000000);
        Notification.Builder builder = new Notification.Builder(this.mContext.getApplicationContext()).setContentIntent(pendingClickIntent).setDeleteIntent(pendingCloseIntent);
        int iconRes = this.mContext.getApplicationInfo().icon;
        if (iconRes == 0) {
            iconRes = 17301651;
        }
        builder = builder.setContentText((CharSequence)message).setContentTitle((CharSequence)title).setSmallIcon(iconRes).setAutoCancel(true);
        Notification notification = Build.VERSION.SDK_INT >= 16 ? builder.build() : builder.getNotification();
        this.doShowNotification(notificationId, notification);
        this.mExistNotificationIds.put(notificationId, builder);
        this.notificationChanged();
        this.onNotificationShown(notificationId, delegate);
    }

    public void cancelNotification(int notificationId, long delegate) {
        this.mNotificationManager.cancel(notificationId);
        this.onNotificationClose(notificationId, false, delegate);
    }

    public void doShowNotification(int id2, Notification notification) {
        this.mNotificationManager.notify(id2, notification);
    }

    public void onNotificationShown(int notificationId, long delegate) {
        if (this.mExistNotificationIds.containsKey(notificationId) && this.mBridge != null) {
            this.mBridge.notificationDisplayed(delegate);
        }
    }

    public void onNotificationClick(int notificationId, long delegate) {
        if (this.mExistNotificationIds.containsKey(notificationId)) {
            this.mExistNotificationIds.remove(notificationId);
            this.notificationChanged();
            if (this.mBridge != null) {
                this.mBridge.notificationClicked(notificationId, delegate);
            }
        }
    }

    public void onNotificationClose(int notificationId, boolean byUser, long delegate) {
        if (this.mExistNotificationIds.containsKey(notificationId)) {
            this.mExistNotificationIds.remove(notificationId);
            this.notificationChanged();
            if (this.mBridge != null) {
                this.mBridge.notificationClosed(notificationId, byUser, delegate);
            }
        }
    }
}

