/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal;

import java.io.Serializable;
import org.chromium.content.browser.NavigationHistory;
import org.xwalk.core.internal.XWalkNavigationItemInternal;
import org.xwalk.core.internal.XWalkViewInternal;

public class XWalkNavigationHistoryInternal
implements Cloneable,
Serializable {
    private NavigationHistory mHistory;
    private XWalkViewInternal mXWalkView;

    XWalkNavigationHistoryInternal(XWalkViewInternal view, NavigationHistory history) {
        this.mXWalkView = view;
        this.mHistory = history;
    }

    public XWalkNavigationHistoryInternal(XWalkNavigationHistoryInternal history) {
        this.mXWalkView = history.mXWalkView;
        this.mHistory = history.mHistory;
    }

    public int size() {
        return this.mHistory.getEntryCount();
    }

    public boolean hasItemAt(int index) {
        return index >= 0 && index <= this.size() - 1;
    }

    public XWalkNavigationItemInternal getItemAt(int index) {
        if (index < 0 || index >= this.size()) {
            return null;
        }
        return new XWalkNavigationItemInternal(this.mHistory.getEntryAtIndex(index));
    }

    public XWalkNavigationItemInternal getCurrentItem() {
        return this.getItemAt(this.getCurrentIndex());
    }

    public boolean canGoBack() {
        return this.mXWalkView.canGoBack();
    }

    public boolean canGoForward() {
        return this.mXWalkView.canGoForward();
    }

    public void navigate(DirectionInternal direction, int steps) {
        switch (direction) {
            case FORWARD: {
                this.mXWalkView.navigateTo(steps);
                break;
            }
            case BACKWARD: {
                this.mXWalkView.navigateTo(-steps);
                break;
            }
        }
    }

    public int getCurrentIndex() {
        return this.mHistory.getCurrentEntryIndex();
    }

    public void clear() {
        this.mXWalkView.clearHistory();
    }

    protected synchronized XWalkNavigationHistoryInternal clone() {
        return new XWalkNavigationHistoryInternal(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DirectionInternal {
        BACKWARD,
        FORWARD;

    }
}

