/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.MediaPlayer;
import android.net.Uri;
import org.chromium.media.MediaPlayerBridge;
import org.xwalk.core.internal.AndroidProtocolHandler;

class XWalkMediaPlayerResourceLoadingFilter
extends MediaPlayerBridge.ResourceLoadingFilter {
    XWalkMediaPlayerResourceLoadingFilter() {
    }

    public boolean shouldOverrideResourceLoading(MediaPlayer mediaPlayer, Context context, Uri uri) {
        String scheme;
        if (uri.getScheme().equals("app")) {
            uri = AndroidProtocolHandler.appUriToFileUri(uri);
        }
        if (!(scheme = uri.getScheme()).equals("file")) {
            return false;
        }
        try {
            AssetFileDescriptor afd = context.getAssets().openFd(AndroidProtocolHandler.getAssetPath(uri));
            mediaPlayer.setDataSource(afd.getFileDescriptor(), afd.getStartOffset(), afd.getLength());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

