/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal;

import android.app.Activity;
import android.app.Dialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Display;
import android.view.KeyEvent;
import android.view.OrientationEventListener;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import java.util.ArrayList;
import org.chromium.content.browser.ContentViewRenderView;
import org.xwalk.core.internal.PageLoadListener;
import org.xwalk.core.internal.XWalkViewInternal;

public class XWalkLaunchScreenManager
implements ContentViewRenderView.FirstRenderedFrameListener,
DialogInterface.OnShowListener,
DialogInterface.OnDismissListener,
PageLoadListener {
    private static String mIntentFilterStr;
    private static final String BORDER_MODE_REPEAT = "repeat";
    private static final String BORDER_MODE_STRETCH = "stretch";
    private static final String BORDER_MODE_ROUND = "round";
    private XWalkViewInternal mXWalkView;
    private Activity mActivity;
    private Context mLibContext;
    private Dialog mLaunchScreenDialog;
    private boolean mPageLoadFinished;
    private ReadyWhenType mReadyWhen;
    private boolean mFirstFrameReceived;
    private BroadcastReceiver mLaunchScreenReadyWhenReceiver;
    private boolean mCustomHideLaunchScreen;
    private int mCurrentOrientation;
    private OrientationEventListener mOrientationListener;

    public XWalkLaunchScreenManager(Context context, XWalkViewInternal xwView) {
        this.mXWalkView = xwView;
        this.mLibContext = context;
        this.mActivity = this.mXWalkView.getActivity();
        mIntentFilterStr = this.mActivity.getPackageName() + ".hideLaunchScreen";
    }

    public void displayLaunchScreen(String readyWhen, final String imageBorderList) {
        if (this.mXWalkView == null) {
            return;
        }
        this.setReadyWhen(readyWhen);
        Runnable runnable = new Runnable(){

            public void run() {
                int bgResId = XWalkLaunchScreenManager.this.mActivity.getResources().getIdentifier("launchscreen_bg", "drawable", XWalkLaunchScreenManager.this.mActivity.getPackageName());
                if (bgResId == 0) {
                    return;
                }
                Drawable bgDrawable = XWalkLaunchScreenManager.this.mActivity.getResources().getDrawable(bgResId);
                if (bgDrawable == null) {
                    return;
                }
                XWalkLaunchScreenManager.this.mLaunchScreenDialog = new Dialog(XWalkLaunchScreenManager.this.mLibContext, 16974064);
                if ((((XWalkLaunchScreenManager)XWalkLaunchScreenManager.this).mActivity.getWindow().getAttributes().flags & 0x400) != 0) {
                    XWalkLaunchScreenManager.this.mLaunchScreenDialog.getWindow().setFlags(1024, 1024);
                }
                XWalkLaunchScreenManager.this.mLaunchScreenDialog.setOnKeyListener(new DialogInterface.OnKeyListener(){

                    public boolean onKey(DialogInterface arg0, int keyCode, KeyEvent event) {
                        if (keyCode == 4) {
                            XWalkLaunchScreenManager.this.performHideLaunchScreen();
                            XWalkLaunchScreenManager.this.mActivity.onBackPressed();
                        }
                        return true;
                    }
                });
                XWalkLaunchScreenManager.this.mLaunchScreenDialog.setOnShowListener((DialogInterface.OnShowListener)XWalkLaunchScreenManager.this);
                XWalkLaunchScreenManager.this.mLaunchScreenDialog.setOnDismissListener((DialogInterface.OnDismissListener)XWalkLaunchScreenManager.this);
                XWalkLaunchScreenManager.this.mLaunchScreenDialog.getWindow().setBackgroundDrawable(bgDrawable);
                RelativeLayout root = XWalkLaunchScreenManager.this.getLaunchScreenLayout(imageBorderList);
                if (root != null) {
                    XWalkLaunchScreenManager.this.mLaunchScreenDialog.setContentView((View)root);
                }
                XWalkLaunchScreenManager.this.mLaunchScreenDialog.show();
                XWalkLaunchScreenManager.this.mOrientationListener = new OrientationEventListener((Context)XWalkLaunchScreenManager.this.mActivity, 3){

                    public void onOrientationChanged(int ori) {
                        if (XWalkLaunchScreenManager.this.mLaunchScreenDialog == null || !XWalkLaunchScreenManager.this.mLaunchScreenDialog.isShowing()) {
                            return;
                        }
                        int orientation = XWalkLaunchScreenManager.this.getScreenOrientation();
                        if (orientation != XWalkLaunchScreenManager.this.mCurrentOrientation) {
                            RelativeLayout root = XWalkLaunchScreenManager.this.getLaunchScreenLayout(imageBorderList);
                            if (root == null) {
                                return;
                            }
                            XWalkLaunchScreenManager.this.mLaunchScreenDialog.setContentView((View)root);
                        }
                    }
                };
                XWalkLaunchScreenManager.this.mOrientationListener.enable();
                if (XWalkLaunchScreenManager.this.mReadyWhen == ReadyWhenType.CUSTOM) {
                    XWalkLaunchScreenManager.this.registerBroadcastReceiver();
                }
            }
        };
        this.mActivity.runOnUiThread(runnable);
    }

    public void onFirstFrameReceived() {
        this.mFirstFrameReceived = true;
        this.hideLaunchScreenWhenReady();
    }

    public void onShow(DialogInterface dialog) {
        this.mActivity.getWindow().setBackgroundDrawable(null);
        if (this.mFirstFrameReceived) {
            this.hideLaunchScreenWhenReady();
        }
    }

    public void onDismiss(DialogInterface dialog) {
        this.mOrientationListener.disable();
        this.mOrientationListener = null;
    }

    public void onPageFinished(String url) {
        this.mPageLoadFinished = true;
        this.hideLaunchScreenWhenReady();
    }

    public static String getHideLaunchScreenFilterStr() {
        return mIntentFilterStr;
    }

    public int getScreenOrientation() {
        Display display = this.mActivity.getWindowManager().getDefaultDisplay();
        Point size = new Point();
        display.getSize(size);
        int orientation = size.x < size.y ? 1 : 2;
        return orientation;
    }

    private RelativeLayout getLaunchScreenLayout(String imageBorderList) {
        int orientation;
        String[] borders = imageBorderList.split(";");
        if (borders.length < 1) {
            return this.parseImageBorder("");
        }
        this.mCurrentOrientation = orientation = this.getScreenOrientation();
        if (borders.length >= 2 && orientation == 2) {
            if (borders[1].equals("empty")) {
                return this.parseImageBorder("");
            }
            if (borders[1].isEmpty()) {
                return this.parseImageBorder(borders[0]);
            }
            return this.parseImageBorder(borders[1]);
        }
        if (borders.length == 3 && orientation == 1) {
            if (borders[2].equals("empty")) {
                return this.parseImageBorder("");
            }
            if (borders[2].isEmpty()) {
                return this.parseImageBorder(borders[0]);
            }
            return this.parseImageBorder(borders[2]);
        }
        return this.parseImageBorder(borders[0]);
    }

    private int getSuitableSize(int maxSize, int divider) {
        int finalSize = divider;
        float minMod = divider;
        while (divider > 1) {
            int mod = maxSize % divider;
            if (mod == 0) {
                finalSize = divider;
                break;
            }
            if ((float)mod < minMod) {
                minMod = mod;
                finalSize = divider;
            }
            --divider;
        }
        return finalSize;
    }

    private ImageView getSubImageView(Bitmap img, int x, int y, int width, int height, BorderModeType mode, int maxWidth, int maxHeight) {
        Rect subRect;
        if (img == null) {
            return null;
        }
        if (width <= 0 || height <= 0) {
            return null;
        }
        Rect imgRect = new Rect(0, 0, img.getWidth(), img.getHeight());
        if (!imgRect.contains(subRect = new Rect(x, y, x + width, y + height))) {
            return null;
        }
        Bitmap subImage = Bitmap.createBitmap((Bitmap)img, (int)x, (int)y, (int)width, (int)height);
        ImageView subImageView = new ImageView((Context)this.mActivity);
        if (mode == BorderModeType.ROUND) {
            Bitmap resizedBitmap;
            int originW = subImage.getWidth();
            int originH = subImage.getHeight();
            int newW = originW;
            int newH = originH;
            if (maxWidth > 0) {
                newW = this.getSuitableSize(maxWidth, originW);
            }
            if (maxHeight > 0) {
                newH = this.getSuitableSize(maxHeight, originH);
            }
            subImage = resizedBitmap = Bitmap.createScaledBitmap((Bitmap)subImage, (int)newW, (int)newH, (boolean)true);
            mode = BorderModeType.REPEAT;
        }
        if (mode == BorderModeType.REPEAT) {
            BitmapDrawable drawable2 = new BitmapDrawable(this.mActivity.getResources(), subImage);
            drawable2.setTileModeXY(Shader.TileMode.REPEAT, Shader.TileMode.REPEAT);
            subImageView.setImageDrawable((Drawable)drawable2);
            subImageView.setScaleType(ImageView.ScaleType.FIT_XY);
        } else if (mode == BorderModeType.STRETCH) {
            subImageView.setImageBitmap(subImage);
            subImageView.setScaleType(ImageView.ScaleType.FIT_XY);
        } else {
            subImageView.setImageBitmap(subImage);
        }
        return subImageView;
    }

    private int getStatusBarHeight() {
        int resourceId = this.mActivity.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            return this.mActivity.getResources().getDimensionPixelSize(resourceId);
        }
        return 25;
    }

    private RelativeLayout parseImageBorder(String imageBorder) {
        RelativeLayout.LayoutParams params;
        ImageView subImageView;
        int topBorder = 0;
        int rightBorder = 0;
        int leftBorder = 0;
        int bottomBorder = 0;
        BorderModeType horizontalMode = BorderModeType.STRETCH;
        BorderModeType verticalMode = BorderModeType.STRETCH;
        if (imageBorder.equals("empty")) {
            imageBorder = "";
        }
        String[] items = imageBorder.split(" ");
        ArrayList<String> borders = new ArrayList<String>();
        ArrayList<BorderModeType> modes = new ArrayList<BorderModeType>();
        for (int i = 0; i < items.length; ++i) {
            String item = items[i];
            if (item.endsWith("px")) {
                borders.add(item.replaceAll("px", ""));
                continue;
            }
            if (item.equals(BORDER_MODE_REPEAT)) {
                modes.add(BorderModeType.REPEAT);
                continue;
            }
            if (item.equals(BORDER_MODE_STRETCH)) {
                modes.add(BorderModeType.STRETCH);
                continue;
            }
            if (!item.equals(BORDER_MODE_ROUND)) continue;
            modes.add(BorderModeType.ROUND);
        }
        try {
            if (borders.size() == 1) {
                leftBorder = bottomBorder = Integer.valueOf((String)borders.get(0)).intValue();
                rightBorder = bottomBorder;
                topBorder = bottomBorder;
            } else if (borders.size() == 2) {
                topBorder = bottomBorder = Integer.valueOf((String)borders.get(0)).intValue();
                rightBorder = leftBorder = Integer.valueOf((String)borders.get(1)).intValue();
            } else if (borders.size() == 3) {
                rightBorder = leftBorder = Integer.valueOf((String)borders.get(1)).intValue();
                topBorder = Integer.valueOf((String)borders.get(0));
                bottomBorder = Integer.valueOf((String)borders.get(2));
            } else if (borders.size() == 4) {
                topBorder = Integer.valueOf((String)borders.get(0));
                rightBorder = Integer.valueOf((String)borders.get(1));
                leftBorder = Integer.valueOf((String)borders.get(2));
                bottomBorder = Integer.valueOf((String)borders.get(3));
            }
        }
        catch (NumberFormatException e) {
            bottomBorder = 0;
            leftBorder = 0;
            rightBorder = 0;
            topBorder = 0;
        }
        DisplayMetrics matrix = this.mActivity.getResources().getDisplayMetrics();
        topBorder = (int)TypedValue.applyDimension((int)1, (float)topBorder, (DisplayMetrics)matrix);
        rightBorder = (int)TypedValue.applyDimension((int)1, (float)rightBorder, (DisplayMetrics)matrix);
        leftBorder = (int)TypedValue.applyDimension((int)1, (float)leftBorder, (DisplayMetrics)matrix);
        bottomBorder = (int)TypedValue.applyDimension((int)1, (float)bottomBorder, (DisplayMetrics)matrix);
        if (modes.size() == 1) {
            horizontalMode = verticalMode = (BorderModeType)((Object)modes.get(0));
        } else if (modes.size() == 2) {
            horizontalMode = (BorderModeType)((Object)modes.get(0));
            verticalMode = (BorderModeType)((Object)modes.get(1));
        }
        int imgResId = this.mActivity.getResources().getIdentifier("launchscreen_img", "drawable", this.mActivity.getPackageName());
        if (imgResId == 0) {
            return null;
        }
        Bitmap img = BitmapFactory.decodeResource((Resources)this.mActivity.getResources(), (int)imgResId);
        if (img == null) {
            return null;
        }
        RelativeLayout root = new RelativeLayout((Context)this.mActivity);
        root.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        if (borders.size() == 0) {
            ImageView subImageView2 = new ImageView((Context)this.mActivity);
            subImageView2.setImageBitmap(img);
            RelativeLayout.LayoutParams params2 = new RelativeLayout.LayoutParams(-2, -2);
            params2.addRule(13, -1);
            root.addView((View)subImageView2, (ViewGroup.LayoutParams)params2);
            return root;
        }
        Display display = this.mActivity.getWindowManager().getDefaultDisplay();
        Point size = new Point();
        display.getSize(size);
        if ((this.mActivity.getWindow().getAttributes().flags & 0x400) == 0) {
            size.y -= this.getStatusBarHeight();
        }
        if ((subImageView = this.getSubImageView(img, 0, 0, leftBorder, topBorder, BorderModeType.NONE, 0, 0)) != null) {
            params = new RelativeLayout.LayoutParams(-2, -2);
            params.addRule(9, -1);
            params.addRule(10, -1);
            root.addView((View)subImageView, (ViewGroup.LayoutParams)params);
        }
        if ((subImageView = this.getSubImageView(img, leftBorder, 0, img.getWidth() - leftBorder - rightBorder, topBorder, horizontalMode, size.x - leftBorder - rightBorder, 0)) != null) {
            params = new RelativeLayout.LayoutParams(-1, -2);
            params.addRule(10, -1);
            params.addRule(14, -1);
            params.leftMargin = leftBorder;
            params.rightMargin = rightBorder;
            root.addView((View)subImageView, (ViewGroup.LayoutParams)params);
        }
        if ((subImageView = this.getSubImageView(img, img.getWidth() - rightBorder, 0, rightBorder, topBorder, BorderModeType.NONE, 0, 0)) != null) {
            params = new RelativeLayout.LayoutParams(-2, -2);
            params.addRule(11, -1);
            params.addRule(10, -1);
            root.addView((View)subImageView, (ViewGroup.LayoutParams)params);
        }
        if ((subImageView = this.getSubImageView(img, 0, topBorder, leftBorder, img.getHeight() - topBorder - bottomBorder, verticalMode, 0, size.y - topBorder - bottomBorder)) != null) {
            params = new RelativeLayout.LayoutParams(-2, -1);
            params.addRule(9, -1);
            params.addRule(13, -1);
            params.topMargin = topBorder;
            params.bottomMargin = bottomBorder;
            root.addView((View)subImageView, (ViewGroup.LayoutParams)params);
        }
        if ((subImageView = this.getSubImageView(img, leftBorder, topBorder, img.getWidth() - leftBorder - rightBorder, img.getHeight() - topBorder - bottomBorder, BorderModeType.NONE, 0, 0)) != null) {
            subImageView.setScaleType(ImageView.ScaleType.FIT_XY);
            params = new RelativeLayout.LayoutParams(-1, -1);
            params.leftMargin = leftBorder;
            params.topMargin = topBorder;
            params.rightMargin = rightBorder;
            params.bottomMargin = bottomBorder;
            root.addView((View)subImageView, (ViewGroup.LayoutParams)params);
        }
        if ((subImageView = this.getSubImageView(img, img.getWidth() - rightBorder, topBorder, rightBorder, img.getHeight() - topBorder - bottomBorder, verticalMode, 0, size.y - topBorder - bottomBorder)) != null) {
            params = new RelativeLayout.LayoutParams(-2, -1);
            params.addRule(13, -1);
            params.addRule(11, -1);
            params.topMargin = topBorder;
            params.bottomMargin = bottomBorder;
            root.addView((View)subImageView, (ViewGroup.LayoutParams)params);
        }
        if ((subImageView = this.getSubImageView(img, 0, img.getHeight() - bottomBorder, leftBorder, bottomBorder, BorderModeType.NONE, 0, 0)) != null) {
            params = new RelativeLayout.LayoutParams(-2, -2);
            params.addRule(9, -1);
            params.addRule(12, -1);
            root.addView((View)subImageView, (ViewGroup.LayoutParams)params);
        }
        if ((subImageView = this.getSubImageView(img, leftBorder, img.getHeight() - bottomBorder, img.getWidth() - leftBorder - rightBorder, bottomBorder, horizontalMode, size.x - leftBorder - rightBorder, 0)) != null) {
            params = new RelativeLayout.LayoutParams(-1, -2);
            params.addRule(14, -1);
            params.addRule(12, -1);
            params.leftMargin = leftBorder;
            params.rightMargin = rightBorder;
            root.addView((View)subImageView, (ViewGroup.LayoutParams)params);
        }
        if ((subImageView = this.getSubImageView(img, img.getWidth() - rightBorder, img.getHeight() - bottomBorder, rightBorder, bottomBorder, BorderModeType.NONE, 0, 0)) != null) {
            params = new RelativeLayout.LayoutParams(-2, -2);
            params.addRule(11, -1);
            params.addRule(12, -1);
            root.addView((View)subImageView, (ViewGroup.LayoutParams)params);
        }
        return root;
    }

    private void registerBroadcastReceiver() {
        IntentFilter intentFilter = new IntentFilter(mIntentFilterStr);
        this.mLaunchScreenReadyWhenReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                XWalkLaunchScreenManager.this.mCustomHideLaunchScreen = true;
                XWalkLaunchScreenManager.this.hideLaunchScreenWhenReady();
            }
        };
        this.mActivity.registerReceiver(this.mLaunchScreenReadyWhenReceiver, intentFilter);
    }

    private void hideLaunchScreenWhenReady() {
        if (this.mLaunchScreenDialog == null || !this.mFirstFrameReceived) {
            return;
        }
        if (this.mReadyWhen == ReadyWhenType.FIRST_PAINT) {
            this.performHideLaunchScreen();
        } else if (this.mReadyWhen == ReadyWhenType.USER_INTERACTIVE) {
            this.performHideLaunchScreen();
        } else if (this.mReadyWhen == ReadyWhenType.COMPLETE) {
            if (this.mPageLoadFinished) {
                this.performHideLaunchScreen();
            }
        } else if (this.mReadyWhen == ReadyWhenType.CUSTOM && this.mCustomHideLaunchScreen) {
            this.performHideLaunchScreen();
        }
    }

    private void performHideLaunchScreen() {
        this.mLaunchScreenDialog.dismiss();
        this.mLaunchScreenDialog = null;
        if (this.mReadyWhen == ReadyWhenType.CUSTOM) {
            this.mActivity.unregisterReceiver(this.mLaunchScreenReadyWhenReceiver);
        }
    }

    private void setReadyWhen(String readyWhen) {
        this.mReadyWhen = readyWhen.equals("first-paint") ? ReadyWhenType.FIRST_PAINT : (readyWhen.equals("user-interactive") ? ReadyWhenType.USER_INTERACTIVE : (readyWhen.equals("complete") ? ReadyWhenType.COMPLETE : (readyWhen.equals("custom") ? ReadyWhenType.CUSTOM : ReadyWhenType.FIRST_PAINT)));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BorderModeType {
        REPEAT,
        STRETCH,
        ROUND,
        NONE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ReadyWhenType {
        FIRST_PAINT,
        USER_INTERACTIVE,
        COMPLETE,
        CUSTOM;

    }
}

