/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal;

import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;

@JNINamespace(value="xwalk")
public class XWalkHttpAuthHandler {
    private long mNativeXWalkHttpAuthHandler;
    private final boolean mFirstAttempt;

    public void proceed(String username, String password) {
        if (this.mNativeXWalkHttpAuthHandler != 0L) {
            this.nativeProceed(this.mNativeXWalkHttpAuthHandler, username, password);
            this.mNativeXWalkHttpAuthHandler = 0L;
        }
    }

    public void cancel() {
        if (this.mNativeXWalkHttpAuthHandler != 0L) {
            this.nativeCancel(this.mNativeXWalkHttpAuthHandler);
            this.mNativeXWalkHttpAuthHandler = 0L;
        }
    }

    public boolean isFirstAttempt() {
        return this.mFirstAttempt;
    }

    @CalledByNative
    public static XWalkHttpAuthHandler create(long nativeXWalkAuthHandler, boolean firstAttempt) {
        return new XWalkHttpAuthHandler(nativeXWalkAuthHandler, firstAttempt);
    }

    private XWalkHttpAuthHandler(long nativeXWalkHttpAuthHandler, boolean firstAttempt) {
        this.mNativeXWalkHttpAuthHandler = nativeXWalkHttpAuthHandler;
        this.mFirstAttempt = firstAttempt;
    }

    @CalledByNative
    void handlerDestroyed() {
        this.mNativeXWalkHttpAuthHandler = 0L;
    }

    private native void nativeProceed(long var1, String var3, String var4);

    private native void nativeCancel(long var1);
}

