/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal;

import android.app.DownloadManager;
import android.content.Context;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Environment;
import android.webkit.MimeTypeMap;
import android.webkit.URLUtil;
import android.widget.Toast;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.xwalk.core.internal.AndroidProtocolHandler;
import org.xwalk.core.internal.DownloadListener;
import org.xwalk.core.internal.R;

class XWalkDownloadListenerImpl
implements DownloadListener {
    private static String DOWNLOAD_START_TOAST;
    private static String DOWNLOAD_NO_PERMISSION_TOAST;
    private static String DOWNLOAD_ALREADY_EXISTS_TOAST;
    private static String DOWNLOAD_FAILED_TOAST;
    private static String DOWNLOAD_FINISHED_TOAST;
    private Context mContext;

    public XWalkDownloadListenerImpl(Context context) {
        this.mContext = context;
        DOWNLOAD_START_TOAST = this.mContext.getString(R.string.download_start_toast);
        DOWNLOAD_NO_PERMISSION_TOAST = this.mContext.getString(R.string.download_no_permission_toast);
        DOWNLOAD_ALREADY_EXISTS_TOAST = this.mContext.getString(R.string.download_already_exists_toast);
        DOWNLOAD_FAILED_TOAST = this.mContext.getString(R.string.download_failed_toast);
        DOWNLOAD_FINISHED_TOAST = this.mContext.getString(R.string.download_finished_toast);
    }

    public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimetype, long contentLength) {
        String fileName = this.getFileName(url, contentDisposition, mimetype);
        if (!this.checkWriteExternalPermission()) {
            return;
        }
        Uri src = Uri.parse((String)url);
        if (src.getScheme().equals("http") || src.getScheme().equals("https")) {
            DownloadManager.Request request = new DownloadManager.Request(Uri.parse((String)url));
            request.setDestinationInExternalPublicDir(Environment.DIRECTORY_DOWNLOADS, fileName);
            this.getDownloadManager().enqueue(request);
            this.popupMessages(DOWNLOAD_START_TOAST + fileName);
        } else {
            new FileTransfer(url, fileName).execute(new Void[0]);
        }
    }

    private String getFileName(String url, String contentDisposition, String mimetype) {
        String fileName = URLUtil.guessFileName((String)url, (String)contentDisposition, (String)mimetype);
        int extensionIndex = fileName.lastIndexOf(".");
        String extension = null;
        if (extensionIndex > 1 && extensionIndex < fileName.length()) {
            extension = fileName.substring(extensionIndex + 1);
        }
        if (extension == null && (extension = MimeTypeMap.getSingleton().getExtensionFromMimeType(mimetype)) != null) {
            fileName = fileName + "." + extension;
        }
        return fileName;
    }

    private DownloadManager getDownloadManager() {
        DownloadManager downloadManager = (DownloadManager)this.mContext.getSystemService("download");
        return downloadManager;
    }

    private boolean checkWriteExternalPermission() {
        int result = this.mContext.checkCallingOrSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE");
        if (result == 0) {
            return true;
        }
        this.popupMessages(DOWNLOAD_NO_PERMISSION_TOAST);
        return false;
    }

    private void popupMessages(String message) {
        Toast.makeText((Context)this.mContext, (CharSequence)message, (int)0).show();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileTransfer
    extends AsyncTask<Void, Void, String> {
        String url;
        String fileName;

        public FileTransfer(String url, String fileName) {
            this.url = url;
            this.fileName = fileName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected String doInBackground(Void ... params) {
            FileOutputStream dstStream = null;
            InputStream srcStream = null;
            File dir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS);
            File dst = new File(dir, this.fileName);
            if (dst.exists()) {
                return "Existed";
            }
            try {
                dstStream = new FileOutputStream(dst);
                srcStream = AndroidProtocolHandler.open(XWalkDownloadListenerImpl.this.mContext, this.url);
                if (dstStream != null && srcStream != null) {
                    this.streamTransfer(srcStream, dstStream);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (srcStream != null) {
                        srcStream.close();
                    }
                    if (dstStream != null) {
                        ((OutputStream)dstStream).close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return "Failed";
                }
            }
            return "Finished";
        }

        protected void onPostExecute(String result) {
            if (result.equals("Failed")) {
                XWalkDownloadListenerImpl.this.popupMessages(DOWNLOAD_FAILED_TOAST);
            } else if (result.equals("Existed")) {
                XWalkDownloadListenerImpl.this.popupMessages(DOWNLOAD_ALREADY_EXISTS_TOAST);
            } else if (result.equals("Finished")) {
                XWalkDownloadListenerImpl.this.popupMessages(DOWNLOAD_FINISHED_TOAST);
            }
        }

        private void streamTransfer(InputStream src, OutputStream dst) throws IOException {
            byte[] buf = new byte[1024];
            int length = 0;
            while ((length = src.read(buf)) > 0) {
                dst.write(buf, 0, length);
            }
        }
    }
}

