/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal;

import android.content.ActivityNotFoundException;
import android.content.ContentResolver;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.Picture;
import android.net.Uri;
import android.net.http.SslCertificate;
import android.net.http.SslError;
import android.os.Message;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.webkit.ConsoleMessage;
import android.webkit.ValueCallback;
import android.webkit.WebResourceResponse;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.components.navigation_interception.InterceptNavigationDelegate;
import org.chromium.components.navigation_interception.NavigationParams;
import org.chromium.content.browser.ContentVideoViewClient;
import org.chromium.content.browser.ContentViewDownloadDelegate;
import org.chromium.content.browser.DownloadInfo;
import org.xwalk.core.internal.DownloadListener;
import org.xwalk.core.internal.PageLoadListener;
import org.xwalk.core.internal.SslUtil;
import org.xwalk.core.internal.XWalkClient;
import org.xwalk.core.internal.XWalkContentVideoViewClient;
import org.xwalk.core.internal.XWalkContentsClient;
import org.xwalk.core.internal.XWalkGeolocationPermissions;
import org.xwalk.core.internal.XWalkHttpAuthHandler;
import org.xwalk.core.internal.XWalkJavascriptResultHandlerInternal;
import org.xwalk.core.internal.XWalkNavigationHandler;
import org.xwalk.core.internal.XWalkNotificationService;
import org.xwalk.core.internal.XWalkResourceClientInternal;
import org.xwalk.core.internal.XWalkUIClientInternal;
import org.xwalk.core.internal.XWalkViewInternal;
import org.xwalk.core.internal.XWalkWebChromeClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JNINamespace(value="xwalk")
class XWalkContentsClientBridge
extends XWalkContentsClient
implements ContentViewDownloadDelegate {
    private static final String TAG = XWalkContentsClientBridge.class.getName();
    private XWalkViewInternal mXWalkView;
    private XWalkUIClientInternal mXWalkUIClient;
    private XWalkResourceClientInternal mXWalkResourceClient;
    private XWalkClient mXWalkClient;
    private XWalkWebChromeClient mXWalkWebChromeClient;
    private Bitmap mFavicon;
    private DownloadListener mDownloadListener;
    private InterceptNavigationDelegate mInterceptNavigationDelegate;
    private PageLoadListener mPageLoadListener;
    private XWalkNavigationHandler mNavigationHandler;
    private XWalkNotificationService mNotificationService;
    private boolean mIsFullscreen = false;
    private XWalkUIClientInternal.LoadStatusInternal mLoadStatus = XWalkUIClientInternal.LoadStatusInternal.FINISHED;
    private String mLoadingUrl = null;
    private long mNativeContentsClientBridge;
    private float mPageScaleFactor;

    public XWalkContentsClientBridge(XWalkViewInternal xwView) {
        this.mXWalkView = xwView;
        this.mInterceptNavigationDelegate = new InterceptNavigationDelegateImpl(this);
    }

    public void setUIClient(XWalkUIClientInternal client) {
        if (client != null) {
            this.mXWalkUIClient = client;
            return;
        }
        this.mXWalkUIClient = new XWalkUIClientInternal(this.mXWalkView);
    }

    public void setResourceClient(XWalkResourceClientInternal client) {
        if (client != null) {
            this.mXWalkResourceClient = client;
            return;
        }
        this.mXWalkResourceClient = new XWalkResourceClientInternal(this.mXWalkView);
    }

    public void setXWalkWebChromeClient(XWalkWebChromeClient client) {
        if (client == null) {
            return;
        }
        client.setContentsClient(this);
        this.mXWalkWebChromeClient = client;
    }

    public XWalkWebChromeClient getXWalkWebChromeClient() {
        return this.mXWalkWebChromeClient;
    }

    public void setXWalkClient(XWalkClient client) {
        this.mXWalkClient = client;
    }

    public void setNavigationHandler(XWalkNavigationHandler handler) {
        this.mNavigationHandler = handler;
    }

    void registerPageLoadListener(PageLoadListener listener) {
        this.mPageLoadListener = listener;
    }

    public void setNotificationService(XWalkNotificationService service) {
        if (this.mNotificationService != null) {
            this.mNotificationService.shutdown();
        }
        this.mNotificationService = service;
        if (this.mNotificationService != null) {
            this.mNotificationService.setBridge(this);
        }
    }

    public boolean onNewIntent(Intent intent) {
        return this.mNotificationService.maybeHandleIntent(intent);
    }

    public InterceptNavigationDelegate getInterceptNavigationDelegate() {
        return this.mInterceptNavigationDelegate;
    }

    private boolean isOwnerActivityRunning() {
        return this.mXWalkView != null && this.mXWalkView.isOwnerActivityRunning();
    }

    @Override
    public boolean shouldOverrideUrlLoading(String url) {
        if (this.mXWalkResourceClient != null && this.mXWalkView != null) {
            return this.mXWalkResourceClient.shouldOverrideUrlLoading(this.mXWalkView, url);
        }
        return false;
    }

    @Override
    public boolean shouldOverrideKeyEvent(KeyEvent event) {
        boolean overridden = false;
        if (this.mXWalkUIClient != null && this.mXWalkView != null) {
            overridden = this.mXWalkUIClient.shouldOverrideKeyEvent(this.mXWalkView, event);
        }
        if (!overridden) {
            return super.shouldOverrideKeyEvent(event);
        }
        return overridden;
    }

    @Override
    public void onUnhandledKeyEvent(KeyEvent event) {
        if (this.mXWalkUIClient != null && this.mXWalkView != null) {
            this.mXWalkUIClient.onUnhandledKeyEvent(this.mXWalkView, event);
        }
    }

    @Override
    public void getVisitedHistory(ValueCallback<String[]> callback) {
    }

    @Override
    public void doUpdateVisitedHistory(String url, boolean isReload) {
    }

    @Override
    public void onProgressChanged(int progress) {
        if (this.isOwnerActivityRunning()) {
            this.mXWalkResourceClient.onProgressChanged(this.mXWalkView, progress);
        }
    }

    @Override
    public WebResourceResponse shouldInterceptRequest(String url) {
        if (this.isOwnerActivityRunning()) {
            return this.mXWalkResourceClient.shouldInterceptLoadRequest(this.mXWalkView, url);
        }
        return null;
    }

    @Override
    public void onResourceLoadStarted(String url) {
        if (this.isOwnerActivityRunning()) {
            this.mXWalkResourceClient.onLoadStarted(this.mXWalkView, url);
        }
    }

    @Override
    public void onResourceLoadFinished(String url) {
        if (this.isOwnerActivityRunning()) {
            this.mXWalkResourceClient.onLoadFinished(this.mXWalkView, url);
        }
    }

    @Override
    public void onLoadResource(String url) {
        if (this.mXWalkClient != null && this.isOwnerActivityRunning()) {
            this.mXWalkClient.onLoadResource(this.mXWalkView, url);
        }
    }

    @Override
    public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
        return false;
    }

    @Override
    @CalledByNative
    public void onReceivedHttpAuthRequest(XWalkHttpAuthHandler handler, String host, String realm) {
        if (this.mXWalkClient != null && this.isOwnerActivityRunning()) {
            this.mXWalkClient.onReceivedHttpAuthRequest(this.mXWalkView, handler, host, realm);
        }
    }

    @Override
    public void onReceivedSslError(ValueCallback<Boolean> callback, SslError error) {
        if (this.mXWalkClient != null && this.isOwnerActivityRunning()) {
            this.mXWalkClient.onReceivedSslError(this.mXWalkView, callback, error);
        }
    }

    @Override
    public void onReceivedLoginRequest(String realm, String account, String args) {
    }

    @Override
    public void onGeolocationPermissionsShowPrompt(String origin, XWalkGeolocationPermissions.Callback callback) {
        if (this.mXWalkWebChromeClient != null && this.isOwnerActivityRunning()) {
            this.mXWalkWebChromeClient.onGeolocationPermissionsShowPrompt(origin, callback);
        }
    }

    @Override
    public void onGeolocationPermissionsHidePrompt() {
        if (this.mXWalkWebChromeClient != null && this.isOwnerActivityRunning()) {
            this.mXWalkWebChromeClient.onGeolocationPermissionsHidePrompt();
        }
    }

    @Override
    public void onFindResultReceived(int activeMatchOrdinal, int numberOfMatches, boolean isDoneCounting) {
    }

    @Override
    public void onNewPicture(Picture picture) {
    }

    @Override
    public void onPageStarted(String url) {
        if (this.mXWalkUIClient != null && this.isOwnerActivityRunning()) {
            this.mLoadingUrl = url;
            this.mLoadStatus = XWalkUIClientInternal.LoadStatusInternal.FINISHED;
            this.mXWalkUIClient.onPageLoadStarted(this.mXWalkView, url);
        }
    }

    @Override
    public void onPageFinished(String url) {
        if (!this.isOwnerActivityRunning()) {
            return;
        }
        if (this.mPageLoadListener != null) {
            this.mPageLoadListener.onPageFinished(url);
        }
        if (this.mXWalkUIClient != null) {
            if (this.mLoadStatus == XWalkUIClientInternal.LoadStatusInternal.CANCELLED && this.mLoadingUrl != null) {
                this.mXWalkUIClient.onPageLoadStopped(this.mXWalkView, this.mLoadingUrl, this.mLoadStatus);
            } else {
                this.mXWalkUIClient.onPageLoadStopped(this.mXWalkView, url, this.mLoadStatus);
            }
            this.mLoadingUrl = null;
        }
        this.onResourceLoadFinished(url);
    }

    @Override
    protected void onStopLoading() {
        this.mLoadStatus = XWalkUIClientInternal.LoadStatusInternal.CANCELLED;
    }

    @Override
    public void onReceivedError(int errorCode, String description, String failingUrl) {
        if (this.isOwnerActivityRunning()) {
            if (this.mLoadingUrl != null && this.mLoadingUrl.equals(failingUrl)) {
                this.mLoadStatus = XWalkUIClientInternal.LoadStatusInternal.FAILED;
            }
            this.mXWalkResourceClient.onReceivedLoadError(this.mXWalkView, errorCode, description, failingUrl);
        }
    }

    @Override
    public void onRendererUnresponsive() {
        if (this.mXWalkClient != null && this.isOwnerActivityRunning()) {
            this.mXWalkClient.onRendererUnresponsive(this.mXWalkView);
        }
    }

    @Override
    public void onRendererResponsive() {
        if (this.mXWalkClient != null && this.isOwnerActivityRunning()) {
            this.mXWalkClient.onRendererResponsive(this.mXWalkView);
        }
    }

    @Override
    public void onFormResubmission(Message dontResend, Message resend) {
        dontResend.sendToTarget();
    }

    @Override
    public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimeType, long contentLength) {
    }

    @Override
    public boolean onCreateWindow(boolean isDialog, boolean isUserGesture) {
        return false;
    }

    @Override
    public void onRequestFocus() {
        if (this.isOwnerActivityRunning()) {
            this.mXWalkUIClient.onRequestFocus(this.mXWalkView);
        }
    }

    @Override
    public void onCloseWindow() {
        if (this.isOwnerActivityRunning()) {
            this.mXWalkUIClient.onJavascriptCloseWindow(this.mXWalkView);
        }
    }

    @Override
    public void onReceivedIcon(Bitmap bitmap) {
        if (this.mXWalkWebChromeClient != null && this.mXWalkView != null) {
            this.mXWalkWebChromeClient.onReceivedIcon(this.mXWalkView, bitmap);
        }
        this.mFavicon = bitmap;
    }

    @Override
    public void onShowCustomView(View view, XWalkWebChromeClient.CustomViewCallback callback) {
        if (this.mXWalkWebChromeClient != null && this.isOwnerActivityRunning()) {
            this.mXWalkWebChromeClient.onShowCustomView(view, callback);
        }
    }

    @Override
    public void onHideCustomView() {
        if (this.mXWalkWebChromeClient != null && this.isOwnerActivityRunning()) {
            this.mXWalkWebChromeClient.onHideCustomView();
        }
    }

    @Override
    public void onScaleChangedScaled(float oldScale, float newScale) {
        if (this.isOwnerActivityRunning()) {
            this.mXWalkUIClient.onScaleChanged(this.mXWalkView, oldScale, newScale);
        }
    }

    @Override
    public void didFinishLoad(String url) {
    }

    @Override
    public void onTitleChanged(String title) {
        if (this.mXWalkUIClient != null && this.isOwnerActivityRunning()) {
            this.mXWalkUIClient.onReceivedTitle(this.mXWalkView, title);
        }
    }

    @Override
    public void onToggleFullscreen(boolean enterFullscreen) {
        if (this.isOwnerActivityRunning()) {
            this.mIsFullscreen = enterFullscreen;
            this.mXWalkUIClient.onFullscreenToggled(this.mXWalkView, enterFullscreen);
        }
    }

    @Override
    public boolean hasEnteredFullscreen() {
        return this.mIsFullscreen;
    }

    @Override
    public boolean shouldOpenWithDefaultBrowser(String contentUrl) {
        Intent intent = new Intent();
        intent.setAction("android.intent.action.VIEW");
        Uri url = Uri.parse((String)contentUrl);
        intent.setData(url);
        try {
            this.mXWalkView.getActivity().startActivity(intent);
        }
        catch (ActivityNotFoundException exception) {
            Log.w((String)TAG, (String)"Activity not found for Intent:");
            return false;
        }
        return true;
    }

    @Override
    public boolean shouldOverrideRunFileChooser(final int processId, final int renderId, final int modeFlags, String acceptTypes, boolean capture) {
        if (!this.isOwnerActivityRunning()) {
            return false;
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        abstract class UriCallback
        implements ValueCallback<Uri> {
            boolean syncNullReceived = false;
            boolean syncCallFinished = false;

            UriCallback() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected String resolveFileName(Uri uri, ContentResolver contentResolver) {
                if (contentResolver == null || uri == null) {
                    return "";
                }
                Cursor cursor = null;
                try {
                    cursor = contentResolver.query(uri, null, null, null, null);
                    if (cursor != null && cursor.getCount() >= 1) {
                        cursor.moveToFirst();
                        int index = cursor.getColumnIndex("_display_name");
                        if (index > -1) {
                            String string2 = cursor.getString(index);
                            return string2;
                        }
                    }
                }
                catch (NullPointerException e) {
                    String string3 = "";
                    return string3;
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                return "";
            }
        }
        UriCallback uploadFile = new UriCallback(){
            boolean completed;
            {
                this.completed = false;
            }

            public void onReceiveValue(Uri value) {
                if (this.completed) {
                    throw new IllegalStateException("Duplicate openFileChooser result");
                }
                this.completed = true;
                if (value == null && !this.syncCallFinished) {
                    this.syncNullReceived = true;
                    return;
                }
                if (value == null) {
                    XWalkContentsClientBridge.this.nativeOnFilesNotSelected(XWalkContentsClientBridge.this.mNativeContentsClientBridge, processId, renderId, modeFlags);
                } else {
                    String result = "";
                    String displayName = null;
                    if ("file".equals(value.getScheme())) {
                        result = value.getSchemeSpecificPart();
                        displayName = value.getLastPathSegment();
                    } else if ("content".equals(value.getScheme())) {
                        result = value.toString();
                        displayName = this.resolveFileName(value, XWalkContentsClientBridge.this.mXWalkView.getActivity().getContentResolver());
                    } else {
                        result = value.getPath();
                        displayName = value.getLastPathSegment();
                    }
                    if (displayName == null || displayName.isEmpty()) {
                        displayName = result;
                    }
                    XWalkContentsClientBridge.this.nativeOnFilesSelected(XWalkContentsClientBridge.this.mNativeContentsClientBridge, processId, renderId, modeFlags, result, displayName);
                }
            }
        };
        this.mXWalkUIClient.openFileChooser(this.mXWalkView, uploadFile, acceptTypes, Boolean.toString(capture));
        uploadFile.syncCallFinished = true;
        return !uploadFile.syncNullReceived;
    }

    @Override
    public ContentVideoViewClient getContentVideoViewClient() {
        return new XWalkContentVideoViewClient(this, this.mXWalkView.getActivity(), this.mXWalkView);
    }

    @CalledByNative
    private void setNativeContentsClientBridge(long nativeContentsClientBridge) {
        this.mNativeContentsClientBridge = nativeContentsClientBridge;
    }

    @CalledByNative
    private boolean allowCertificateError(int certError, byte[] derBytes, String url, final int id2) {
        SslCertificate cert = SslUtil.getCertificateFromDerBytes(derBytes);
        if (cert == null) {
            return false;
        }
        SslError sslError = SslUtil.sslErrorFromNetErrorCode(certError, cert, url);
        ValueCallback<Boolean> callback = new ValueCallback<Boolean>(){

            public void onReceiveValue(Boolean value) {
                XWalkContentsClientBridge.this.proceedSslError(value, id2);
            }
        };
        this.onReceivedSslError(callback, sslError);
        return true;
    }

    private void proceedSslError(boolean proceed, int id2) {
        if (this.mNativeContentsClientBridge == 0L) {
            return;
        }
        this.nativeProceedSslError(this.mNativeContentsClientBridge, proceed, id2);
    }

    @CalledByNative
    private void handleJsAlert(String url, String message, int id2) {
        if (this.isOwnerActivityRunning()) {
            XWalkJavascriptResultHandlerInternal result = new XWalkJavascriptResultHandlerInternal(this, id2);
            this.mXWalkUIClient.onJavascriptModalDialog(this.mXWalkView, XWalkUIClientInternal.JavascriptMessageTypeInternal.JAVASCRIPT_ALERT, url, message, "", result);
        }
    }

    @CalledByNative
    private void handleJsConfirm(String url, String message, int id2) {
        if (this.isOwnerActivityRunning()) {
            XWalkJavascriptResultHandlerInternal result = new XWalkJavascriptResultHandlerInternal(this, id2);
            this.mXWalkUIClient.onJavascriptModalDialog(this.mXWalkView, XWalkUIClientInternal.JavascriptMessageTypeInternal.JAVASCRIPT_CONFIRM, url, message, "", result);
        }
    }

    @CalledByNative
    private void handleJsPrompt(String url, String message, String defaultValue, int id2) {
        if (this.isOwnerActivityRunning()) {
            XWalkJavascriptResultHandlerInternal result = new XWalkJavascriptResultHandlerInternal(this, id2);
            this.mXWalkUIClient.onJavascriptModalDialog(this.mXWalkView, XWalkUIClientInternal.JavascriptMessageTypeInternal.JAVASCRIPT_PROMPT, url, message, defaultValue, result);
        }
    }

    @CalledByNative
    private void handleJsBeforeUnload(String url, String message, int id2) {
        if (this.isOwnerActivityRunning()) {
            XWalkJavascriptResultHandlerInternal result = new XWalkJavascriptResultHandlerInternal(this, id2);
            this.mXWalkUIClient.onJavascriptModalDialog(this.mXWalkView, XWalkUIClientInternal.JavascriptMessageTypeInternal.JAVASCRIPT_BEFOREUNLOAD, url, message, "", result);
        }
    }

    @CalledByNative
    private void updateNotificationIcon(int notificationId, Bitmap icon) {
        this.mNotificationService.updateNotificationIcon(notificationId, icon);
    }

    @CalledByNative
    private void showNotification(String title, String message, String replaceId, int notificationId, long delegate) {
        this.mNotificationService.showNotification(title, message, notificationId, delegate);
    }

    @CalledByNative
    private void cancelNotification(int notificationId, long delegate) {
        this.mNotificationService.cancelNotification(notificationId, delegate);
    }

    void confirmJsResult(int id2, String prompt) {
        if (this.mNativeContentsClientBridge == 0L) {
            return;
        }
        this.nativeConfirmJsResult(this.mNativeContentsClientBridge, id2, prompt);
    }

    void cancelJsResult(int id2) {
        if (this.mNativeContentsClientBridge == 0L) {
            return;
        }
        this.nativeCancelJsResult(this.mNativeContentsClientBridge, id2);
    }

    void exitFullscreen(long nativeWebContents) {
        if (this.mNativeContentsClientBridge == 0L) {
            return;
        }
        this.nativeExitFullscreen(this.mNativeContentsClientBridge, nativeWebContents);
    }

    public void notificationDisplayed(long delegate) {
        if (this.mNativeContentsClientBridge == 0L) {
            return;
        }
        this.nativeNotificationDisplayed(this.mNativeContentsClientBridge, delegate);
    }

    public void notificationError(long delegate) {
        if (this.mNativeContentsClientBridge == 0L) {
            return;
        }
        this.nativeNotificationError(this.mNativeContentsClientBridge, delegate);
    }

    public void notificationClicked(int id2, long delegate) {
        if (this.mNativeContentsClientBridge == 0L) {
            return;
        }
        this.nativeNotificationClicked(this.mNativeContentsClientBridge, id2, delegate);
    }

    public void notificationClosed(int id2, boolean byUser, long delegate) {
        if (this.mNativeContentsClientBridge == 0L) {
            return;
        }
        this.nativeNotificationClosed(this.mNativeContentsClientBridge, id2, byUser, delegate);
    }

    void setDownloadListener(DownloadListener listener) {
        this.mDownloadListener = listener;
    }

    @Override
    public void requestHttpGetDownload(DownloadInfo downloadInfo) {
        if (this.mDownloadListener != null) {
            this.mDownloadListener.onDownloadStart(downloadInfo.getUrl(), downloadInfo.getUserAgent(), downloadInfo.getContentDisposition(), downloadInfo.getMimeType(), downloadInfo.getContentLength());
        }
    }

    @Override
    public void onDownloadStarted(String filename, String mimeType) {
    }

    @Override
    public void onDangerousDownload(String filename, int downloadId) {
    }

    @CalledByNative
    public void onWebLayoutPageScaleFactorChanged(float pageScaleFactor) {
        if (this.mPageScaleFactor == pageScaleFactor) {
            return;
        }
        float oldPageScaleFactor = this.mPageScaleFactor;
        double dipScale = this.getDIPScale();
        this.mPageScaleFactor = pageScaleFactor;
        this.onScaleChanged((float)((double)oldPageScaleFactor * dipScale), (float)((double)this.mPageScaleFactor * dipScale));
    }

    private native void nativeProceedSslError(long var1, boolean var3, int var4);

    private native void nativeConfirmJsResult(long var1, int var3, String var4);

    private native void nativeCancelJsResult(long var1, int var3);

    private native void nativeExitFullscreen(long var1, long var3);

    private native void nativeNotificationDisplayed(long var1, long var3);

    private native void nativeNotificationError(long var1, long var3);

    private native void nativeNotificationClicked(long var1, int var3, long var4);

    private native void nativeNotificationClosed(long var1, int var3, boolean var4, long var5);

    private native void nativeOnFilesSelected(long var1, int var3, int var4, int var5, String var6, String var7);

    private native void nativeOnFilesNotSelected(long var1, int var3, int var4, int var5);

    private class InterceptNavigationDelegateImpl
    implements InterceptNavigationDelegate {
        private XWalkContentsClient mContentsClient;

        public InterceptNavigationDelegateImpl(XWalkContentsClient client) {
            this.mContentsClient = client;
        }

        public boolean shouldIgnoreNavigation(NavigationParams navigationParams) {
            boolean ignoreNavigation;
            String url = navigationParams.url;
            boolean bl = ignoreNavigation = XWalkContentsClientBridge.this.shouldOverrideUrlLoading(url) || XWalkContentsClientBridge.this.mNavigationHandler != null && XWalkContentsClientBridge.this.mNavigationHandler.handleNavigation(navigationParams);
            if (!ignoreNavigation) {
                this.mContentsClient.getCallbackHelper().postOnPageStarted(url);
            }
            return ignoreNavigation;
        }
    }
}

