/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal;

import android.graphics.Bitmap;
import android.graphics.Picture;
import android.net.http.SslError;
import android.os.Message;
import android.view.KeyEvent;
import android.view.View;
import android.webkit.ConsoleMessage;
import android.webkit.ValueCallback;
import android.webkit.WebResourceResponse;
import org.chromium.content.browser.ContentViewClient;
import org.chromium.content.browser.ContentViewCore;
import org.chromium.content.browser.WebContentsObserverAndroid;
import org.xwalk.core.internal.ErrorCodeConversionHelper;
import org.xwalk.core.internal.XWalkContentsClientCallbackHelper;
import org.xwalk.core.internal.XWalkGeolocationPermissions;
import org.xwalk.core.internal.XWalkHttpAuthHandler;
import org.xwalk.core.internal.XWalkWebChromeClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class XWalkContentsClient
extends ContentViewClient {
    private static final String TAG = "XWalkContentsClient";
    private final XWalkContentsClientCallbackHelper mCallbackHelper = new XWalkContentsClientCallbackHelper(this);
    private XWalkWebContentsObserver mWebContentsObserver;
    private double mDIPScale;

    XWalkContentsClient() {
    }

    @Override
    public final void onUpdateTitle(String title) {
        this.onTitleChanged(title);
    }

    @Override
    public boolean shouldOverrideKeyEvent(KeyEvent event) {
        return super.shouldOverrideKeyEvent(event);
    }

    void installWebContentsObserver(ContentViewCore contentViewCore) {
        if (this.mWebContentsObserver != null) {
            this.mWebContentsObserver.detachFromWebContents();
        }
        this.mWebContentsObserver = new XWalkWebContentsObserver(contentViewCore);
    }

    void setDIPScale(double dipScale) {
        this.mDIPScale = dipScale;
    }

    public double getDIPScale() {
        return this.mDIPScale;
    }

    final XWalkContentsClientCallbackHelper getCallbackHelper() {
        return this.mCallbackHelper;
    }

    public abstract void getVisitedHistory(ValueCallback<String[]> var1);

    public abstract void doUpdateVisitedHistory(String var1, boolean var2);

    public abstract void onProgressChanged(int var1);

    public abstract WebResourceResponse shouldInterceptRequest(String var1);

    public abstract void onResourceLoadStarted(String var1);

    public abstract void onResourceLoadFinished(String var1);

    public abstract void onLoadResource(String var1);

    public abstract boolean shouldOverrideUrlLoading(String var1);

    public abstract void onUnhandledKeyEvent(KeyEvent var1);

    public abstract boolean onConsoleMessage(ConsoleMessage var1);

    public abstract void onReceivedHttpAuthRequest(XWalkHttpAuthHandler var1, String var2, String var3);

    public abstract void onReceivedSslError(ValueCallback<Boolean> var1, SslError var2);

    public abstract void onReceivedLoginRequest(String var1, String var2, String var3);

    public abstract void onFormResubmission(Message var1, Message var2);

    public abstract void onDownloadStart(String var1, String var2, String var3, String var4, long var5);

    public abstract void onGeolocationPermissionsShowPrompt(String var1, XWalkGeolocationPermissions.Callback var2);

    public abstract void onGeolocationPermissionsHidePrompt();

    public final void onScaleChanged(float oldScale, float newScale) {
        this.onScaleChangedScaled((float)((double)oldScale * this.mDIPScale), (float)((double)newScale * this.mDIPScale));
    }

    public abstract void onScaleChangedScaled(float var1, float var2);

    protected abstract boolean onCreateWindow(boolean var1, boolean var2);

    protected abstract void onCloseWindow();

    public abstract void onReceivedIcon(Bitmap var1);

    protected abstract void onRequestFocus();

    public abstract void onPageStarted(String var1);

    public abstract void onPageFinished(String var1);

    protected abstract void onStopLoading();

    public abstract void onReceivedError(int var1, String var2, String var3);

    public abstract void onRendererUnresponsive();

    public abstract void onRendererResponsive();

    public abstract void onTitleChanged(String var1);

    public abstract void onToggleFullscreen(boolean var1);

    public abstract boolean hasEnteredFullscreen();

    public abstract boolean shouldOverrideRunFileChooser(int var1, int var2, int var3, String var4, boolean var5);

    public void onShowCustomView(View view, int requestedOrientation, XWalkWebChromeClient.CustomViewCallback callback) {
    }

    public void onShowCustomView(View view, XWalkWebChromeClient.CustomViewCallback callback) {
        this.onShowCustomView(view, -1, callback);
    }

    public abstract void onHideCustomView();

    public abstract void didFinishLoad(String var1);

    public abstract void onFindResultReceived(int var1, int var2, boolean var3);

    public abstract void onNewPicture(Picture var1);

    public abstract boolean shouldOpenWithDefaultBrowser(String var1);

    public class XWalkWebContentsObserver
    extends WebContentsObserverAndroid {
        public XWalkWebContentsObserver(ContentViewCore contentViewCore) {
            super(contentViewCore);
        }

        public void didStopLoading(String url) {
            XWalkContentsClient.this.onPageFinished(url);
        }

        public void didFailLoad(boolean isProvisionalLoad, boolean isMainFrame, int errorCode, String description, String failingUrl) {
            if (errorCode == -3 || !isMainFrame) {
                return;
            }
            XWalkContentsClient.this.onReceivedError(ErrorCodeConversionHelper.convertErrorCode(errorCode), description, failingUrl);
        }

        public void didNavigateAnyFrame(String url, String baseUrl, boolean isReload) {
            XWalkContentsClient.this.doUpdateVisitedHistory(url, isReload);
        }

        public void didFinishLoad(long frameId, String validatedUrl, boolean isMainFrame) {
        }
    }
}

