/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.ValueCallback;
import android.webkit.WebResourceResponse;
import android.widget.FrameLayout;
import java.io.IOException;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.base.ThreadUtils;
import org.chromium.components.navigation_interception.InterceptNavigationDelegate;
import org.chromium.content.browser.ContentView;
import org.chromium.content.browser.ContentViewCore;
import org.chromium.content.browser.ContentViewRenderView;
import org.chromium.content.browser.ContentViewStatics;
import org.chromium.content.browser.LoadUrlParams;
import org.chromium.content.browser.NavigationHistory;
import org.chromium.content.common.CleanupReference;
import org.chromium.media.MediaPlayerBridge;
import org.chromium.ui.base.ActivityWindowAndroid;
import org.xwalk.core.JavascriptInterface;
import org.xwalk.core.internal.AndroidProtocolHandler;
import org.xwalk.core.internal.DownloadListener;
import org.xwalk.core.internal.InMemorySharedPreferences;
import org.xwalk.core.internal.InterceptedRequestData;
import org.xwalk.core.internal.XWalkClient;
import org.xwalk.core.internal.XWalkContentsClient;
import org.xwalk.core.internal.XWalkContentsClientBridge;
import org.xwalk.core.internal.XWalkContentsIoThreadClient;
import org.xwalk.core.internal.XWalkDevToolsServer;
import org.xwalk.core.internal.XWalkGeolocationPermissions;
import org.xwalk.core.internal.XWalkLaunchScreenManager;
import org.xwalk.core.internal.XWalkMediaPlayerResourceLoadingFilter;
import org.xwalk.core.internal.XWalkNavigationHandler;
import org.xwalk.core.internal.XWalkNavigationHistoryInternal;
import org.xwalk.core.internal.XWalkNotificationService;
import org.xwalk.core.internal.XWalkPreferencesInternal;
import org.xwalk.core.internal.XWalkResourceClientInternal;
import org.xwalk.core.internal.XWalkSettings;
import org.xwalk.core.internal.XWalkUIClientInternal;
import org.xwalk.core.internal.XWalkViewInternal;
import org.xwalk.core.internal.XWalkWebChromeClient;
import org.xwalk.core.internal.XWalkWebContentsDelegate;
import org.xwalk.core.internal.XWalkWebContentsDelegateAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JNINamespace(value="xwalk")
class XWalkContent
extends FrameLayout
implements XWalkPreferencesInternal.KeyValueChangeListener {
    private static String TAG = "XWalkContent";
    private ContentViewCore mContentViewCore;
    private ContentView mContentView;
    private ContentViewRenderView mContentViewRenderView;
    private ActivityWindowAndroid mWindow;
    private XWalkDevToolsServer mDevToolsServer;
    private XWalkViewInternal mXWalkView;
    private XWalkContentsClientBridge mContentsClientBridge;
    private XWalkContentsIoThreadClient mIoThreadClient;
    private XWalkWebContentsDelegateAdapter mXWalkContentsDelegateAdapter;
    private XWalkSettings mSettings;
    private XWalkGeolocationPermissions mGeolocationPermissions;
    private XWalkLaunchScreenManager mLaunchScreenManager;
    long mXWalkContent;
    long mWebContents;
    private CleanupReference mCleanupReference;
    private static boolean timerPaused = false;
    public static final String SAVE_RESTORE_STATE_KEY = "XWALKVIEW_STATE";

    public XWalkContent(Context context, AttributeSet attrs, XWalkViewInternal xwView) {
        super(context, attrs);
        this.mXWalkView = xwView;
        this.mContentsClientBridge = new XWalkContentsClientBridge(this.mXWalkView);
        this.mXWalkContentsDelegateAdapter = new XWalkWebContentsDelegateAdapter(this.mContentsClientBridge);
        this.mIoThreadClient = new XWalkIoThreadClientImpl();
        this.mWindow = new ActivityWindowAndroid(xwView.getActivity());
        boolean animated = XWalkPreferencesInternal.getValue("animatable-xwalk-view");
        ContentViewRenderView.CompositingSurfaceType surfaceType = animated ? ContentViewRenderView.CompositingSurfaceType.TEXTURE_VIEW : ContentViewRenderView.CompositingSurfaceType.SURFACE_VIEW;
        this.mContentViewRenderView = new ContentViewRenderView(context, surfaceType){

            protected void onReadyToRender() {
            }
        };
        this.mContentViewRenderView.onNativeLibraryLoaded(this.mWindow);
        this.mLaunchScreenManager = new XWalkLaunchScreenManager(context, this.mXWalkView);
        this.mContentViewRenderView.registerFirstRenderedFrameListener(this.mLaunchScreenManager);
        this.addView((View)this.mContentViewRenderView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.mXWalkContent = this.nativeInit(this.mXWalkContentsDelegateAdapter, this.mContentsClientBridge);
        this.mCleanupReference = new CleanupReference(this, new DestroyRunnable(this.mXWalkContent));
        this.mWebContents = this.nativeGetWebContents(this.mXWalkContent, this.mIoThreadClient, this.mContentsClientBridge.getInterceptNavigationDelegate());
        this.mContentViewCore = new ContentViewCore(this.getContext());
        this.mContentView = ContentView.newInstance(this.getContext(), this.mContentViewCore);
        this.mContentViewCore.initialize((ViewGroup)this.mContentView, this.mContentView, this.mWebContents, this.mWindow);
        this.addView((View)this.mContentView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.mContentViewCore.setContentViewClient(this.mContentsClientBridge);
        this.mContentViewRenderView.setCurrentContentViewCore(this.mContentViewCore);
        this.mContentsClientBridge.installWebContentsObserver(this.mContentViewCore);
        this.mContentViewCore.setDownloadDelegate(this.mContentsClientBridge);
        this.mSettings = new XWalkSettings(this.getContext(), this.mWebContents, false);
        this.mSettings.setAllowFileAccessFromFileURLs(true);
        InMemorySharedPreferences sharedPreferences = new InMemorySharedPreferences();
        this.mGeolocationPermissions = new XWalkGeolocationPermissions(sharedPreferences);
        MediaPlayerBridge.setResourceLoadingFilter(new XWalkMediaPlayerResourceLoadingFilter());
        XWalkPreferencesInternal.load(this);
    }

    void doLoadUrl(String url, String content) {
        if (url != null && !url.isEmpty() && TextUtils.equals((CharSequence)url, (CharSequence)this.mContentViewCore.getUrl())) {
            this.mContentViewCore.reload(true);
        } else {
            LoadUrlParams params = null;
            params = content == null || content.isEmpty() ? new LoadUrlParams(url) : LoadUrlParams.createLoadDataParamsWithBaseUrl(content, "text/html", false, url, null);
            params.setOverrideUserAgent(2);
            this.mContentViewCore.loadUrl(params);
        }
        this.mContentView.requestFocus();
    }

    public void loadUrl(String url, String data) {
        if ((url == null || url.isEmpty()) && (data == null || data.isEmpty())) {
            return;
        }
        this.doLoadUrl(url, data);
    }

    public void reload(int mode) {
        switch (mode) {
            case 1: {
                this.mContentViewCore.reloadIgnoringCache(true);
                break;
            }
            default: {
                this.mContentViewCore.reload(true);
            }
        }
    }

    public String getUrl() {
        String url = this.mContentViewCore.getUrl();
        if (url == null || url.trim().isEmpty()) {
            return null;
        }
        return url;
    }

    public String getTitle() {
        String title = this.mContentViewCore.getTitle().trim();
        if (title == null) {
            title = "";
        }
        return title;
    }

    public void addJavascriptInterface(Object object, String name) {
        this.mContentViewCore.addPossiblyUnsafeJavascriptInterface(object, name, JavascriptInterface.class);
    }

    public void evaluateJavascript(String script, ValueCallback<String> callback) {
        final ValueCallback<String> fCallback = callback;
        ContentViewCore.JavaScriptCallback coreCallback = null;
        if (fCallback != null) {
            coreCallback = new ContentViewCore.JavaScriptCallback(){

                public void handleJavaScriptResult(String jsonResult) {
                    fCallback.onReceiveValue((Object)jsonResult);
                }
            };
        }
        this.mContentViewCore.evaluateJavaScript(script, coreCallback);
    }

    public void setUIClient(XWalkUIClientInternal client) {
        this.mContentsClientBridge.setUIClient(client);
    }

    public void setResourceClient(XWalkResourceClientInternal client) {
        this.mContentsClientBridge.setResourceClient(client);
    }

    public void setXWalkWebChromeClient(XWalkWebChromeClient client) {
        this.mContentsClientBridge.setXWalkWebChromeClient(client);
    }

    public XWalkWebChromeClient getXWalkWebChromeClient() {
        return this.mContentsClientBridge.getXWalkWebChromeClient();
    }

    public void setXWalkClient(XWalkClient client) {
        this.mContentsClientBridge.setXWalkClient(client);
    }

    public void setDownloadListener(DownloadListener listener) {
        this.mContentsClientBridge.setDownloadListener(listener);
    }

    public void setNavigationHandler(XWalkNavigationHandler handler) {
        this.mContentsClientBridge.setNavigationHandler(handler);
    }

    public void setNotificationService(XWalkNotificationService service) {
        this.mContentsClientBridge.setNotificationService(service);
    }

    public void onPause() {
        this.mContentViewCore.onHide();
    }

    public void onResume() {
        this.mContentViewCore.onShow();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        this.mWindow.onActivityResult(requestCode, resultCode, data);
    }

    public boolean onNewIntent(Intent intent) {
        return this.mContentsClientBridge.onNewIntent(intent);
    }

    public void clearCache(boolean includeDiskFiles) {
        if (this.mXWalkContent == 0L) {
            return;
        }
        this.nativeClearCache(this.mXWalkContent, includeDiskFiles);
    }

    public void clearHistory() {
        this.mContentViewCore.clearHistory();
    }

    public boolean canGoBack() {
        return this.mContentViewCore.canGoBack();
    }

    public void goBack() {
        this.mContentViewCore.goBack();
    }

    public boolean canGoForward() {
        return this.mContentViewCore.canGoForward();
    }

    public void goForward() {
        this.mContentViewCore.goForward();
    }

    void navigateTo(int offset) {
        this.mContentViewCore.goToOffset(offset);
    }

    public void stopLoading() {
        this.mContentViewCore.stopLoading();
        this.mContentsClientBridge.onStopLoading();
    }

    public void pauseTimers() {
        if (timerPaused) {
            return;
        }
        ContentViewStatics.setWebKitSharedTimersSuspended(true);
        timerPaused = true;
    }

    public void resumeTimers() {
        if (!timerPaused) {
            return;
        }
        ContentViewStatics.setWebKitSharedTimersSuspended(false);
        timerPaused = false;
    }

    public String getOriginalUrl() {
        NavigationHistory history = this.mContentViewCore.getNavigationHistory();
        int currentIndex = history.getCurrentEntryIndex();
        if (currentIndex >= 0 && currentIndex < history.getEntryCount()) {
            return history.getEntryAtIndex(currentIndex).getOriginalUrl();
        }
        return null;
    }

    public String getXWalkVersion() {
        if (this.mXWalkContent == 0L) {
            return "";
        }
        return this.nativeGetVersion(this.mXWalkContent);
    }

    public void setNetworkAvailable(boolean networkUp) {
        if (this.mXWalkContent == 0L) {
            return;
        }
        this.nativeSetJsOnlineProperty(this.mXWalkContent, networkUp);
    }

    public ContentViewCore getContentViewCoreForTest() {
        return this.mContentViewCore;
    }

    public void installWebContentsObserverForTest(XWalkContentsClient contentClient) {
        contentClient.installWebContentsObserver(this.mContentViewCore);
    }

    public String devToolsAgentId() {
        if (this.mXWalkContent == 0L) {
            return "";
        }
        return this.nativeDevToolsAgentId(this.mXWalkContent);
    }

    public XWalkSettings getSettings() {
        return this.mSettings;
    }

    public void loadAppFromManifest(String url, String data) {
        if (this.mXWalkContent == 0L || (url == null || url.isEmpty()) && (data == null || data.isEmpty())) {
            return;
        }
        String content = data;
        if (data == null || data.isEmpty()) {
            try {
                content = AndroidProtocolHandler.getUrlContent((Context)this.mXWalkView.getActivity(), url);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read the manifest: " + url);
            }
        }
        String baseUrl = url;
        int position = url.lastIndexOf("/");
        if (position != -1) {
            baseUrl = url.substring(0, position + 1);
        } else {
            Log.w((String)TAG, (String)"The url of manifest.json is probably not set correctly.");
        }
        if (!this.nativeSetManifest(this.mXWalkContent, baseUrl, content)) {
            throw new RuntimeException("Failed to parse the manifest file: " + url);
        }
    }

    public XWalkNavigationHistoryInternal getNavigationHistory() {
        return new XWalkNavigationHistoryInternal(this.mXWalkView, this.mContentViewCore.getNavigationHistory());
    }

    public XWalkNavigationHistoryInternal saveState(Bundle outState) {
        if (outState == null) {
            return null;
        }
        byte[] state = this.nativeGetState(this.mXWalkContent);
        if (state == null) {
            return null;
        }
        outState.putByteArray(SAVE_RESTORE_STATE_KEY, state);
        return this.getNavigationHistory();
    }

    public XWalkNavigationHistoryInternal restoreState(Bundle inState) {
        if (inState == null) {
            return null;
        }
        byte[] state = inState.getByteArray(SAVE_RESTORE_STATE_KEY);
        if (state == null) {
            return null;
        }
        boolean result = this.nativeSetState(this.mXWalkContent, state);
        if (result) {
            this.mContentsClientBridge.onUpdateTitle(this.mContentViewCore.getTitle());
        }
        return result ? this.getNavigationHistory() : null;
    }

    boolean hasEnteredFullscreen() {
        return this.mContentsClientBridge.hasEnteredFullscreen();
    }

    void exitFullscreen() {
        if (this.hasEnteredFullscreen()) {
            this.mContentsClientBridge.exitFullscreen(this.mWebContents);
        }
    }

    @CalledByNative
    public void onGetUrlFromManifest(String url) {
        if (url != null && !url.isEmpty()) {
            this.loadUrl(url, null);
        }
    }

    @CalledByNative
    public void onGetUrlAndLaunchScreenFromManifest(String url, String readyWhen, String imageBorder) {
        if (url == null || url.isEmpty()) {
            return;
        }
        this.mLaunchScreenManager.displayLaunchScreen(readyWhen, imageBorder);
        this.mContentsClientBridge.registerPageLoadListener(this.mLaunchScreenManager);
        this.loadUrl(url, null);
    }

    @CalledByNative
    public void onGetFullscreenFlagFromManifest(boolean enterFullscreen) {
        if (enterFullscreen) {
            this.mContentsClientBridge.onToggleFullscreen(true);
        }
    }

    public void destroy() {
        if (this.mXWalkContent == 0L) {
            return;
        }
        XWalkPreferencesInternal.unload(this);
        this.setNotificationService(null);
        this.removeView((View)this.mContentView);
        this.removeView((View)this.mContentViewRenderView);
        this.mContentViewRenderView.setCurrentContentViewCore(null);
        this.mContentViewRenderView.destroy();
        this.mContentViewCore.destroy();
        this.mCleanupReference.cleanupNow();
        this.mCleanupReference = null;
        this.mXWalkContent = 0L;
    }

    public int getRoutingID() {
        return this.nativeGetRoutingID(this.mXWalkContent);
    }

    @CalledByNative
    private void onGeolocationPermissionsShowPrompt(String origin) {
        if (!this.mSettings.getGeolocationEnabled()) {
            this.nativeInvokeGeolocationCallback(this.mXWalkContent, false, origin);
            return;
        }
        if (this.mGeolocationPermissions.hasOrigin(origin)) {
            this.nativeInvokeGeolocationCallback(this.mXWalkContent, this.mGeolocationPermissions.isOriginAllowed(origin), origin);
            return;
        }
        this.mContentsClientBridge.onGeolocationPermissionsShowPrompt(origin, new XWalkGeolocationCallback());
    }

    @CalledByNative
    public void onGeolocationPermissionsHidePrompt() {
        this.mContentsClientBridge.onGeolocationPermissionsHidePrompt();
    }

    public String enableRemoteDebugging(int allowedUid) {
        String socketName = this.getContext().getApplicationContext().getPackageName() + "_devtools_remote";
        if (this.mDevToolsServer == null) {
            this.mDevToolsServer = new XWalkDevToolsServer(socketName);
            this.mDevToolsServer.allowConnectionFromUid(allowedUid);
            this.mDevToolsServer.setRemoteDebuggingEnabled(true);
        }
        return "ws://" + socketName + "/devtools/page/" + this.devToolsAgentId();
    }

    String enableRemoteDebugging() {
        return this.enableRemoteDebugging(this.getContext().getApplicationInfo().uid);
    }

    void disableRemoteDebugging() {
        if (this.mDevToolsServer == null) {
            return;
        }
        if (this.mDevToolsServer.isRemoteDebuggingEnabled()) {
            this.mDevToolsServer.setRemoteDebuggingEnabled(false);
        }
        this.mDevToolsServer.destroy();
        this.mDevToolsServer = null;
    }

    @Override
    public void onKeyValueChanged(String key, boolean value) {
        if (key == null) {
            return;
        }
        if (key.equals("remote-debugging")) {
            if (value) {
                this.enableRemoteDebugging();
            } else {
                this.disableRemoteDebugging();
            }
        } else if (key.equals("enable-javascript")) {
            if (this.mSettings != null) {
                this.mSettings.setJavaScriptEnabled(value);
            }
        } else if (key.equals("javascript-can-open-window")) {
            if (this.mSettings != null) {
                this.mSettings.setJavaScriptCanOpenWindowsAutomatically(value);
            }
        } else if (key.equals("allow-universal-access-from-file")) {
            if (this.mSettings != null) {
                this.mSettings.setAllowUniversalAccessFromFileURLs(value);
            }
        } else if (key.equals("support-multiple-windows") && this.mSettings != null) {
            this.mSettings.setSupportMultipleWindows(value);
        }
    }

    public void setOverlayVideoMode(boolean enabled) {
        if (this.mContentViewRenderView != null) {
            this.mContentViewRenderView.setOverlayVideoMode(enabled);
        }
    }

    private native long nativeInit(XWalkWebContentsDelegate var1, XWalkContentsClientBridge var2);

    private static native void nativeDestroy(long var0);

    private native long nativeGetWebContents(long var1, XWalkContentsIoThreadClient var3, InterceptNavigationDelegate var4);

    private native void nativeClearCache(long var1, boolean var3);

    private native String nativeDevToolsAgentId(long var1);

    private native String nativeGetVersion(long var1);

    private native void nativeSetJsOnlineProperty(long var1, boolean var3);

    private native boolean nativeSetManifest(long var1, String var3, String var4);

    private native int nativeGetRoutingID(long var1);

    private native void nativeInvokeGeolocationCallback(long var1, boolean var3, String var4);

    private native byte[] nativeGetState(long var1);

    private native boolean nativeSetState(long var1, byte[] var3);

    private class XWalkGeolocationCallback
    implements XWalkGeolocationPermissions.Callback {
        private XWalkGeolocationCallback() {
        }

        public void invoke(final String origin, final boolean allow, final boolean retain) {
            ThreadUtils.runOnUiThread(new Runnable(){

                public void run() {
                    if (retain) {
                        if (allow) {
                            XWalkContent.this.mGeolocationPermissions.allow(origin);
                        } else {
                            XWalkContent.this.mGeolocationPermissions.deny(origin);
                        }
                    }
                    XWalkContent.this.nativeInvokeGeolocationCallback(XWalkContent.this.mXWalkContent, allow, origin);
                }
            });
        }
    }

    private class XWalkIoThreadClientImpl
    implements XWalkContentsIoThreadClient {
        private XWalkIoThreadClientImpl() {
        }

        public int getCacheMode() {
            return XWalkContent.this.mSettings.getCacheMode();
        }

        public InterceptedRequestData shouldInterceptRequest(String url, boolean isMainFrame) {
            XWalkContent.this.mContentsClientBridge.getCallbackHelper().postOnResourceLoadStarted(url);
            WebResourceResponse webResourceResponse = XWalkContent.this.mContentsClientBridge.shouldInterceptRequest(url);
            InterceptedRequestData interceptedRequestData = null;
            if (webResourceResponse == null) {
                XWalkContent.this.mContentsClientBridge.getCallbackHelper().postOnLoadResource(url);
            } else {
                if (isMainFrame && webResourceResponse.getData() == null) {
                    XWalkContent.this.mContentsClientBridge.getCallbackHelper().postOnReceivedError(-1, null, url);
                }
                interceptedRequestData = new InterceptedRequestData(webResourceResponse.getMimeType(), webResourceResponse.getEncoding(), webResourceResponse.getData());
            }
            return interceptedRequestData;
        }

        public boolean shouldBlockContentUrls() {
            return !XWalkContent.this.mSettings.getAllowContentAccess();
        }

        public boolean shouldBlockFileUrls() {
            return !XWalkContent.this.mSettings.getAllowFileAccess();
        }

        public boolean shouldBlockNetworkLoads() {
            return XWalkContent.this.mSettings.getBlockNetworkLoads();
        }

        public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimeType, long contentLength) {
            XWalkContent.this.mContentsClientBridge.getCallbackHelper().postOnDownloadStart(url, userAgent, contentDisposition, mimeType, contentLength);
        }

        public void newLoginRequest(String realm, String account, String args) {
            XWalkContent.this.mContentsClientBridge.getCallbackHelper().postOnReceivedLoginRequest(realm, account, args);
        }
    }

    private static final class DestroyRunnable
    implements Runnable {
        private final long mXWalkContent;

        private DestroyRunnable(long nativeXWalkContent) {
            this.mXWalkContent = nativeXWalkContent;
        }

        public void run() {
            XWalkContent.nativeDestroy(this.mXWalkContent);
        }
    }
}

