/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.net.http.SslError;
import android.os.Message;
import android.view.View;
import android.webkit.ValueCallback;
import android.widget.EditText;
import android.widget.LinearLayout;
import org.xwalk.core.internal.R;
import org.xwalk.core.internal.XWalkHttpAuthHandler;
import org.xwalk.core.internal.XWalkViewInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XWalkClient {
    private Context mContext;
    private AlertDialog mDialog;
    private XWalkViewInternal mXWalkView;

    public XWalkClient(XWalkViewInternal view) {
        this.mContext = view.getContext();
        this.mXWalkView = view;
    }

    public void onRendererUnresponsive(XWalkViewInternal view) {
    }

    public void onRendererResponsive(XWalkViewInternal view) {
    }

    @Deprecated
    public void onTooManyRedirects(XWalkViewInternal view, Message cancelMsg, Message continueMsg) {
        cancelMsg.sendToTarget();
    }

    public void onFormResubmission(XWalkViewInternal view, Message dontResend, Message resend) {
        dontResend.sendToTarget();
    }

    public void doUpdateVisitedHistory(XWalkViewInternal view, String url, boolean isReload) {
    }

    public void onReceivedSslError(XWalkViewInternal view, ValueCallback<Boolean> callback, SslError error) {
        final ValueCallback<Boolean> valueCallback = callback;
        AlertDialog.Builder dialogBuilder = new AlertDialog.Builder(this.mContext);
        dialogBuilder.setTitle(R.string.ssl_alert_title).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                valueCallback.onReceiveValue((Object)true);
                dialog.dismiss();
            }
        }).setNegativeButton(0x1040000, null).setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                valueCallback.onReceiveValue((Object)false);
            }
        });
        this.mDialog = dialogBuilder.create();
        this.mDialog.show();
    }

    public void onProceededAfterSslError(XWalkViewInternal view, SslError error) {
    }

    public void onReceivedHttpAuthRequest(XWalkViewInternal view, XWalkHttpAuthHandler handler, String host, String realm) {
        if (view == null) {
            return;
        }
        final XWalkHttpAuthHandler haHandler = handler;
        LinearLayout layout2 = new LinearLayout(this.mContext);
        final EditText userNameEditText = new EditText(this.mContext);
        final EditText passwordEditText = new EditText(this.mContext);
        layout2.setOrientation(1);
        layout2.setPaddingRelative(10, 0, 10, 20);
        userNameEditText.setHint(R.string.http_auth_user_name);
        passwordEditText.setHint(R.string.http_auth_password);
        layout2.addView((View)userNameEditText);
        layout2.addView((View)passwordEditText);
        Activity curActivity = this.mXWalkView.getActivity();
        AlertDialog.Builder httpAuthDialog = new AlertDialog.Builder((Context)curActivity);
        httpAuthDialog.setTitle(R.string.http_auth_title).setView((View)layout2).setCancelable(false).setPositiveButton(R.string.http_auth_log_in, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                String userName = userNameEditText.getText().toString();
                String password = passwordEditText.getText().toString();
                haHandler.proceed(userName, password);
                dialog.dismiss();
            }
        }).setNegativeButton(0x1040000, null).setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                haHandler.cancel();
            }
        }).create().show();
    }

    public void onReceivedLoginRequest(XWalkViewInternal view, String realm, String account, String args) {
    }

    public void onLoadResource(XWalkViewInternal view, String url) {
    }
}

