/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal;

import android.content.SharedPreferences;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InMemorySharedPreferences
implements SharedPreferences {
    private final Map<String, Object> mData;

    public InMemorySharedPreferences() {
        this.mData = new HashMap<String, Object>();
    }

    public InMemorySharedPreferences(Map<String, Object> data) {
        this.mData = data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ?> getAll() {
        Map<String, Object> map = this.mData;
        synchronized (map) {
            return Collections.unmodifiableMap(this.mData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String key, String defValue) {
        Map<String, Object> map = this.mData;
        synchronized (map) {
            if (this.mData.containsKey(key)) {
                return (String)this.mData.get(key);
            }
        }
        return defValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getStringSet(String key, Set<String> defValues) {
        Map<String, Object> map = this.mData;
        synchronized (map) {
            if (this.mData.containsKey(key)) {
                return Collections.unmodifiableSet((Set)this.mData.get(key));
            }
        }
        return defValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(String key, int defValue) {
        Map<String, Object> map = this.mData;
        synchronized (map) {
            if (this.mData.containsKey(key)) {
                return (Integer)this.mData.get(key);
            }
        }
        return defValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(String key, long defValue) {
        Map<String, Object> map = this.mData;
        synchronized (map) {
            if (this.mData.containsKey(key)) {
                return (Long)this.mData.get(key);
            }
        }
        return defValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloat(String key, float defValue) {
        Map<String, Object> map = this.mData;
        synchronized (map) {
            if (this.mData.containsKey(key)) {
                return ((Float)this.mData.get(key)).floatValue();
            }
        }
        return defValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(String key, boolean defValue) {
        Map<String, Object> map = this.mData;
        synchronized (map) {
            if (this.mData.containsKey(key)) {
                return (Boolean)this.mData.get(key);
            }
        }
        return defValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String key) {
        Map<String, Object> map = this.mData;
        synchronized (map) {
            return this.mData.containsKey(key);
        }
    }

    public SharedPreferences.Editor edit() {
        return new InMemoryEditor();
    }

    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        throw new UnsupportedOperationException();
    }

    public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InMemoryEditor
    implements SharedPreferences.Editor {
        private boolean mClearCalled;
        private volatile boolean mApplyCalled;
        private final Map<String, Object> mChanges = new HashMap<String, Object>();

        private InMemoryEditor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedPreferences.Editor putString(String key, String value) {
            Map<String, Object> map = this.mChanges;
            synchronized (map) {
                if (this.mApplyCalled) {
                    throw new IllegalStateException();
                }
                this.mChanges.put(key, value);
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedPreferences.Editor putStringSet(String key, Set<String> values) {
            Map<String, Object> map = this.mChanges;
            synchronized (map) {
                if (this.mApplyCalled) {
                    throw new IllegalStateException();
                }
                this.mChanges.put(key, values);
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedPreferences.Editor putInt(String key, int value) {
            Map<String, Object> map = this.mChanges;
            synchronized (map) {
                if (this.mApplyCalled) {
                    throw new IllegalStateException();
                }
                this.mChanges.put(key, value);
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedPreferences.Editor putLong(String key, long value) {
            Map<String, Object> map = this.mChanges;
            synchronized (map) {
                if (this.mApplyCalled) {
                    throw new IllegalStateException();
                }
                this.mChanges.put(key, value);
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedPreferences.Editor putFloat(String key, float value) {
            Map<String, Object> map = this.mChanges;
            synchronized (map) {
                if (this.mApplyCalled) {
                    throw new IllegalStateException();
                }
                this.mChanges.put(key, Float.valueOf(value));
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedPreferences.Editor putBoolean(String key, boolean value) {
            Map<String, Object> map = this.mChanges;
            synchronized (map) {
                if (this.mApplyCalled) {
                    throw new IllegalStateException();
                }
                this.mChanges.put(key, value);
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedPreferences.Editor remove(String key) {
            Map<String, Object> map = this.mChanges;
            synchronized (map) {
                if (this.mApplyCalled) {
                    throw new IllegalStateException();
                }
                this.mChanges.put(key, this);
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedPreferences.Editor clear() {
            Map<String, Object> map = this.mChanges;
            synchronized (map) {
                if (this.mApplyCalled) {
                    throw new IllegalStateException();
                }
                this.mClearCalled = true;
                return this;
            }
        }

        public boolean commit() {
            this.apply();
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void apply() {
            Map map = InMemorySharedPreferences.this.mData;
            synchronized (map) {
                Map<String, Object> map2 = this.mChanges;
                synchronized (map2) {
                    if (this.mApplyCalled) {
                        throw new IllegalStateException();
                    }
                    if (this.mClearCalled) {
                        InMemorySharedPreferences.this.mData.clear();
                    }
                    for (Map.Entry<String, Object> entry : this.mChanges.entrySet()) {
                        String key = entry.getKey();
                        Object value = entry.getValue();
                        if (value == this) {
                            InMemorySharedPreferences.this.mData.remove(key);
                            continue;
                        }
                        InMemorySharedPreferences.this.mData.put(key, value);
                    }
                    this.mApplyCalled = true;
                }
            }
        }
    }
}

