/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal;

import android.content.Context;
import android.content.res.AssetManager;
import android.net.Uri;
import android.util.Log;
import android.util.TypedValue;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.util.List;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;

@JNINamespace(value="xwalk")
class AndroidProtocolHandler {
    private static final String TAG = "AndroidProtocolHandler";
    public static final String FILE_SCHEME = "file";
    private static final String CONTENT_SCHEME = "content";
    public static final String APP_SCHEME = "app";
    private static final String APP_SRC = "www";
    private static final String SCHEME_SEPARATOR = "//";

    AndroidProtocolHandler() {
    }

    @CalledByNative
    public static InputStream open(Context context, String url) {
        Uri uri = AndroidProtocolHandler.verifyUrl(url);
        if (uri == null) {
            return null;
        }
        try {
            String path = uri.getPath();
            if (uri.getScheme().equals(FILE_SCHEME)) {
                if (path.startsWith(AndroidProtocolHandler.nativeGetAndroidAssetPath())) {
                    return AndroidProtocolHandler.openAsset(context, uri);
                }
                if (path.startsWith(AndroidProtocolHandler.nativeGetAndroidResourcePath())) {
                    return AndroidProtocolHandler.openResource(context, uri);
                }
            } else {
                if (uri.getScheme().equals(CONTENT_SCHEME)) {
                    return AndroidProtocolHandler.openContent(context, uri);
                }
                if (uri.getScheme().equals(APP_SCHEME)) {
                    if (!uri.getHost().equals(context.getPackageName().toLowerCase())) {
                        return null;
                    }
                    if (path.length() <= 1) {
                        return null;
                    }
                    return AndroidProtocolHandler.openAsset(context, AndroidProtocolHandler.appUriToFileUri(uri));
                }
            }
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)("Error opening inputstream: " + url));
        }
        return null;
    }

    public static String getAssetPath(Uri uri) {
        assert (uri.getScheme().equals(FILE_SCHEME));
        assert (uri.getPath() != null);
        assert (uri.getPath().startsWith(AndroidProtocolHandler.nativeGetAndroidAssetPath()));
        String path = uri.getPath();
        path = new File(path).getAbsolutePath();
        return path.replaceFirst(AndroidProtocolHandler.nativeGetAndroidAssetPath(), "");
    }

    public static Uri appUriToFileUri(Uri uri) {
        assert (uri.getScheme().equals(APP_SCHEME));
        assert (uri.getPath() != null);
        try {
            URI fileUri = new URI(FILE_SCHEME, SCHEME_SEPARATOR + AndroidProtocolHandler.nativeGetAndroidAssetPath() + APP_SRC + uri.getPath(), null);
            return Uri.parse((String)fileUri.normalize().toString());
        }
        catch (URISyntaxException e) {
            Log.e((String)TAG, (String)("Unable to convert app URI to file URI: " + uri), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getUrlContent(Context context, String url) throws IOException {
        InputStream stream = AndroidProtocolHandler.open(context, url);
        if (stream == null) {
            throw new RuntimeException("Failed to open the url: " + url);
        }
        String content = "";
        try {
            int bufferSize = 1024;
            byte[] buffer = new byte[1024];
            int actualSize = 0;
            while ((actualSize = stream.read(buffer, 0, 1024)) > 0) {
                content = content + new String(buffer, 0, actualSize);
            }
        }
        finally {
            stream.close();
        }
        return content;
    }

    private static int getFieldId(Context context, String assetType, String assetName) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        Class<?> d = context.getClassLoader().loadClass(context.getPackageName() + ".R$" + assetType);
        Field field = d.getField(assetName);
        int id2 = field.getInt(null);
        return id2;
    }

    private static int getValueType(Context context, int fieldId) {
        TypedValue value = new TypedValue();
        context.getResources().getValue(fieldId, value, true);
        return value.type;
    }

    private static InputStream openResource(Context context, Uri uri) {
        assert (uri.getScheme().equals(FILE_SCHEME));
        assert (uri.getPath() != null);
        assert (uri.getPath().startsWith(AndroidProtocolHandler.nativeGetAndroidResourcePath()));
        List pathSegments = uri.getPathSegments();
        if (pathSegments.size() != 3) {
            Log.e((String)TAG, (String)("Incorrect resource path: " + uri));
            return null;
        }
        String assetPath = (String)pathSegments.get(0);
        String assetType = (String)pathSegments.get(1);
        String assetName = (String)pathSegments.get(2);
        if (!("/" + assetPath + "/").equals(AndroidProtocolHandler.nativeGetAndroidResourcePath())) {
            Log.e((String)TAG, (String)("Resource path does not start with " + AndroidProtocolHandler.nativeGetAndroidResourcePath() + ": " + uri));
            return null;
        }
        assetName = assetName.split("\\.")[0];
        try {
            int fieldId;
            int valueType;
            if (context.getApplicationContext() != null) {
                context = context.getApplicationContext();
            }
            if ((valueType = AndroidProtocolHandler.getValueType(context, fieldId = AndroidProtocolHandler.getFieldId(context, assetType, assetName))) == 3) {
                return context.getResources().openRawResource(fieldId);
            }
            Log.e((String)TAG, (String)("Asset not of type string: " + uri));
            return null;
        }
        catch (ClassNotFoundException e) {
            Log.e((String)TAG, (String)("Unable to open resource URL: " + uri), (Throwable)e);
            return null;
        }
        catch (NoSuchFieldException e) {
            Log.e((String)TAG, (String)("Unable to open resource URL: " + uri), (Throwable)e);
            return null;
        }
        catch (IllegalAccessException e) {
            Log.e((String)TAG, (String)("Unable to open resource URL: " + uri), (Throwable)e);
            return null;
        }
    }

    private static InputStream openAsset(Context context, Uri uri) {
        assert (uri.getScheme().equals(FILE_SCHEME));
        assert (uri.getPath() != null);
        assert (uri.getPath().startsWith(AndroidProtocolHandler.nativeGetAndroidAssetPath()));
        try {
            AssetManager assets = context.getAssets();
            return assets.open(AndroidProtocolHandler.getAssetPath(uri), 2);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("Unable to open asset URL: " + uri));
            return null;
        }
    }

    private static InputStream openContent(Context context, Uri uri) {
        assert (uri.getScheme().equals(CONTENT_SCHEME));
        try {
            Uri baseUri = AndroidProtocolHandler.stripQueryParameters(uri);
            return context.getContentResolver().openInputStream(baseUri);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Unable to open content URL: " + uri));
            return null;
        }
    }

    @CalledByNative
    public static String getMimeType(Context context, InputStream stream, String url) {
        Uri uri = AndroidProtocolHandler.verifyUrl(url);
        if (uri == null) {
            return null;
        }
        try {
            String mimeType;
            String path = uri.getPath();
            if (uri.getScheme().equals(CONTENT_SCHEME)) {
                return context.getContentResolver().getType(uri);
            }
            if (uri.getScheme().equals(FILE_SCHEME) && path.startsWith(AndroidProtocolHandler.nativeGetAndroidAssetPath()) && (mimeType = URLConnection.guessContentTypeFromName(path)) != null) {
                return mimeType;
            }
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)("Unable to get mime type" + url));
            return null;
        }
        try {
            return URLConnection.guessContentTypeFromStream(stream);
        }
        catch (IOException e) {
            return null;
        }
    }

    @CalledByNative
    public static String getPackageName(Context context) {
        try {
            return context.getPackageName();
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)"Unable to get package name");
            return null;
        }
    }

    private static Uri verifyUrl(String url) {
        if (url == null) {
            return null;
        }
        Uri uri = Uri.parse((String)url);
        if (uri == null) {
            Log.e((String)TAG, (String)("Malformed URL: " + url));
            return null;
        }
        String path = uri.getPath();
        if (path == null || path.length() == 0) {
            Log.e((String)TAG, (String)("URL does not have a path: " + url));
            return null;
        }
        return uri;
    }

    private static Uri stripQueryParameters(Uri uri) {
        assert (uri.getAuthority() != null);
        assert (uri.getPath() != null);
        Uri.Builder builder = new Uri.Builder();
        builder.scheme(uri.getScheme());
        builder.encodedAuthority(uri.getAuthority());
        builder.encodedPath(uri.getPath());
        return builder.build();
    }

    public static void setResourceContextForTesting(Context context) {
        AndroidProtocolHandler.nativeSetResourceContextForTesting(context);
    }

    private static native void nativeSetResourceContextForTesting(Context var0);

    private static native String nativeGetAndroidAssetPath();

    private static native String nativeGetAndroidResourcePath();
}

