/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.gl;

import android.graphics.SurfaceTexture;
import android.os.Build;
import android.util.Log;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.ui.gl.SurfaceTextureListener;

@JNINamespace(value="gfx")
class SurfaceTexturePlatformWrapper {
    private static final String TAG = "SurfaceTexturePlatformWrapper";

    SurfaceTexturePlatformWrapper() {
    }

    @CalledByNative
    private static SurfaceTexture create(int textureId) {
        return new SurfaceTexture(textureId);
    }

    @CalledByNative
    private static SurfaceTexture createSingleBuffered(int textureId) {
        assert (Build.VERSION.SDK_INT >= 19);
        return new SurfaceTexture(textureId, true);
    }

    @CalledByNative
    private static void destroy(SurfaceTexture surfaceTexture) {
        surfaceTexture.setOnFrameAvailableListener(null);
        surfaceTexture.release();
    }

    @CalledByNative
    private static void setFrameAvailableCallback(SurfaceTexture surfaceTexture, long nativeSurfaceTextureListener) {
        surfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)new SurfaceTextureListener(nativeSurfaceTextureListener));
    }

    @CalledByNative
    private static void updateTexImage(SurfaceTexture surfaceTexture) {
        try {
            surfaceTexture.updateTexImage();
        }
        catch (RuntimeException e) {
            Log.e((String)TAG, (String)"Error calling updateTexImage", (Throwable)e);
        }
    }

    @CalledByNative
    private static void releaseTexImage(SurfaceTexture surfaceTexture) {
        assert (Build.VERSION.SDK_INT >= 19);
        surfaceTexture.releaseTexImage();
    }

    @CalledByNative
    private static void setDefaultBufferSize(SurfaceTexture surfaceTexture, int width, int height) {
        surfaceTexture.setDefaultBufferSize(width, height);
    }

    @CalledByNative
    private static void getTransformMatrix(SurfaceTexture surfaceTexture, float[] matrix) {
        surfaceTexture.getTransformMatrix(matrix);
    }

    @CalledByNative
    private static void attachToGLContext(SurfaceTexture surfaceTexture, int texName) {
        assert (Build.VERSION.SDK_INT >= 16);
        surfaceTexture.attachToGLContext(texName);
    }

    @CalledByNative
    private static void detachFromGLContext(SurfaceTexture surfaceTexture) {
        assert (Build.VERSION.SDK_INT >= 16);
        surfaceTexture.detachFromGLContext();
    }
}

