/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.gfx;

import android.content.ComponentCallbacks;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.ViewConfiguration;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.ui.R;

@JNINamespace(value="gfx")
public class ViewConfigurationHelper {
    private static final float MIN_SCALING_SPAN_MM = 27.0f;
    private static final float MIN_SCALING_TOUCH_MAJOR_DIP = 48.0f;
    private final Context mAppContext;
    private ViewConfiguration mViewConfiguration;

    private ViewConfigurationHelper(Context context) {
        this.mAppContext = context.getApplicationContext();
        this.mViewConfiguration = ViewConfiguration.get((Context)this.mAppContext);
    }

    private void registerListener() {
        this.mAppContext.registerComponentCallbacks(new ComponentCallbacks(){

            public void onConfigurationChanged(Configuration configuration) {
                ViewConfigurationHelper.this.updateNativeViewConfigurationIfNecessary();
            }

            public void onLowMemory() {
            }
        });
    }

    private void updateNativeViewConfigurationIfNecessary() {
        ViewConfiguration configuration = ViewConfiguration.get((Context)this.mAppContext);
        if (this.mViewConfiguration == configuration) {
            return;
        }
        this.mViewConfiguration = configuration;
        this.nativeUpdateSharedViewConfiguration(this.getScaledMaximumFlingVelocity(), this.getScaledMinimumFlingVelocity(), this.getScaledTouchSlop(), this.getScaledDoubleTapSlop(), this.getScaledMinScalingSpan(), this.getScaledMinScalingTouchMajor());
    }

    @CalledByNative
    private static int getDoubleTapTimeout() {
        return ViewConfiguration.getDoubleTapTimeout();
    }

    @CalledByNative
    private static int getLongPressTimeout() {
        return ViewConfiguration.getLongPressTimeout();
    }

    @CalledByNative
    private static int getTapTimeout() {
        return ViewConfiguration.getTapTimeout();
    }

    @CalledByNative
    private static float getScrollFriction() {
        return ViewConfiguration.getScrollFriction();
    }

    @CalledByNative
    private int getScaledMaximumFlingVelocity() {
        return this.mViewConfiguration.getScaledMaximumFlingVelocity();
    }

    @CalledByNative
    private int getScaledMinimumFlingVelocity() {
        return this.mViewConfiguration.getScaledMinimumFlingVelocity();
    }

    @CalledByNative
    private int getScaledTouchSlop() {
        return this.mViewConfiguration.getScaledTouchSlop();
    }

    @CalledByNative
    private int getScaledDoubleTapSlop() {
        return this.mViewConfiguration.getScaledDoubleTapSlop();
    }

    @CalledByNative
    private int getScaledMinScalingSpan() {
        Resources res = this.mAppContext.getResources();
        int id2 = res.getIdentifier("config_minScalingSpan", "dimen", "android");
        if (id2 == 0) {
            id2 = R.dimen.config_min_scaling_span;
        }
        try {
            return res.getDimensionPixelSize(id2);
        }
        catch (Resources.NotFoundException e) {
            assert (false) : "MinScalingSpan resource lookup failed.";
            return (int)TypedValue.applyDimension((int)5, (float)27.0f, (DisplayMetrics)res.getDisplayMetrics());
        }
    }

    @CalledByNative
    private int getScaledMinScalingTouchMajor() {
        Resources res = this.mAppContext.getResources();
        int id2 = res.getIdentifier("config_minScalingTouchMajor", "dimen", "android");
        if (id2 == 0) {
            id2 = R.dimen.config_min_scaling_touch_major;
        }
        try {
            return res.getDimensionPixelSize(id2);
        }
        catch (Resources.NotFoundException e) {
            assert (false) : "MinScalingTouchMajor resource lookup failed.";
            return (int)TypedValue.applyDimension((int)1, (float)48.0f, (DisplayMetrics)res.getDisplayMetrics());
        }
    }

    @CalledByNative
    private static ViewConfigurationHelper createWithListener(Context context) {
        ViewConfigurationHelper viewConfigurationHelper = new ViewConfigurationHelper(context);
        viewConfigurationHelper.registerListener();
        return viewConfigurationHelper;
    }

    private native void nativeUpdateSharedViewConfiguration(int var1, int var2, int var3, int var4, int var5, int var6);
}

