/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.gfx;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;

@JNINamespace(value="gfx")
public class BitmapHelper {
    @CalledByNative
    private static Bitmap createBitmap(int width, int height, int bitmapFormatValue) {
        Bitmap.Config bitmapConfig = BitmapHelper.getBitmapConfigForFormat(bitmapFormatValue);
        return Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)bitmapConfig);
    }

    @CalledByNative
    private static Bitmap decodeDrawableResource(String name, int reqWidth, int reqHeight) {
        Resources res = Resources.getSystem();
        int resId = res.getIdentifier(name, null, null);
        if (resId == 0) {
            return null;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)res, (int)resId, (BitmapFactory.Options)options);
        options.inSampleSize = BitmapHelper.calculateInSampleSize(options, reqWidth, reqHeight);
        options.inJustDecodeBounds = false;
        options.inPreferredConfig = Bitmap.Config.ARGB_8888;
        return BitmapFactory.decodeResource((Resources)res, (int)resId, (BitmapFactory.Options)options);
    }

    private static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int widthRatio;
            int heightRatio = Math.round((float)height / (float)reqHeight);
            inSampleSize = heightRatio < (widthRatio = Math.round((float)width / (float)reqWidth)) ? heightRatio : widthRatio;
        }
        return inSampleSize;
    }

    @CalledByNative
    private static int getBitmapFormatForConfig(Bitmap.Config bitmapConfig) {
        switch (bitmapConfig) {
            case ALPHA_8: {
                return 1;
            }
            case ARGB_4444: {
                return 2;
            }
            case ARGB_8888: {
                return 3;
            }
            case RGB_565: {
                return 4;
            }
        }
        return 0;
    }

    private static Bitmap.Config getBitmapConfigForFormat(int bitmapFormatValue) {
        switch (bitmapFormatValue) {
            case 1: {
                return Bitmap.Config.ALPHA_8;
            }
            case 2: {
                return Bitmap.Config.ARGB_4444;
            }
            case 4: {
                return Bitmap.Config.RGB_565;
            }
        }
        return Bitmap.Config.ARGB_8888;
    }
}

