/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.base;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.PendingIntent;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.util.SparseArray;
import android.widget.Toast;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.ui.VSyncMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JNINamespace(value="ui")
public class WindowAndroid {
    private static final String TAG = "WindowAndroid";
    private long mNativeWindowAndroid = 0L;
    private final VSyncMonitor mVSyncMonitor;
    static final String WINDOW_CALLBACK_ERRORS = "window_callback_errors";
    public static final int START_INTENT_FAILURE = -1;
    protected Context mApplicationContext;
    protected SparseArray<IntentCallback> mOutstandingIntents;
    protected HashMap<Integer, String> mIntentErrors;
    private final VSyncMonitor.Listener mVSyncListener = new VSyncMonitor.Listener(){

        public void onVSync(VSyncMonitor monitor, long vsyncTimeMicros) {
            if (WindowAndroid.this.mNativeWindowAndroid != 0L) {
                WindowAndroid.this.nativeOnVSync(WindowAndroid.this.mNativeWindowAndroid, vsyncTimeMicros);
            }
        }
    };

    @SuppressLint(value={"UseSparseArrays"})
    public WindowAndroid(Context context) {
        assert (context == context.getApplicationContext());
        this.mApplicationContext = context;
        this.mOutstandingIntents = new SparseArray();
        this.mIntentErrors = new HashMap();
        this.mVSyncMonitor = new VSyncMonitor(context, this.mVSyncListener);
    }

    public boolean showIntent(PendingIntent intent, IntentCallback callback, int errorId) {
        return this.showCancelableIntent(intent, callback, errorId) >= 0;
    }

    public boolean showIntent(Intent intent, IntentCallback callback, int errorId) {
        return this.showCancelableIntent(intent, callback, errorId) >= 0;
    }

    public int showCancelableIntent(PendingIntent intent, IntentCallback callback, int errorId) {
        Log.d((String)TAG, (String)("Can't show intent as context is not an Activity: " + intent));
        return -1;
    }

    public int showCancelableIntent(Intent intent, IntentCallback callback, int errorId) {
        Log.d((String)TAG, (String)("Can't show intent as context is not an Activity: " + intent));
        return -1;
    }

    public void cancelIntent(int requestCode) {
        Log.d((String)TAG, (String)("Can't cancel intent as context is not an Activity: " + requestCode));
    }

    public boolean removeIntentCallback(IntentCallback callback) {
        int requestCode = this.mOutstandingIntents.indexOfValue((Object)callback);
        if (requestCode < 0) {
            return false;
        }
        this.mOutstandingIntents.remove(requestCode);
        this.mIntentErrors.remove(requestCode);
        return true;
    }

    public void showError(String error) {
        if (error != null) {
            Toast.makeText((Context)this.mApplicationContext, (CharSequence)error, (int)0).show();
        }
    }

    public void showError(int resId) {
        this.showError(this.mApplicationContext.getString(resId));
    }

    protected void showCallbackNonExistentError(String error) {
        this.showError(error);
    }

    public void sendBroadcast(Intent intent) {
        this.mApplicationContext.sendBroadcast(intent);
    }

    public WeakReference<Activity> getActivity() {
        return new WeakReference<Object>(null);
    }

    public Context getApplicationContext() {
        return this.mApplicationContext;
    }

    public void saveInstanceState(Bundle bundle) {
        bundle.putSerializable(WINDOW_CALLBACK_ERRORS, this.mIntentErrors);
    }

    public void restoreInstanceState(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        Serializable errors = bundle.getSerializable(WINDOW_CALLBACK_ERRORS);
        if (errors instanceof HashMap) {
            HashMap intentErrors;
            this.mIntentErrors = intentErrors = (HashMap)errors;
        }
    }

    public boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        return false;
    }

    @CalledByNative
    private void requestVSyncUpdate() {
        this.mVSyncMonitor.requestUpdate();
    }

    public boolean canResolveActivity(Intent intent) {
        return this.mApplicationContext.getPackageManager().resolveActivity(intent, 0) != null;
    }

    public void destroy() {
        if (this.mNativeWindowAndroid != 0L) {
            this.nativeDestroy(this.mNativeWindowAndroid);
            this.mNativeWindowAndroid = 0L;
        }
    }

    public long getNativePointer() {
        if (this.mNativeWindowAndroid == 0L) {
            this.mNativeWindowAndroid = this.nativeInit(this.mVSyncMonitor.getVSyncPeriodInMicroseconds());
        }
        return this.mNativeWindowAndroid;
    }

    private native long nativeInit(long var1);

    private native void nativeOnVSync(long var1, long var3);

    private native void nativeDestroy(long var1);

    public static interface IntentCallback {
        public void onIntentCompleted(WindowAndroid var1, int var2, ContentResolver var3, Intent var4);
    }
}

