/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.base;

import android.view.View;
import org.chromium.base.JNINamespace;
import org.chromium.ui.base.ViewAndroidDelegate;
import org.chromium.ui.base.WindowAndroid;

@JNINamespace(value="ui")
public class ViewAndroid {
    private long mNativeViewAndroid = 0L;
    private final ViewAndroidDelegate mViewAndroidDelegate;
    private final WindowAndroid mWindowAndroid;
    private int mKeepScreenOnCount;
    private View mKeepScreenOnView;

    public ViewAndroid(WindowAndroid nativeWindow, ViewAndroidDelegate viewAndroidDelegate) {
        this.mWindowAndroid = nativeWindow;
        this.mViewAndroidDelegate = viewAndroidDelegate;
        this.mNativeViewAndroid = this.nativeInit(this.mWindowAndroid.getNativePointer());
    }

    public ViewAndroidDelegate getViewAndroidDelegate() {
        return this.mViewAndroidDelegate;
    }

    public void destroy() {
        if (this.mNativeViewAndroid != 0L) {
            this.nativeDestroy(this.mNativeViewAndroid);
            this.mNativeViewAndroid = 0L;
        }
    }

    public long getNativePointer() {
        return this.mNativeViewAndroid;
    }

    public void incrementKeepScreenOnCount() {
        ++this.mKeepScreenOnCount;
        if (this.mKeepScreenOnCount == 1) {
            this.mKeepScreenOnView = this.mViewAndroidDelegate.acquireAnchorView();
            this.mViewAndroidDelegate.setAnchorViewPosition(this.mKeepScreenOnView, 0.0f, 0.0f, 0.0f, 0.0f);
            this.mKeepScreenOnView.setKeepScreenOn(true);
        }
    }

    public void decrementKeepScreenOnCount() {
        assert (this.mKeepScreenOnCount > 0);
        --this.mKeepScreenOnCount;
        if (this.mKeepScreenOnCount == 0) {
            this.mViewAndroidDelegate.releaseAnchorView(this.mKeepScreenOnView);
            this.mKeepScreenOnView = null;
        }
    }

    private native long nativeInit(long var1);

    private native void nativeDestroy(long var1);
}

