/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.base;

import android.content.ContentResolver;
import android.content.Intent;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Environment;
import android.os.Parcelable;
import android.text.TextUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.chromium.base.CalledByNative;
import org.chromium.base.ContentUriUtils;
import org.chromium.base.JNINamespace;
import org.chromium.ui.R;
import org.chromium.ui.base.WindowAndroid;

@JNINamespace(value="ui")
class SelectFileDialog
implements WindowAndroid.IntentCallback {
    private static final String IMAGE_TYPE = "image/";
    private static final String VIDEO_TYPE = "video/";
    private static final String AUDIO_TYPE = "audio/";
    private static final String ALL_IMAGE_TYPES = "image/*";
    private static final String ALL_VIDEO_TYPES = "video/*";
    private static final String ALL_AUDIO_TYPES = "audio/*";
    private static final String ANY_TYPES = "*/*";
    private static final String CAPTURE_IMAGE_DIRECTORY = "browser-photos";
    private final long mNativeSelectFileDialog;
    private List<String> mFileTypes;
    private boolean mCapture;
    private Uri mCameraOutputUri;

    private SelectFileDialog(long nativeSelectFileDialog) {
        this.mNativeSelectFileDialog = nativeSelectFileDialog;
    }

    @CalledByNative
    private void selectFile(String[] fileTypes, boolean capture, WindowAndroid window) {
        this.mFileTypes = new ArrayList<String>(Arrays.asList(fileTypes));
        this.mCapture = capture;
        Intent chooser = new Intent("android.intent.action.CHOOSER");
        Intent camera = new Intent("android.media.action.IMAGE_CAPTURE");
        this.mCameraOutputUri = Uri.fromFile((File)this.getFileForImageCapture());
        camera.putExtra("output", (Parcelable)this.mCameraOutputUri);
        Intent camcorder = new Intent("android.media.action.VIDEO_CAPTURE");
        Intent soundRecorder = new Intent("android.provider.MediaStore.RECORD_SOUND");
        if (this.captureCamera() ? window.showIntent(camera, (WindowAndroid.IntentCallback)this, R.string.low_memory_error) : (this.captureCamcorder() ? window.showIntent(camcorder, (WindowAndroid.IntentCallback)this, R.string.low_memory_error) : this.captureMicrophone() && window.showIntent(soundRecorder, (WindowAndroid.IntentCallback)this, R.string.low_memory_error))) {
            return;
        }
        Intent getContentIntent = new Intent("android.intent.action.GET_CONTENT");
        getContentIntent.addCategory("android.intent.category.OPENABLE");
        ArrayList<Intent> extraIntents = new ArrayList<Intent>();
        if (!this.noSpecificType()) {
            if (this.shouldShowImageTypes()) {
                extraIntents.add(camera);
                getContentIntent.setType(ALL_IMAGE_TYPES);
            } else if (this.shouldShowVideoTypes()) {
                extraIntents.add(camcorder);
                getContentIntent.setType(ALL_VIDEO_TYPES);
            } else if (this.shouldShowAudioTypes()) {
                extraIntents.add(soundRecorder);
                getContentIntent.setType(ALL_AUDIO_TYPES);
            }
        }
        if (extraIntents.isEmpty()) {
            getContentIntent.setType(ANY_TYPES);
            extraIntents.add(camera);
            extraIntents.add(camcorder);
            extraIntents.add(soundRecorder);
        }
        chooser.putExtra("android.intent.extra.INITIAL_INTENTS", (Parcelable[])extraIntents.toArray(new Intent[0]));
        chooser.putExtra("android.intent.extra.INTENT", (Parcelable)getContentIntent);
        if (!window.showIntent(chooser, (WindowAndroid.IntentCallback)this, R.string.low_memory_error)) {
            this.onFileNotSelected();
        }
    }

    private File getFileForImageCapture() {
        File externalDataDir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM);
        File cameraDataDir = new File(externalDataDir.getAbsolutePath() + File.separator + CAPTURE_IMAGE_DIRECTORY);
        if (!cameraDataDir.exists() && !cameraDataDir.mkdirs()) {
            cameraDataDir = externalDataDir;
        }
        File photoFile = new File(cameraDataDir.getAbsolutePath() + File.separator + System.currentTimeMillis() + ".jpg");
        return photoFile;
    }

    public void onIntentCompleted(WindowAndroid window, int resultCode, ContentResolver contentResolver, Intent results) {
        if (resultCode != -1) {
            this.onFileNotSelected();
            return;
        }
        if (results == null) {
            this.nativeOnFileSelected(this.mNativeSelectFileDialog, this.mCameraOutputUri.getPath(), "");
            window.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", this.mCameraOutputUri));
            return;
        }
        if ("file".equals(results.getData().getScheme())) {
            this.nativeOnFileSelected(this.mNativeSelectFileDialog, results.getData().getSchemeSpecificPart(), "");
            return;
        }
        if ("content".equals(results.getScheme())) {
            GetDisplayNameTask task = new GetDisplayNameTask(contentResolver, false);
            task.execute(new Uri[]{results.getData()});
            return;
        }
        this.onFileNotSelected();
        window.showError(R.string.opening_file_error);
    }

    private void onFileNotSelected() {
        this.nativeOnFileNotSelected(this.mNativeSelectFileDialog);
    }

    private boolean noSpecificType() {
        return this.mFileTypes.size() != 1 || this.mFileTypes.contains(ANY_TYPES);
    }

    private boolean shouldShowTypes(String allTypes, String specificType) {
        if (this.noSpecificType() || this.mFileTypes.contains(allTypes)) {
            return true;
        }
        return this.acceptSpecificType(specificType);
    }

    private boolean shouldShowImageTypes() {
        return this.shouldShowTypes(ALL_IMAGE_TYPES, IMAGE_TYPE);
    }

    private boolean shouldShowVideoTypes() {
        return this.shouldShowTypes(ALL_VIDEO_TYPES, VIDEO_TYPE);
    }

    private boolean shouldShowAudioTypes() {
        return this.shouldShowTypes(ALL_AUDIO_TYPES, AUDIO_TYPE);
    }

    private boolean acceptsSpecificType(String type) {
        return this.mFileTypes.size() == 1 && TextUtils.equals((CharSequence)this.mFileTypes.get(0), (CharSequence)type);
    }

    private boolean captureCamera() {
        return this.mCapture && this.acceptsSpecificType(ALL_IMAGE_TYPES);
    }

    private boolean captureCamcorder() {
        return this.mCapture && this.acceptsSpecificType(ALL_VIDEO_TYPES);
    }

    private boolean captureMicrophone() {
        return this.mCapture && this.acceptsSpecificType(ALL_AUDIO_TYPES);
    }

    private boolean acceptSpecificType(String accept) {
        for (String type : this.mFileTypes) {
            if (!type.startsWith(accept)) continue;
            return true;
        }
        return false;
    }

    @CalledByNative
    private static SelectFileDialog create(long nativeSelectFileDialog) {
        return new SelectFileDialog(nativeSelectFileDialog);
    }

    private native void nativeOnFileSelected(long var1, String var3, String var4);

    private native void nativeOnFileNotSelected(long var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetDisplayNameTask
    extends AsyncTask<Uri, Void, String[]> {
        String[] mFilePaths;
        final ContentResolver mContentResolver;
        final boolean mIsMultiple;

        public GetDisplayNameTask(ContentResolver contentResolver, boolean isMultiple) {
            this.mContentResolver = contentResolver;
            this.mIsMultiple = isMultiple;
        }

        protected String[] doInBackground(Uri ... uris) {
            this.mFilePaths = new String[uris.length];
            String[] displayNames = new String[uris.length];
            for (int i = 0; i < uris.length; ++i) {
                this.mFilePaths[i] = uris[i].toString();
                displayNames[i] = ContentUriUtils.getDisplayName(uris[i], this.mContentResolver, "_display_name");
            }
            return displayNames;
        }

        protected void onPostExecute(String[] result) {
            if (!this.mIsMultiple) {
                SelectFileDialog.this.nativeOnFileSelected(SelectFileDialog.this.mNativeSelectFileDialog, this.mFilePaths[0], result[0]);
            }
        }
    }
}

