/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.base;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.widget.Toast;
import org.chromium.base.ApiCompatibilityUtils;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.ui.R;

@JNINamespace(value="ui")
public class Clipboard {
    private final Context mContext;
    private final ClipboardManager mClipboardManager;

    public Clipboard(Context context) {
        this.mContext = context;
        this.mClipboardManager = (ClipboardManager)context.getSystemService("clipboard");
    }

    @CalledByNative
    private static Clipboard create(Context context) {
        return new Clipboard(context);
    }

    @CalledByNative
    private String getCoercedText() {
        CharSequence sequence;
        ClipData clip = this.mClipboardManager.getPrimaryClip();
        if (clip != null && clip.getItemCount() > 0 && (sequence = clip.getItemAt(0).coerceToText(this.mContext)) != null) {
            return ((Object)sequence).toString();
        }
        return null;
    }

    @CalledByNative
    private String getHTMLText() {
        ClipData clip;
        if (Clipboard.isHTMLClipboardSupported() && (clip = this.mClipboardManager.getPrimaryClip()) != null && clip.getItemCount() > 0) {
            return clip.getItemAt(0).getHtmlText();
        }
        return null;
    }

    public void setText(String label, String text) {
        this.setPrimaryClipNoException(ClipData.newPlainText((CharSequence)label, (CharSequence)text));
    }

    @CalledByNative
    public void setText(String text) {
        this.setText(null, text);
    }

    public void setHTMLText(String html, String label, String text) {
        if (Clipboard.isHTMLClipboardSupported()) {
            this.setPrimaryClipNoException(ClipData.newHtmlText((CharSequence)label, (CharSequence)text, (String)html));
        }
    }

    @CalledByNative
    public void setHTMLText(String html, String text) {
        this.setHTMLText(html, null, text);
    }

    @CalledByNative
    private static boolean isHTMLClipboardSupported() {
        return ApiCompatibilityUtils.isHTMLClipboardSupported();
    }

    private void setPrimaryClipNoException(ClipData clip) {
        try {
            this.mClipboardManager.setPrimaryClip(clip);
        }
        catch (Exception ex) {
            String text = this.mContext.getString(R.string.copy_to_clipboard_failure_message);
            Toast.makeText((Context)this.mContext, (CharSequence)text, (int)0).show();
        }
    }
}

