/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.base;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.content.IntentSender;
import java.lang.ref.WeakReference;
import org.chromium.ui.base.WindowAndroid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityWindowAndroid
extends WindowAndroid {
    private static final int REQUEST_CODE_PREFIX = 1000;
    private static final int REQUEST_CODE_RANGE_SIZE = 100;
    private static final String TAG = "ActivityWindowAndroid";
    private final WeakReference<Activity> mActivityRef;
    private int mNextRequestCode = 0;

    public ActivityWindowAndroid(Activity activity) {
        super(activity.getApplicationContext());
        this.mActivityRef = new WeakReference<Activity>(activity);
    }

    @Override
    public int showCancelableIntent(PendingIntent intent, WindowAndroid.IntentCallback callback, int errorId) {
        Activity activity = (Activity)this.mActivityRef.get();
        if (activity == null) {
            return -1;
        }
        int requestCode = this.generateNextRequestCode();
        try {
            activity.startIntentSenderForResult(intent.getIntentSender(), requestCode, new Intent(), 0, 0, 0);
        }
        catch (IntentSender.SendIntentException e) {
            return -1;
        }
        this.storeCallbackData(requestCode, callback, errorId);
        return requestCode;
    }

    @Override
    public int showCancelableIntent(Intent intent, WindowAndroid.IntentCallback callback, int errorId) {
        Activity activity = (Activity)this.mActivityRef.get();
        if (activity == null) {
            return -1;
        }
        int requestCode = this.generateNextRequestCode();
        try {
            activity.startActivityForResult(intent, requestCode);
        }
        catch (ActivityNotFoundException e) {
            return -1;
        }
        this.storeCallbackData(requestCode, callback, errorId);
        return requestCode;
    }

    @Override
    public void cancelIntent(int requestCode) {
        Activity activity = (Activity)this.mActivityRef.get();
        if (activity == null) {
            return;
        }
        activity.finishActivity(requestCode);
    }

    @Override
    public boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        WindowAndroid.IntentCallback callback = (WindowAndroid.IntentCallback)this.mOutstandingIntents.get(requestCode);
        this.mOutstandingIntents.delete(requestCode);
        String errorMessage = (String)this.mIntentErrors.remove(requestCode);
        if (callback != null) {
            callback.onIntentCompleted(this, resultCode, this.mApplicationContext.getContentResolver(), data);
            return true;
        }
        if (errorMessage != null) {
            this.showCallbackNonExistentError(errorMessage);
            return true;
        }
        return false;
    }

    @Override
    public WeakReference<Activity> getActivity() {
        return new WeakReference<Activity>((Activity)this.mActivityRef.get());
    }

    private int generateNextRequestCode() {
        int requestCode = 1000 + this.mNextRequestCode;
        this.mNextRequestCode = (this.mNextRequestCode + 1) % 100;
        return requestCode;
    }

    private void storeCallbackData(int requestCode, WindowAndroid.IntentCallback callback, int errorId) {
        this.mOutstandingIntents.put(requestCode, (Object)callback);
        this.mIntentErrors.put(requestCode, this.mApplicationContext.getString(errorId));
    }
}

