/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.autofill;

import android.content.Context;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.chromium.ui.DropdownAdapter;
import org.chromium.ui.DropdownItem;
import org.chromium.ui.DropdownPopupWindow;
import org.chromium.ui.autofill.AutofillSuggestion;
import org.chromium.ui.base.ViewAndroidDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutofillPopup
extends DropdownPopupWindow
implements AdapterView.OnItemClickListener {
    private static final int ITEM_ID_AUTOCOMPLETE_ENTRY = 0;
    private static final int ITEM_ID_PASSWORD_ENTRY = -2;
    private static final int ITEM_ID_SEPARATOR_ENTRY = -3;
    private static final int ITEM_ID_DATA_LIST_ENTRY = -6;
    private final Context mContext;
    private final AutofillPopupDelegate mAutofillCallback;
    private List<AutofillSuggestion> mSuggestions;

    public AutofillPopup(Context context, ViewAndroidDelegate viewAndroidDelegate, AutofillPopupDelegate autofillCallback) {
        super(context, viewAndroidDelegate);
        this.mContext = context;
        this.mAutofillCallback = autofillCallback;
        this.setOnItemClickListener(this);
    }

    public void filterAndShow(AutofillSuggestion[] suggestions) {
        this.mSuggestions = new ArrayList<AutofillSuggestion>(Arrays.asList(suggestions));
        ArrayList<DropdownItem> cleanedData = new ArrayList<DropdownItem>();
        HashSet<Integer> separators = new HashSet<Integer>();
        for (int i = 0; i < suggestions.length; ++i) {
            int itemId = suggestions[i].mUniqueId;
            if (itemId > 0 || itemId == 0 || itemId == -2 || itemId == -6) {
                cleanedData.add(suggestions[i]);
                continue;
            }
            if (itemId != -3) continue;
            separators.add(cleanedData.size());
        }
        this.setAdapter((ListAdapter)new DropdownAdapter(this.mContext, cleanedData, separators));
        this.show();
    }

    public void dismiss() {
        this.mAutofillCallback.requestHide();
    }

    public void hide() {
        super.dismiss();
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        DropdownAdapter adapter = (DropdownAdapter)parent.getAdapter();
        int listIndex = this.mSuggestions.indexOf(adapter.getItem(position));
        assert (listIndex > -1);
        this.mAutofillCallback.suggestionSelected(listIndex);
    }

    public static interface AutofillPopupDelegate {
        public void requestHide();

        public void suggestionSelected(int var1);
    }
}

