/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.view.Choreographer;
import android.view.WindowManager;
import org.chromium.base.TraceEvent;

@SuppressLint(value={"NewApi"})
public class VSyncMonitor {
    private static final long NANOSECONDS_PER_SECOND = 1000000000L;
    private static final long NANOSECONDS_PER_MILLISECOND = 1000000L;
    private static final long NANOSECONDS_PER_MICROSECOND = 1000L;
    public static final int MAX_AUTO_ONVSYNC_COUNT = 5;
    private Listener mListener;
    private final long mRefreshPeriodNano;
    private boolean mHaveRequestInFlight;
    private int mTriggerNextVSyncCount;
    private final Choreographer mChoreographer;
    private final Choreographer.FrameCallback mVSyncFrameCallback;
    private final Runnable mVSyncRunnableCallback;
    private long mGoodStartingPointNano;
    private long mLastPostedNano;
    private final Handler mHandler = new Handler();
    private final Runnable mSyntheticVSyncRunnable;
    private long mLastVSyncCpuTimeNano;

    public VSyncMonitor(Context context, Listener listener) {
        this(context, listener, true);
    }

    public VSyncMonitor(Context context, Listener listener, boolean enableJBVSync) {
        this.mListener = listener;
        float refreshRate = ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getRefreshRate();
        if (refreshRate <= 0.0f) {
            refreshRate = 60.0f;
        }
        this.mRefreshPeriodNano = (long)(1.0E9f / refreshRate);
        this.mTriggerNextVSyncCount = 0;
        if (enableJBVSync && Build.VERSION.SDK_INT >= 16) {
            this.mChoreographer = Choreographer.getInstance();
            this.mVSyncFrameCallback = new Choreographer.FrameCallback(){

                public void doFrame(long frameTimeNanos) {
                    TraceEvent.begin("VSync");
                    VSyncMonitor.this.mGoodStartingPointNano = frameTimeNanos;
                    VSyncMonitor.this.onVSyncCallback(frameTimeNanos, VSyncMonitor.this.getCurrentNanoTime());
                    TraceEvent.end("VSync");
                }
            };
            this.mVSyncRunnableCallback = null;
        } else {
            this.mChoreographer = null;
            this.mVSyncFrameCallback = null;
            this.mVSyncRunnableCallback = new Runnable(){

                public void run() {
                    TraceEvent.begin("VSyncTimer");
                    long currentTime = VSyncMonitor.this.getCurrentNanoTime();
                    VSyncMonitor.this.onVSyncCallback(currentTime, currentTime);
                    TraceEvent.end("VSyncTimer");
                }
            };
            this.mLastPostedNano = 0L;
        }
        this.mSyntheticVSyncRunnable = new Runnable(){

            public void run() {
                TraceEvent.begin("VSyncSynthetic");
                long currentTime = VSyncMonitor.this.getCurrentNanoTime();
                VSyncMonitor.this.onVSyncCallback(VSyncMonitor.this.estimateLastVSyncTime(currentTime), currentTime);
                TraceEvent.end("VSyncSynthetic");
            }
        };
        this.mGoodStartingPointNano = this.getCurrentNanoTime();
    }

    public long getVSyncPeriodInMicroseconds() {
        return this.mRefreshPeriodNano / 1000L;
    }

    private boolean isVSyncSignalAvailable() {
        return this.mChoreographer != null;
    }

    public void stop() {
        this.mTriggerNextVSyncCount = 0;
    }

    public void requestUpdate() {
        this.mTriggerNextVSyncCount = 5;
        this.postCallback();
    }

    public void setVSyncPointForICS(long goodStartingPointNano) {
        this.mGoodStartingPointNano = goodStartingPointNano;
    }

    private long getCurrentNanoTime() {
        return System.nanoTime();
    }

    private void onVSyncCallback(long frameTimeNanos, long currentTimeNanos) {
        assert (this.mHaveRequestInFlight);
        this.mHaveRequestInFlight = false;
        this.mLastVSyncCpuTimeNano = currentTimeNanos;
        if (this.mTriggerNextVSyncCount >= 0) {
            --this.mTriggerNextVSyncCount;
            this.postCallback();
        }
        if (this.mListener != null) {
            this.mListener.onVSync(this, frameTimeNanos / 1000L);
        }
    }

    private void postCallback() {
        if (this.mHaveRequestInFlight) {
            return;
        }
        this.mHaveRequestInFlight = true;
        if (this.postSyntheticVSync()) {
            return;
        }
        if (this.isVSyncSignalAvailable()) {
            this.mChoreographer.postFrameCallback(this.mVSyncFrameCallback);
        } else {
            this.postRunnableCallback();
        }
    }

    private boolean postSyntheticVSync() {
        long currentTime = this.getCurrentNanoTime();
        if (currentTime - this.mLastVSyncCpuTimeNano < 2L * this.mRefreshPeriodNano) {
            return false;
        }
        if (currentTime - this.estimateLastVSyncTime(currentTime) > this.mRefreshPeriodNano / 2L) {
            return false;
        }
        this.mHandler.post(this.mSyntheticVSyncRunnable);
        return true;
    }

    private long estimateLastVSyncTime(long currentTime) {
        long lastRefreshTime = this.mGoodStartingPointNano + (currentTime - this.mGoodStartingPointNano) / this.mRefreshPeriodNano * this.mRefreshPeriodNano;
        return lastRefreshTime;
    }

    private void postRunnableCallback() {
        assert (!this.isVSyncSignalAvailable());
        long currentTime = this.getCurrentNanoTime();
        long lastRefreshTime = this.estimateLastVSyncTime(currentTime);
        long delay = lastRefreshTime + this.mRefreshPeriodNano - currentTime;
        assert (delay > 0L && delay <= this.mRefreshPeriodNano);
        if (currentTime + delay <= this.mLastPostedNano + this.mRefreshPeriodNano / 2L) {
            delay += this.mRefreshPeriodNano;
        }
        this.mLastPostedNano = currentTime + delay;
        if (delay == 0L) {
            this.mHandler.post(this.mVSyncRunnableCallback);
        } else {
            this.mHandler.postDelayed(this.mVSyncRunnableCallback, delay / 1000000L);
        }
    }

    public static interface Listener {
        public void onVSync(VSyncMonitor var1, long var2);
    }
}

