/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui;

import android.content.Context;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListPopupWindow;
import android.widget.PopupWindow;
import org.chromium.ui.R;
import org.chromium.ui.base.ViewAndroidDelegate;

public class DropdownPopupWindow
extends ListPopupWindow {
    private final Context mContext;
    private final ViewAndroidDelegate mViewAndroidDelegate;
    private final View mAnchorView;
    private float mAnchorWidth;
    private float mAnchorHeight;
    private float mAnchorX;
    private float mAnchorY;
    private View.OnLayoutChangeListener mLayoutChangeListener;
    private PopupWindow.OnDismissListener mOnDismissListener;
    ListAdapter mAdapter;

    public DropdownPopupWindow(Context context, ViewAndroidDelegate viewAndroidDelegate) {
        super(context, null, 0, R.style.DropdownPopupWindow);
        this.mContext = context;
        this.mViewAndroidDelegate = viewAndroidDelegate;
        this.mAnchorView = this.mViewAndroidDelegate.acquireAnchorView();
        this.mAnchorView.setId(R.id.dropdown_popup_window);
        this.mAnchorView.setTag((Object)this);
        this.mLayoutChangeListener = new View.OnLayoutChangeListener(){

            public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                if (v == DropdownPopupWindow.this.mAnchorView) {
                    DropdownPopupWindow.this.show();
                }
            }
        };
        this.mAnchorView.addOnLayoutChangeListener(this.mLayoutChangeListener);
        super.setOnDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                if (DropdownPopupWindow.this.mOnDismissListener != null) {
                    DropdownPopupWindow.this.mOnDismissListener.onDismiss();
                }
                DropdownPopupWindow.this.mAnchorView.removeOnLayoutChangeListener(DropdownPopupWindow.this.mLayoutChangeListener);
                DropdownPopupWindow.this.mAnchorView.setTag(null);
                DropdownPopupWindow.this.mViewAndroidDelegate.releaseAnchorView(DropdownPopupWindow.this.mAnchorView);
            }
        });
        this.setAnchorView(this.mAnchorView);
    }

    public void setAnchorRect(float x, float y, float width, float height) {
        this.mAnchorWidth = width;
        this.mAnchorHeight = height;
        this.mAnchorX = x;
        this.mAnchorY = y;
        if (this.mAnchorView != null) {
            this.mViewAndroidDelegate.setAnchorViewPosition(this.mAnchorView, this.mAnchorX, this.mAnchorY, this.mAnchorWidth, this.mAnchorHeight);
        }
    }

    public void setAdapter(ListAdapter adapter) {
        this.mAdapter = adapter;
        super.setAdapter(adapter);
    }

    public void show() {
        this.setInputMethodMode(1);
        int contentWidth = this.measureContentWidth();
        float contentWidthInDip = (float)contentWidth / this.mContext.getResources().getDisplayMetrics().density;
        if (contentWidthInDip > this.mAnchorWidth) {
            this.setContentWidth(contentWidth);
            Rect displayFrame = new Rect();
            this.mAnchorView.getWindowVisibleDisplayFrame(displayFrame);
            if (this.getWidth() > displayFrame.width()) {
                this.setWidth(displayFrame.width());
            }
        } else {
            this.setWidth(-2);
        }
        this.mViewAndroidDelegate.setAnchorViewPosition(this.mAnchorView, this.mAnchorX, this.mAnchorY, this.mAnchorWidth, this.mAnchorHeight);
        super.show();
        this.getListView().setDividerHeight(0);
    }

    public void setOnDismissListener(PopupWindow.OnDismissListener listener) {
        this.mOnDismissListener = listener;
    }

    private int measureContentWidth() {
        int maxWidth = 0;
        View itemView = null;
        if (this.mAdapter == null) {
            return 0;
        }
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        for (int i = 0; i < this.mAdapter.getCount(); ++i) {
            itemView = this.mAdapter.getView(i, itemView, null);
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
            itemView.setLayoutParams((ViewGroup.LayoutParams)params);
            itemView.measure(widthMeasureSpec, heightMeasureSpec);
            maxWidth = Math.max(maxWidth, itemView.getMeasuredWidth());
        }
        return maxWidth;
    }
}

