/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.view.View;
import android.widget.SeekBar;
import android.widget.TextView;
import org.chromium.base.ApiCompatibilityUtils;
import org.chromium.ui.R;

public class ColorPickerAdvancedComponent {
    private final View mGradientView;
    private final SeekBar mSeekBar;
    private int[] mGradientColors;
    private GradientDrawable mGradientDrawable;
    private final TextView mText;

    ColorPickerAdvancedComponent(View rootView, int textResourceId, int seekBarMax, SeekBar.OnSeekBarChangeListener seekBarListener) {
        this.mGradientView = rootView.findViewById(R.id.gradient);
        this.mText = (TextView)rootView.findViewById(R.id.text);
        this.mText.setText(textResourceId);
        this.mGradientDrawable = new GradientDrawable(GradientDrawable.Orientation.LEFT_RIGHT, null);
        this.mSeekBar = (SeekBar)rootView.findViewById(R.id.seek_bar);
        this.mSeekBar.setOnSeekBarChangeListener(seekBarListener);
        this.mSeekBar.setMax(seekBarMax);
        Context context = rootView.getContext();
        int offset = context.getResources().getDrawable(R.drawable.color_picker_advanced_select_handle).getIntrinsicWidth();
        this.mSeekBar.setThumbOffset(offset / 2);
    }

    public float getValue() {
        return this.mSeekBar.getProgress();
    }

    public void setValue(float newValue) {
        this.mSeekBar.setProgress((int)newValue);
    }

    public void setGradientColors(int[] newColors) {
        this.mGradientColors = (int[])newColors.clone();
        if (Build.VERSION.SDK_INT < 16) {
            GradientDrawable.Orientation currentOrientation = GradientDrawable.Orientation.LEFT_RIGHT;
            this.mGradientDrawable = new GradientDrawable(currentOrientation, this.mGradientColors);
        } else {
            this.mGradientDrawable.setColors(this.mGradientColors);
        }
        ApiCompatibilityUtils.setBackgroundForView(this.mGradientView, (Drawable)this.mGradientDrawable);
    }
}

