/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.http.X509TrustManagerExtensions;
import android.os.Build;
import android.util.Log;
import android.util.Pair;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.chromium.base.JNINamespace;
import org.chromium.net.AndroidCertVerifyResult;

@JNINamespace(value="net")
public class X509Util {
    private static final String TAG = "X509Util";
    private static CertificateFactory sCertificateFactory;
    private static final String OID_TLS_SERVER_AUTH = "1.3.6.1.5.5.7.3.1";
    private static final String OID_ANY_EKU = "2.5.29.37.0";
    private static final String OID_SERVER_GATED_NETSCAPE = "2.16.840.1.113730.4.1";
    private static final String OID_SERVER_GATED_MICROSOFT = "1.3.6.1.4.1.311.10.3.3";
    private static X509TrustManagerImplementation sDefaultTrustManager;
    private static TrustStorageListener sTrustStorageListener;
    private static X509TrustManagerImplementation sTestTrustManager;
    private static KeyStore sTestKeyStore;
    private static KeyStore sSystemKeyStore;
    private static File sSystemCertificateDirectory;
    private static Set<Pair<X500Principal, PublicKey>> sSystemTrustAnchorCache;
    private static boolean sLoadedSystemKeyStore;
    private static final Object sLock;
    private static boolean sDisableNativeCodeForTest;
    private static final char[] HEX_DIGITS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureInitialized() throws CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Object object = sLock;
        synchronized (object) {
            if (sCertificateFactory == null) {
                sCertificateFactory = CertificateFactory.getInstance("X.509");
            }
            if (sDefaultTrustManager == null) {
                sDefaultTrustManager = X509Util.createTrustManager(null);
            }
            if (!sLoadedSystemKeyStore) {
                try {
                    sSystemKeyStore = KeyStore.getInstance("AndroidCAStore");
                    try {
                        sSystemKeyStore.load(null);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    sSystemCertificateDirectory = new File(System.getenv("ANDROID_ROOT") + "/etc/security/cacerts");
                }
                catch (KeyStoreException e) {
                    // empty catch block
                }
                if (!sDisableNativeCodeForTest) {
                    X509Util.nativeRecordCertVerifyCapabilitiesHistogram(sSystemKeyStore != null);
                }
                sLoadedSystemKeyStore = true;
            }
            if (sSystemTrustAnchorCache == null) {
                sSystemTrustAnchorCache = new HashSet<Pair<X500Principal, PublicKey>>();
            }
            if (sTestKeyStore == null) {
                sTestKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                try {
                    sTestKeyStore.load(null);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (sTestTrustManager == null) {
                sTestTrustManager = X509Util.createTrustManager(sTestKeyStore);
            }
            if (!sDisableNativeCodeForTest && sTrustStorageListener == null) {
                sTrustStorageListener = new TrustStorageListener();
                X509Util.nativeGetApplicationContext().registerReceiver((BroadcastReceiver)sTrustStorageListener, new IntentFilter("android.security.STORAGE_CHANGED"));
            }
        }
    }

    private static X509TrustManagerImplementation createTrustManager(KeyStore keyStore) throws KeyStoreException, NoSuchAlgorithmException {
        String algorithm = TrustManagerFactory.getDefaultAlgorithm();
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
        tmf.init(keyStore);
        for (TrustManager tm : tmf.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            try {
                if (Build.VERSION.SDK_INT >= 17) {
                    return new X509TrustManagerJellyBean((X509TrustManager)tm);
                }
                return new X509TrustManagerIceCreamSandwich((X509TrustManager)tm);
            }
            catch (IllegalArgumentException e) {
                String className = tm.getClass().getName();
                Log.e((String)TAG, (String)("Error creating trust manager (" + className + "): " + e));
            }
        }
        Log.e((String)TAG, (String)"Could not find suitable trust manager");
        return null;
    }

    private static void reloadTestTrustManager() throws KeyStoreException, NoSuchAlgorithmException {
        sTestTrustManager = X509Util.createTrustManager(sTestKeyStore);
    }

    private static void reloadDefaultTrustManager() throws KeyStoreException, NoSuchAlgorithmException, CertificateException {
        sDefaultTrustManager = null;
        sSystemTrustAnchorCache = null;
        X509Util.nativeNotifyKeyChainChanged();
        X509Util.ensureInitialized();
    }

    public static X509Certificate createCertificateFromBytes(byte[] derBytes) throws CertificateException, KeyStoreException, NoSuchAlgorithmException {
        X509Util.ensureInitialized();
        return (X509Certificate)sCertificateFactory.generateCertificate(new ByteArrayInputStream(derBytes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTestRootCertificate(byte[] rootCertBytes) throws CertificateException, KeyStoreException, NoSuchAlgorithmException {
        X509Util.ensureInitialized();
        X509Certificate rootCert = X509Util.createCertificateFromBytes(rootCertBytes);
        Object object = sLock;
        synchronized (object) {
            sTestKeyStore.setCertificateEntry("root_cert_" + Integer.toString(sTestKeyStore.size()), rootCert);
            X509Util.reloadTestTrustManager();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearTestRootCertificates() throws NoSuchAlgorithmException, CertificateException, KeyStoreException {
        X509Util.ensureInitialized();
        Object object = sLock;
        synchronized (object) {
            try {
                sTestKeyStore.load(null);
                X509Util.reloadTestTrustManager();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static String hashPrincipal(X500Principal principal) throws NoSuchAlgorithmException {
        byte[] digest = MessageDigest.getInstance("MD5").digest(principal.getEncoded());
        char[] hexChars = new char[8];
        for (int i = 0; i < 4; ++i) {
            hexChars[2 * i] = HEX_DIGITS[digest[3 - i] >> 4 & 0xF];
            hexChars[2 * i + 1] = HEX_DIGITS[digest[3 - i] & 0xF];
        }
        return new String(hexChars);
    }

    private static boolean isKnownRoot(X509Certificate root) throws NoSuchAlgorithmException, KeyStoreException {
        String alias;
        if (sSystemKeyStore == null) {
            return false;
        }
        Pair key = new Pair((Object)root.getSubjectX500Principal(), (Object)root.getPublicKey());
        if (sSystemTrustAnchorCache.contains(key)) {
            return true;
        }
        String hash = X509Util.hashPrincipal(root.getSubjectX500Principal());
        int i = 0;
        while (new File(sSystemCertificateDirectory, alias = hash + '.' + i).exists()) {
            Certificate anchor = sSystemKeyStore.getCertificate("system:" + alias);
            if (anchor != null) {
                if (!(anchor instanceof X509Certificate)) {
                    String className = anchor.getClass().getName();
                    Log.e((String)TAG, (String)("Anchor " + alias + " not an X509Certificate: " + className));
                } else {
                    X509Certificate anchorX509 = (X509Certificate)anchor;
                    if (root.getSubjectX500Principal().equals(anchorX509.getSubjectX500Principal()) && root.getPublicKey().equals(anchorX509.getPublicKey())) {
                        sSystemTrustAnchorCache.add((Pair<X500Principal, PublicKey>)key);
                        return true;
                    }
                }
            }
            ++i;
        }
        return false;
    }

    static boolean verifyKeyUsage(X509Certificate certificate) throws CertificateException {
        List<String> ekuOids;
        try {
            ekuOids = certificate.getExtendedKeyUsage();
        }
        catch (NullPointerException e) {
            return false;
        }
        if (ekuOids == null) {
            return true;
        }
        for (String ekuOid : ekuOids) {
            if (!ekuOid.equals(OID_TLS_SERVER_AUTH) && !ekuOid.equals(OID_ANY_EKU) && !ekuOid.equals(OID_SERVER_GATED_NETSCAPE) && !ekuOid.equals(OID_SERVER_GATED_MICROSOFT)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AndroidCertVerifyResult verifyServerCertificates(byte[][] certChain, String authType, String host) throws KeyStoreException, NoSuchAlgorithmException {
        if (certChain == null || certChain.length == 0 || certChain[0] == null) {
            throw new IllegalArgumentException("Expected non-null and non-empty certificate chain passed as |certChain|. |certChain|=" + Arrays.deepToString((Object[])certChain));
        }
        try {
            X509Util.ensureInitialized();
        }
        catch (CertificateException e) {
            return new AndroidCertVerifyResult(-1);
        }
        X509Certificate[] serverCertificates = new X509Certificate[certChain.length];
        try {
            for (int i = 0; i < certChain.length; ++i) {
                serverCertificates[i] = X509Util.createCertificateFromBytes(certChain[i]);
            }
        }
        catch (CertificateException e) {
            return new AndroidCertVerifyResult(-5);
        }
        try {
            serverCertificates[0].checkValidity();
            if (!X509Util.verifyKeyUsage(serverCertificates[0])) {
                return new AndroidCertVerifyResult(-6);
            }
        }
        catch (CertificateExpiredException e) {
            return new AndroidCertVerifyResult(-3);
        }
        catch (CertificateNotYetValidException e) {
            return new AndroidCertVerifyResult(-4);
        }
        catch (CertificateException e) {
            return new AndroidCertVerifyResult(-1);
        }
        Object object = sLock;
        synchronized (object) {
            List<X509Certificate> verifiedChain;
            if (sDefaultTrustManager == null) {
                return new AndroidCertVerifyResult(-1);
            }
            try {
                verifiedChain = sDefaultTrustManager.checkServerTrusted(serverCertificates, authType, host);
            }
            catch (CertificateException eDefaultManager) {
                try {
                    verifiedChain = sTestTrustManager.checkServerTrusted(serverCertificates, authType, host);
                }
                catch (CertificateException eTestManager) {
                    Log.i((String)TAG, (String)("Failed to validate the certificate chain, error: " + eDefaultManager.getMessage()));
                    return new AndroidCertVerifyResult(-2);
                }
            }
            boolean isIssuedByKnownRoot = false;
            if (verifiedChain.size() > 0) {
                X509Certificate root = verifiedChain.get(verifiedChain.size() - 1);
                isIssuedByKnownRoot = X509Util.isKnownRoot(root);
            }
            return new AndroidCertVerifyResult(0, isIssuedByKnownRoot, verifiedChain);
        }
    }

    public static void setDisableNativeCodeForTest(boolean disabled) {
        sDisableNativeCodeForTest = disabled;
    }

    private static native void nativeNotifyKeyChainChanged();

    private static native void nativeRecordCertVerifyCapabilitiesHistogram(boolean var0);

    private static native Context nativeGetApplicationContext();

    static {
        sLock = new Object();
        sDisableNativeCodeForTest = false;
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class X509TrustManagerJellyBean
    implements X509TrustManagerImplementation {
        private final X509TrustManagerExtensions mTrustManagerExtensions;

        @SuppressLint(value={"NewApi"})
        public X509TrustManagerJellyBean(X509TrustManager trustManager) {
            this.mTrustManagerExtensions = new X509TrustManagerExtensions(trustManager);
        }

        @Override
        public List<X509Certificate> checkServerTrusted(X509Certificate[] chain, String authType, String host) throws CertificateException {
            return this.mTrustManagerExtensions.checkServerTrusted(chain, authType, host);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class X509TrustManagerIceCreamSandwich
    implements X509TrustManagerImplementation {
        private final X509TrustManager mTrustManager;

        public X509TrustManagerIceCreamSandwich(X509TrustManager trustManager) {
            this.mTrustManager = trustManager;
        }

        @Override
        public List<X509Certificate> checkServerTrusted(X509Certificate[] chain, String authType, String host) throws CertificateException {
            this.mTrustManager.checkServerTrusted(chain, authType);
            return Collections.emptyList();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface X509TrustManagerImplementation {
        public List<X509Certificate> checkServerTrusted(X509Certificate[] var1, String var2, String var3) throws CertificateException;
    }

    private static final class TrustStorageListener
    extends BroadcastReceiver {
        private TrustStorageListener() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.security.STORAGE_CHANGED")) {
                try {
                    X509Util.reloadDefaultTrustManager();
                }
                catch (CertificateException e) {
                    Log.e((String)X509Util.TAG, (String)"Unable to reload the default TrustManager", (Throwable)e);
                }
                catch (KeyStoreException e) {
                    Log.e((String)X509Util.TAG, (String)"Unable to reload the default TrustManager", (Throwable)e);
                }
                catch (NoSuchAlgorithmException e) {
                    Log.e((String)X509Util.TAG, (String)"Unable to reload the default TrustManager", (Throwable)e);
                }
            }
        }
    }
}

