/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import android.os.RemoteException;
import android.util.Log;
import org.chromium.net.AndroidKeyStore;
import org.chromium.net.AndroidPrivateKey;
import org.chromium.net.IRemoteAndroidKeyStore;

public class RemoteAndroidKeyStore
implements AndroidKeyStore {
    private static final String TAG = "AndroidKeyStoreRemoteImpl";
    private final IRemoteAndroidKeyStore mRemoteManager;

    public RemoteAndroidKeyStore(IRemoteAndroidKeyStore manager) {
        this.mRemoteManager = manager;
    }

    public byte[] getRSAKeyModulus(AndroidPrivateKey key) {
        RemotePrivateKey remoteKey = (RemotePrivateKey)key;
        try {
            Log.d((String)TAG, (String)"getRSAKeyModulus");
            return this.mRemoteManager.getRSAKeyModulus(remoteKey.getHandle());
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] getDSAKeyParamQ(AndroidPrivateKey key) {
        RemotePrivateKey remoteKey = (RemotePrivateKey)key;
        try {
            Log.d((String)TAG, (String)"getDSAKeyParamQ");
            return this.mRemoteManager.getDSAKeyParamQ(remoteKey.getHandle());
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] getECKeyOrder(AndroidPrivateKey key) {
        RemotePrivateKey remoteKey = (RemotePrivateKey)key;
        try {
            Log.d((String)TAG, (String)"getECKeyOrder");
            return this.mRemoteManager.getECKeyOrder(remoteKey.getHandle());
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] rawSignDigestWithPrivateKey(AndroidPrivateKey key, byte[] message) {
        RemotePrivateKey remoteKey = (RemotePrivateKey)key;
        try {
            Log.d((String)TAG, (String)"rawSignDigestWithPrivateKey");
            return this.mRemoteManager.rawSignDigestWithPrivateKey(remoteKey.getHandle(), message);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getPrivateKeyType(AndroidPrivateKey key) {
        RemotePrivateKey remoteKey = (RemotePrivateKey)key;
        try {
            Log.d((String)TAG, (String)"getPrivateKeyType");
            return this.mRemoteManager.getPrivateKeyType(remoteKey.getHandle());
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public byte[] getPrivateKeyEncodedBytes(AndroidPrivateKey key) {
        assert (false);
        return null;
    }

    public long getOpenSSLHandleForPrivateKey(AndroidPrivateKey privateKey) {
        assert (false);
        return 0L;
    }

    public AndroidPrivateKey createKey(String alias) {
        try {
            int handle = this.mRemoteManager.getPrivateKeyHandle(alias);
            return new RemotePrivateKey(handle, this);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void releaseKey(AndroidPrivateKey key) {
        RemotePrivateKey remoteKey = (RemotePrivateKey)key;
        try {
            Log.d((String)TAG, (String)"releaseKey");
            this.mRemoteManager.releaseKey(remoteKey.getHandle());
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private static class RemotePrivateKey
    implements AndroidPrivateKey {
        final int mHandle;
        final RemoteAndroidKeyStore mStore;

        RemotePrivateKey(int handle, RemoteAndroidKeyStore store) {
            this.mHandle = handle;
            this.mStore = store;
        }

        public int getHandle() {
            return this.mHandle;
        }

        public AndroidKeyStore getKeyStore() {
            return this.mStore;
        }
    }
}

