/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.util.Log;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.base.NativeClassQualifiedName;

@JNINamespace(value="net")
public class ProxyChangeListener {
    private static final String TAG = "ProxyChangeListener";
    private static boolean sEnabled = true;
    private long mNativePtr;
    private Context mContext;
    private ProxyReceiver mProxyReceiver;
    private Delegate mDelegate;

    private ProxyChangeListener(Context context) {
        this.mContext = context;
    }

    public static void setEnabled(boolean enabled) {
        sEnabled = enabled;
    }

    public void setDelegateForTesting(Delegate delegate) {
        this.mDelegate = delegate;
    }

    @CalledByNative
    public static ProxyChangeListener create(Context context) {
        return new ProxyChangeListener(context);
    }

    @CalledByNative
    public static String getProperty(String property) {
        return System.getProperty(property);
    }

    @CalledByNative
    public void start(long nativePtr) {
        assert (this.mNativePtr == 0L);
        this.mNativePtr = nativePtr;
        this.registerReceiver();
    }

    @CalledByNative
    public void stop() {
        this.mNativePtr = 0L;
        this.unregisterReceiver();
    }

    private void proxySettingsChanged(ProxyConfig cfg) {
        if (!sEnabled) {
            return;
        }
        if (this.mDelegate != null) {
            this.mDelegate.proxySettingsChanged();
        }
        if (this.mNativePtr == 0L) {
            return;
        }
        if (cfg != null) {
            this.nativeProxySettingsChangedTo(this.mNativePtr, cfg.mHost, cfg.mPort);
        } else {
            this.nativeProxySettingsChanged(this.mNativePtr);
        }
    }

    private void registerReceiver() {
        if (this.mProxyReceiver != null) {
            return;
        }
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.PROXY_CHANGE");
        this.mProxyReceiver = new ProxyReceiver();
        this.mContext.getApplicationContext().registerReceiver((BroadcastReceiver)this.mProxyReceiver, filter);
    }

    private void unregisterReceiver() {
        if (this.mProxyReceiver == null) {
            return;
        }
        this.mContext.unregisterReceiver((BroadcastReceiver)this.mProxyReceiver);
        this.mProxyReceiver = null;
    }

    @NativeClassQualifiedName(value="ProxyConfigServiceAndroid::JNIDelegate")
    private native void nativeProxySettingsChangedTo(long var1, String var3, int var4);

    @NativeClassQualifiedName(value="ProxyConfigServiceAndroid::JNIDelegate")
    private native void nativeProxySettingsChanged(long var1);

    private class ProxyReceiver
    extends BroadcastReceiver {
        private ProxyReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.intent.action.PROXY_CHANGE")) {
                ProxyChangeListener.this.proxySettingsChanged(this.extractNewProxy(intent));
            }
        }

        private ProxyConfig extractNewProxy(Intent intent) {
            try {
                String proxyInfo;
                String className;
                String GET_HOST_NAME = "getHost";
                String GET_PORT_NAME = "getPort";
                if (Build.VERSION.SDK_INT <= 19) {
                    className = "android.net.ProxyProperties";
                    proxyInfo = "proxy";
                } else {
                    className = "android.net.ProxyInfo";
                    proxyInfo = "android.intent.extra.PROXY_INFO";
                }
                Object props = intent.getExtras().get(proxyInfo);
                if (props == null) {
                    return null;
                }
                Class<?> cls = Class.forName(className);
                Method getHostMethod = cls.getDeclaredMethod("getHost", new Class[0]);
                Method getPortMethod = cls.getDeclaredMethod("getPort", new Class[0]);
                String host = (String)getHostMethod.invoke(props, new Object[0]);
                int port = (Integer)getPortMethod.invoke(props, new Object[0]);
                return new ProxyConfig(host, port);
            }
            catch (ClassNotFoundException ex) {
                Log.e((String)ProxyChangeListener.TAG, (String)("Using no proxy configuration due to exception:" + ex));
                return null;
            }
            catch (NoSuchMethodException ex) {
                Log.e((String)ProxyChangeListener.TAG, (String)("Using no proxy configuration due to exception:" + ex));
                return null;
            }
            catch (IllegalAccessException ex) {
                Log.e((String)ProxyChangeListener.TAG, (String)("Using no proxy configuration due to exception:" + ex));
                return null;
            }
            catch (InvocationTargetException ex) {
                Log.e((String)ProxyChangeListener.TAG, (String)("Using no proxy configuration due to exception:" + ex));
                return null;
            }
            catch (NullPointerException ex) {
                Log.e((String)ProxyChangeListener.TAG, (String)("Using no proxy configuration due to exception:" + ex));
                return null;
            }
        }
    }

    public static interface Delegate {
        public void proxySettingsChanged();
    }

    private static class ProxyConfig {
        public final String mHost;
        public final int mPort;

        public ProxyConfig(String host, int port) {
            this.mHost = host;
            this.mPort = port;
        }
    }
}

