/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.text.Normalizer;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;

@JNINamespace(value="net::android")
public class NetStringUtil {
    @CalledByNative
    private static String convertToUnicode(ByteBuffer text, String charset_name) {
        try {
            Charset charset = Charset.forName(charset_name);
            CharsetDecoder decoder = charset.newDecoder();
            return decoder.decode(text).toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    @CalledByNative
    private static String convertToUnicodeAndNormalize(ByteBuffer text, String charset_name) {
        String unicodeString = NetStringUtil.convertToUnicode(text, charset_name);
        if (unicodeString == null) {
            return unicodeString;
        }
        return Normalizer.normalize(unicodeString, Normalizer.Form.NFC);
    }

    @CalledByNative
    private static String convertToUnicodeWithSubstitutions(ByteBuffer text, String charset_name) {
        try {
            Charset charset = Charset.forName(charset_name);
            CharsetDecoder decoder = charset.newDecoder();
            decoder.onMalformedInput(CodingErrorAction.REPLACE);
            decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            decoder.replaceWith("\ufffd");
            return decoder.decode(text).toString();
        }
        catch (Exception e) {
            return null;
        }
    }
}

