/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import android.util.Log;
import java.lang.reflect.Method;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.interfaces.DSAKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.ECParameterSpec;
import org.chromium.net.AndroidKeyStore;
import org.chromium.net.AndroidPrivateKey;

public class DefaultAndroidKeyStore
implements AndroidKeyStore {
    private static final String TAG = "AndroidKeyStoreInProcessImpl";

    public AndroidPrivateKey createKey(PrivateKey javaKey) {
        return new DefaultAndroidPrivateKey(javaKey, this);
    }

    public byte[] getRSAKeyModulus(AndroidPrivateKey key) {
        PrivateKey javaKey = ((DefaultAndroidPrivateKey)key).getJavaKey();
        if (javaKey instanceof RSAKey) {
            return ((RSAKey)((Object)javaKey)).getModulus().toByteArray();
        }
        Log.w((String)TAG, (String)"Not a RSAKey instance!");
        return null;
    }

    public byte[] getDSAKeyParamQ(AndroidPrivateKey key) {
        PrivateKey javaKey = ((DefaultAndroidPrivateKey)key).getJavaKey();
        if (javaKey instanceof DSAKey) {
            DSAParams params = ((DSAKey)((Object)javaKey)).getParams();
            return params.getQ().toByteArray();
        }
        Log.w((String)TAG, (String)"Not a DSAKey instance!");
        return null;
    }

    public byte[] getECKeyOrder(AndroidPrivateKey key) {
        PrivateKey javaKey = ((DefaultAndroidPrivateKey)key).getJavaKey();
        if (javaKey instanceof ECKey) {
            ECParameterSpec params = ((ECKey)((Object)javaKey)).getParams();
            return params.getOrder().toByteArray();
        }
        Log.w((String)TAG, (String)"Not an ECKey instance!");
        return null;
    }

    public byte[] getPrivateKeyEncodedBytes(AndroidPrivateKey key) {
        PrivateKey javaKey = ((DefaultAndroidPrivateKey)key).getJavaKey();
        return javaKey.getEncoded();
    }

    public byte[] rawSignDigestWithPrivateKey(AndroidPrivateKey key, byte[] message) {
        PrivateKey javaKey = ((DefaultAndroidPrivateKey)key).getJavaKey();
        Signature signature = null;
        try {
            if (javaKey instanceof RSAPrivateKey) {
                signature = Signature.getInstance("NONEwithRSA");
            } else if (javaKey instanceof DSAPrivateKey) {
                signature = Signature.getInstance("NONEwithDSA");
            } else if (javaKey instanceof ECPrivateKey) {
                signature = Signature.getInstance("NONEwithECDSA");
            }
        }
        catch (NoSuchAlgorithmException e) {
            // empty catch block
        }
        if (signature == null) {
            Log.e((String)TAG, (String)("Unsupported private key algorithm: " + javaKey.getAlgorithm()));
            return null;
        }
        try {
            signature.initSign(javaKey);
            signature.update(message);
            return signature.sign();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Exception while signing message with " + javaKey.getAlgorithm() + " private key: " + e));
            return null;
        }
    }

    public int getPrivateKeyType(AndroidPrivateKey key) {
        PrivateKey javaKey = ((DefaultAndroidPrivateKey)key).getJavaKey();
        if (javaKey instanceof RSAPrivateKey) {
            return 0;
        }
        if (javaKey instanceof DSAPrivateKey) {
            return 1;
        }
        if (javaKey instanceof ECPrivateKey) {
            return 2;
        }
        return 255;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getOpenSSLHandleForPrivateKey(AndroidPrivateKey key) {
        Class<?> superClass;
        PrivateKey javaKey = ((DefaultAndroidPrivateKey)key).getJavaKey();
        if (javaKey == null) {
            Log.e((String)TAG, (String)"key == null");
            return 0L;
        }
        if (!(javaKey instanceof RSAPrivateKey)) {
            Log.e((String)TAG, (String)"does not implement RSAPrivateKey");
            return 0L;
        }
        try {
            superClass = Class.forName("org.apache.harmony.xnet.provider.jsse.OpenSSLRSAPrivateKey");
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Cannot find system OpenSSLRSAPrivateKey class: " + e));
            return 0L;
        }
        if (!superClass.isInstance(javaKey)) {
            Log.e((String)TAG, (String)("Private key is not an OpenSSLRSAPrivateKey instance, its class name is:" + javaKey.getClass().getCanonicalName()));
            return 0L;
        }
        try {
            Method getPkeyContext;
            Method getKey = superClass.getDeclaredMethod("getOpenSSLKey", new Class[0]);
            getKey.setAccessible(true);
            Object opensslKey = null;
            try {
                opensslKey = getKey.invoke((Object)javaKey, new Object[0]);
            }
            finally {
                getKey.setAccessible(false);
            }
            if (opensslKey == null) {
                Log.e((String)TAG, (String)"getOpenSSLKey() returned null");
                return 0L;
            }
            try {
                getPkeyContext = opensslKey.getClass().getDeclaredMethod("getPkeyContext", new Class[0]);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("No getPkeyContext() method on OpenSSLKey member:" + e));
                return 0L;
            }
            getPkeyContext.setAccessible(true);
            long evp_pkey = 0L;
            try {
                evp_pkey = ((Number)getPkeyContext.invoke(opensslKey, new Object[0])).longValue();
            }
            finally {
                getPkeyContext.setAccessible(false);
            }
            if (evp_pkey == 0L) {
                Log.e((String)TAG, (String)"getPkeyContext() returned null");
            }
            return evp_pkey;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Exception while trying to retrieve system EVP_PKEY handle: " + e));
            return 0L;
        }
    }

    public void releaseKey(AndroidPrivateKey key) {
    }

    private static class DefaultAndroidPrivateKey
    implements AndroidPrivateKey {
        final PrivateKey mKey;
        final DefaultAndroidKeyStore mStore;

        DefaultAndroidPrivateKey(PrivateKey key, DefaultAndroidKeyStore store) {
            this.mKey = key;
            this.mStore = store;
        }

        PrivateKey getJavaKey() {
            return this.mKey;
        }

        public AndroidKeyStore getKeyStore() {
            return this.mStore;
        }
    }
}

