/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.media;

import android.content.Context;
import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;

@JNINamespace(value="media")
class WebAudioMediaCodecBridge {
    static final String LOG_TAG = "WebAudioMediaCodec";
    static final long TIMEOUT_MICROSECONDS = 500L;

    WebAudioMediaCodecBridge() {
    }

    @CalledByNative
    private static String CreateTempFile(Context ctx) throws IOException {
        File outputDirectory = ctx.getCacheDir();
        File outputFile = File.createTempFile("webaudio", ".dat", outputDirectory);
        return outputFile.getAbsolutePath();
    }

    @CalledByNative
    private static boolean decodeAudioFile(Context ctx, long nativeMediaCodecBridge, int inputFD, long dataSize) {
        MediaCodec codec;
        int inputChannelCount;
        if (dataSize < 0L || dataSize > Integer.MAX_VALUE) {
            return false;
        }
        MediaExtractor extractor = new MediaExtractor();
        ParcelFileDescriptor encodedFD = ParcelFileDescriptor.adoptFd((int)inputFD);
        try {
            extractor.setDataSource(encodedFD.getFileDescriptor(), 0L, dataSize);
        }
        catch (Exception e) {
            e.printStackTrace();
            encodedFD.detachFd();
            return false;
        }
        if (extractor.getTrackCount() <= 0) {
            encodedFD.detachFd();
            return false;
        }
        MediaFormat format = extractor.getTrackFormat(0);
        int outputChannelCount = inputChannelCount = format.getInteger("channel-count");
        int sampleRate = format.getInteger("sample-rate");
        String mime = format.getString("mime");
        long durationMicroseconds = 0L;
        if (format.containsKey("durationUs")) {
            try {
                durationMicroseconds = format.getLong("durationUs");
            }
            catch (Exception e) {
                Log.d((String)LOG_TAG, (String)"Cannot get duration");
            }
        }
        if (durationMicroseconds > Integer.MAX_VALUE) {
            durationMicroseconds = 0L;
        }
        Log.d((String)LOG_TAG, (String)("Initial: Tracks: " + extractor.getTrackCount() + " Format: " + format));
        try {
            codec = MediaCodec.createDecoderByType((String)mime);
        }
        catch (Exception e) {
            Log.w((String)LOG_TAG, (String)("Failed to create MediaCodec for mime type: " + mime));
            encodedFD.detachFd();
            return false;
        }
        codec.configure(format, null, null, 0);
        codec.start();
        ByteBuffer[] codecInputBuffers = codec.getInputBuffers();
        ByteBuffer[] codecOutputBuffers = codec.getOutputBuffers();
        extractor.selectTrack(0);
        boolean sawInputEOS = false;
        boolean sawOutputEOS = false;
        boolean destinationInitialized = false;
        while (!sawOutputEOS) {
            MediaCodec.BufferInfo info;
            int outputBufIndex;
            int inputBufIndex;
            if (!sawInputEOS && (inputBufIndex = codec.dequeueInputBuffer(500L)) >= 0) {
                ByteBuffer dstBuf = codecInputBuffers[inputBufIndex];
                int sampleSize = extractor.readSampleData(dstBuf, 0);
                long presentationTimeMicroSec = 0L;
                if (sampleSize < 0) {
                    sawInputEOS = true;
                    sampleSize = 0;
                } else {
                    presentationTimeMicroSec = extractor.getSampleTime();
                }
                codec.queueInputBuffer(inputBufIndex, 0, sampleSize, presentationTimeMicroSec, sawInputEOS ? 4 : 0);
                if (!sawInputEOS) {
                    extractor.advance();
                }
            }
            if ((outputBufIndex = codec.dequeueOutputBuffer(info = new MediaCodec.BufferInfo(), 500L)) >= 0) {
                ByteBuffer buf = codecOutputBuffers[outputBufIndex];
                if (!destinationInitialized) {
                    Log.d((String)LOG_TAG, (String)("Final:  Rate: " + sampleRate + " Channels: " + inputChannelCount + " Mime: " + mime + " Duration: " + durationMicroseconds + " microsec"));
                    WebAudioMediaCodecBridge.nativeInitializeDestination(nativeMediaCodecBridge, inputChannelCount, sampleRate, durationMicroseconds);
                    destinationInitialized = true;
                }
                if (destinationInitialized && info.size > 0) {
                    WebAudioMediaCodecBridge.nativeOnChunkDecoded(nativeMediaCodecBridge, buf, info.size, inputChannelCount, outputChannelCount);
                }
                buf.clear();
                codec.releaseOutputBuffer(outputBufIndex, false);
                if ((info.flags & 4) == 0) continue;
                sawOutputEOS = true;
                continue;
            }
            if (outputBufIndex == -3) {
                codecOutputBuffers = codec.getOutputBuffers();
                continue;
            }
            if (outputBufIndex != -2) continue;
            MediaFormat newFormat = codec.getOutputFormat();
            outputChannelCount = newFormat.getInteger("channel-count");
            sampleRate = newFormat.getInteger("sample-rate");
            Log.d((String)LOG_TAG, (String)("output format changed to " + newFormat));
        }
        encodedFD.detachFd();
        codec.stop();
        codec.release();
        codec = null;
        return true;
    }

    private static native void nativeOnChunkDecoded(long var0, ByteBuffer var2, int var3, int var4, int var5);

    private static native void nativeInitializeDestination(long var0, int var2, int var3, long var4);
}

