/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.media;

import android.content.Context;
import android.hardware.Camera;
import android.os.Build;
import android.util.Log;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.media.VideoCapture;
import org.chromium.media.VideoCaptureAndroid;
import org.chromium.media.VideoCaptureTango;

@JNINamespace(value="media")
class VideoCaptureFactory {
    VideoCaptureFactory() {
    }

    @CalledByNative
    static VideoCapture createVideoCapture(Context context, int id2, long nativeVideoCaptureDeviceAndroid) {
        if (ChromiumCameraInfo.isSpecialCamera(id2)) {
            return new VideoCaptureTango(context, ChromiumCameraInfo.toSpecialCameraId(id2), nativeVideoCaptureDeviceAndroid);
        }
        return new VideoCaptureAndroid(context, id2, nativeVideoCaptureDeviceAndroid);
    }

    @CalledByNative
    static VideoCapture.CaptureFormat[] getDeviceSupportedFormats(int id2) {
        return ChromiumCameraInfo.isSpecialCamera(id2) ? VideoCaptureTango.getDeviceSupportedFormats(ChromiumCameraInfo.toSpecialCameraId(id2)) : VideoCaptureAndroid.getDeviceSupportedFormats(id2);
    }

    @CalledByNative
    static int getCaptureFormatWidth(VideoCapture.CaptureFormat format) {
        return format.getWidth();
    }

    @CalledByNative
    static int getCaptureFormatHeight(VideoCapture.CaptureFormat format) {
        return format.getHeight();
    }

    @CalledByNative
    static int getCaptureFormatFramerate(VideoCapture.CaptureFormat format) {
        return format.getFramerate();
    }

    @CalledByNative
    static int getCaptureFormatPixelFormat(VideoCapture.CaptureFormat format) {
        return format.getPixelFormat();
    }

    static class ChromiumCameraInfo {
        private final int mId;
        private final Camera.CameraInfo mCameraInfo;
        private static final String[][] s_SPECIAL_DEVICE_LIST = new String[][]{{"Peanut", "peanut"}};
        private static final String TAG = "ChromiumCameraInfo";
        private static int sNumberOfSystemCameras = -1;

        private static boolean isSpecialDevice() {
            for (String[] device : s_SPECIAL_DEVICE_LIST) {
                if (!device[0].contentEquals(Build.MODEL) || !device[1].contentEquals(Build.DEVICE)) continue;
                return true;
            }
            return false;
        }

        private static boolean isSpecialCamera(int id2) {
            return id2 >= sNumberOfSystemCameras;
        }

        private static int toSpecialCameraId(int id2) {
            assert (ChromiumCameraInfo.isSpecialCamera(id2));
            return id2 - sNumberOfSystemCameras;
        }

        private ChromiumCameraInfo(int index) {
            this.mId = index;
            this.mCameraInfo = ChromiumCameraInfo.isSpecialCamera(index) ? null : this.getCameraInfo(this.mId);
        }

        @CalledByNative(value="ChromiumCameraInfo")
        private static int getNumberOfCameras(Context appContext) {
            if (sNumberOfSystemCameras == -1) {
                if (0 == appContext.getPackageManager().checkPermission("android.permission.CAMERA", appContext.getPackageName())) {
                    sNumberOfSystemCameras = Camera.getNumberOfCameras();
                } else {
                    sNumberOfSystemCameras = 0;
                    Log.w((String)TAG, (String)"Missing android.permission.CAMERA permission, no system camera available.");
                }
            }
            if (ChromiumCameraInfo.isSpecialDevice()) {
                Log.d((String)TAG, (String)("Special device: " + Build.MODEL));
                return sNumberOfSystemCameras + VideoCaptureTango.numberOfCameras();
            }
            return sNumberOfSystemCameras;
        }

        @CalledByNative(value="ChromiumCameraInfo")
        private static ChromiumCameraInfo getAt(int index) {
            return new ChromiumCameraInfo(index);
        }

        @CalledByNative(value="ChromiumCameraInfo")
        private int getId() {
            return this.mId;
        }

        @CalledByNative(value="ChromiumCameraInfo")
        private String getDeviceName() {
            if (ChromiumCameraInfo.isSpecialCamera(this.mId)) {
                return VideoCaptureTango.getCamParams((int)ChromiumCameraInfo.toSpecialCameraId((int)this.mId)).mName;
            }
            if (this.mCameraInfo == null) {
                return "";
            }
            Log.d((String)TAG, (String)("Camera enumerated: " + (this.mCameraInfo.facing == 1 ? "front" : "back")));
            return "camera " + this.mId + ", facing " + (this.mCameraInfo.facing == 1 ? "front" : "back");
        }

        @CalledByNative(value="ChromiumCameraInfo")
        private int getOrientation() {
            if (ChromiumCameraInfo.isSpecialCamera(this.mId)) {
                return 0;
            }
            return this.mCameraInfo == null ? 0 : this.mCameraInfo.orientation;
        }

        private Camera.CameraInfo getCameraInfo(int id2) {
            Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
            try {
                Camera.getCameraInfo((int)id2, (Camera.CameraInfo)cameraInfo);
            }
            catch (RuntimeException ex) {
                Log.e((String)TAG, (String)("getCameraInfo: Camera.getCameraInfo: " + ex));
                return null;
            }
            return cameraInfo;
        }
    }

    static class CamParams {
        final int mId;
        final String mName;
        final int mWidth;
        final int mHeight;

        CamParams(int id2, String name, int width, int height) {
            this.mId = id2;
            this.mName = name;
            this.mWidth = width;
            this.mHeight = height;
        }
    }
}

