/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.media;

import android.content.Context;
import android.graphics.ImageFormat;
import android.hardware.Camera;
import android.os.Build;
import android.util.Log;
import java.util.ArrayList;
import org.chromium.media.VideoCapture;

public class VideoCaptureAndroid
extends VideoCapture {
    private int mExpectedFrameSize;
    private static final int NUM_CAPTURE_BUFFERS = 3;
    private static final String TAG = "VideoCaptureAndroid";

    static VideoCapture.CaptureFormat[] getDeviceSupportedFormats(int id2) {
        Camera camera;
        try {
            camera = Camera.open((int)id2);
        }
        catch (RuntimeException ex) {
            Log.e((String)TAG, (String)("Camera.open: " + ex));
            return null;
        }
        Camera.Parameters parameters = VideoCaptureAndroid.getCameraParameters(camera);
        if (parameters == null) {
            return null;
        }
        ArrayList<VideoCapture.CaptureFormat> formatList = new ArrayList<VideoCapture.CaptureFormat>();
        ArrayList<Integer> pixelFormats = parameters.getSupportedPreviewFormats();
        if (pixelFormats == null) {
            pixelFormats = new ArrayList<Integer>();
        }
        if (pixelFormats.size() == 0) {
            pixelFormats.add(0);
        }
        for (Integer previewFormat : pixelFormats) {
            int pixelFormat = 0;
            if (previewFormat == 842094169) {
                pixelFormat = 842094169;
            } else if (previewFormat == 17) continue;
            ArrayList<int[]> listFpsRange = parameters.getSupportedPreviewFpsRange();
            if (listFpsRange == null) {
                listFpsRange = new ArrayList<int[]>();
            }
            if (listFpsRange.size() == 0) {
                listFpsRange.add(new int[]{0, 0});
            }
            for (int[] fpsRange : listFpsRange) {
                ArrayList<Camera.Size> supportedSizes = parameters.getSupportedPreviewSizes();
                if (supportedSizes == null) {
                    supportedSizes = new ArrayList<Camera.Size>();
                }
                if (supportedSizes.size() == 0) {
                    Camera camera2 = camera;
                    camera2.getClass();
                    supportedSizes.add(new Camera.Size(camera2, 0, 0));
                }
                for (Camera.Size size : supportedSizes) {
                    formatList.add(new VideoCapture.CaptureFormat(size.width, size.height, (fpsRange[0] + 999) / 1000, pixelFormat));
                }
            }
        }
        camera.release();
        return formatList.toArray(new VideoCapture.CaptureFormat[formatList.size()]);
    }

    VideoCaptureAndroid(Context context, int id2, long nativeVideoCaptureDeviceAndroid) {
        super(context, id2, nativeVideoCaptureDeviceAndroid);
    }

    protected void setCaptureParameters(int width, int height, int frameRate, Camera.Parameters cameraParameters) {
        this.mCaptureFormat = new VideoCapture.CaptureFormat(width, height, frameRate, BuggyDeviceHack.getImageFormat());
        BuggyDeviceHack.applyMinDimensions(this.mCaptureFormat);
    }

    protected void allocateBuffers() {
        this.mExpectedFrameSize = this.mCaptureFormat.mWidth * this.mCaptureFormat.mHeight * ImageFormat.getBitsPerPixel((int)this.mCaptureFormat.mPixelFormat) / 8;
        for (int i = 0; i < 3; ++i) {
            byte[] buffer = new byte[this.mExpectedFrameSize];
            this.mCamera.addCallbackBuffer(buffer);
        }
    }

    protected void setPreviewCallback(Camera.PreviewCallback cb) {
        this.mCamera.setPreviewCallbackWithBuffer(cb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPreviewFrame(byte[] data, Camera camera) {
        this.mPreviewBufferLock.lock();
        try {
            if (!this.mIsRunning) {
                return;
            }
            if (data.length == this.mExpectedFrameSize) {
                int rotation = this.getDeviceOrientation();
                if (rotation != this.mDeviceOrientation) {
                    this.mDeviceOrientation = rotation;
                }
                if (this.mCameraFacing == 0) {
                    rotation = 360 - rotation;
                }
                rotation = (this.mCameraOrientation + rotation) % 360;
                this.nativeOnFrameAvailable(this.mNativeVideoCaptureDeviceAndroid, data, this.mExpectedFrameSize, rotation);
            }
        }
        finally {
            this.mPreviewBufferLock.unlock();
            if (camera != null) {
                camera.addCallbackBuffer(data);
            }
        }
    }

    private static class BuggyDeviceHack {
        private static final IdAndSizes[] s_CAPTURESIZE_BUGGY_DEVICE_LIST = new IdAndSizes[]{new IdAndSizes("Nexus 7", "flo", 640, 480)};
        private static final String[] s_COLORSPACE_BUGGY_DEVICE_LIST = new String[]{"SAMSUNG-SGH-I747", "ODROID-U2"};

        private BuggyDeviceHack() {
        }

        static void applyMinDimensions(VideoCapture.CaptureFormat format) {
            for (IdAndSizes buggyDevice : s_CAPTURESIZE_BUGGY_DEVICE_LIST) {
                if (!buggyDevice.mModel.contentEquals(Build.MODEL) || !buggyDevice.mDevice.contentEquals(Build.DEVICE)) continue;
                format.mWidth = buggyDevice.mMinWidth > format.mWidth ? buggyDevice.mMinWidth : format.mWidth;
                format.mHeight = buggyDevice.mMinHeight > format.mHeight ? buggyDevice.mMinHeight : format.mHeight;
            }
        }

        static int getImageFormat() {
            if (Build.VERSION.SDK_INT < 16) {
                return 17;
            }
            for (String buggyDevice : s_COLORSPACE_BUGGY_DEVICE_LIST) {
                if (!buggyDevice.contentEquals(Build.MODEL)) continue;
                return 17;
            }
            return 842094169;
        }

        private static class IdAndSizes {
            public final String mModel;
            public final String mDevice;
            public final int mMinWidth;
            public final int mMinHeight;

            IdAndSizes(String model, String device, int minWidth, int minHeight) {
                this.mModel = model;
                this.mDevice = device;
                this.mMinWidth = minWidth;
                this.mMinHeight = minHeight;
            }
        }
    }
}

