/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.media;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.opengl.GLES20;
import android.util.Log;
import android.view.WindowManager;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;

@JNINamespace(value="media")
public abstract class VideoCapture
implements Camera.PreviewCallback {
    protected Camera mCamera;
    protected CaptureFormat mCaptureFormat = null;
    protected ReentrantLock mPreviewBufferLock = new ReentrantLock();
    protected Context mContext = null;
    protected boolean mIsRunning = false;
    protected int mId;
    protected long mNativeVideoCaptureDeviceAndroid;
    protected int[] mGlTextures = null;
    protected SurfaceTexture mSurfaceTexture = null;
    protected static final int GL_TEXTURE_EXTERNAL_OES = 36197;
    protected int mCameraOrientation;
    protected int mCameraFacing;
    protected int mDeviceOrientation;
    private static final String TAG = "VideoCapture";

    VideoCapture(Context context, int id2, long nativeVideoCaptureDeviceAndroid) {
        this.mContext = context;
        this.mId = id2;
        this.mNativeVideoCaptureDeviceAndroid = nativeVideoCaptureDeviceAndroid;
    }

    @CalledByNative
    boolean allocate(int width, int height, int frameRate) {
        Log.d((String)TAG, (String)("allocate: requested (" + width + "x" + height + ")@" + frameRate + "fps"));
        try {
            this.mCamera = Camera.open((int)this.mId);
        }
        catch (RuntimeException ex) {
            Log.e((String)TAG, (String)("allocate: Camera.open: " + ex));
            return false;
        }
        Camera.CameraInfo cameraInfo = this.getCameraInfo(this.mId);
        if (cameraInfo == null) {
            this.mCamera.release();
            this.mCamera = null;
            return false;
        }
        this.mCameraOrientation = cameraInfo.orientation;
        this.mCameraFacing = cameraInfo.facing;
        this.mDeviceOrientation = this.getDeviceOrientation();
        Log.d((String)TAG, (String)("allocate: orientation dev=" + this.mDeviceOrientation + ", cam=" + this.mCameraOrientation + ", facing=" + this.mCameraFacing));
        Camera.Parameters parameters = VideoCapture.getCameraParameters(this.mCamera);
        if (parameters == null) {
            this.mCamera = null;
            return false;
        }
        List listFpsRange = parameters.getSupportedPreviewFpsRange();
        if (listFpsRange == null || listFpsRange.size() == 0) {
            Log.e((String)TAG, (String)"allocate: no fps range found");
            return false;
        }
        int frameRateInMs = frameRate * 1000;
        int[] fpsMinMax = (int[])listFpsRange.get(0);
        int newFrameRate = (fpsMinMax[0] + 999) / 1000;
        for (int[] fpsRange : listFpsRange) {
            if (fpsRange[0] > frameRateInMs || frameRateInMs > fpsRange[1]) continue;
            fpsMinMax = fpsRange;
            newFrameRate = frameRate;
            break;
        }
        frameRate = newFrameRate;
        Log.d((String)TAG, (String)("allocate: fps set to " + frameRate));
        List listCameraSize = parameters.getSupportedPreviewSizes();
        int minDiff = Integer.MAX_VALUE;
        int matchedWidth = width;
        int matchedHeight = height;
        for (Camera.Size size : listCameraSize) {
            int diff = Math.abs(size.width - width) + Math.abs(size.height - height);
            Log.d((String)TAG, (String)("allocate: supported (" + size.width + ", " + size.height + "), diff=" + diff));
            if (diff >= minDiff || size.width % 32 != 0) continue;
            minDiff = diff;
            matchedWidth = size.width;
            matchedHeight = size.height;
        }
        if (minDiff == Integer.MAX_VALUE) {
            Log.e((String)TAG, (String)"allocate: can not find a multiple-of-32 resolution");
            return false;
        }
        Log.d((String)TAG, (String)("allocate: matched (" + matchedWidth + "x" + matchedHeight + ")"));
        if (parameters.isVideoStabilizationSupported()) {
            Log.d((String)TAG, (String)("Image stabilization supported, currently: " + parameters.getVideoStabilization() + ", setting it."));
            parameters.setVideoStabilization(true);
        } else {
            Log.d((String)TAG, (String)"Image stabilization not supported.");
        }
        this.setCaptureParameters(matchedWidth, matchedHeight, frameRate, parameters);
        parameters.setPreviewSize(this.mCaptureFormat.mWidth, this.mCaptureFormat.mHeight);
        parameters.setPreviewFpsRange(fpsMinMax[0], fpsMinMax[1]);
        parameters.setPreviewFormat(this.mCaptureFormat.mPixelFormat);
        this.mCamera.setParameters(parameters);
        this.mGlTextures = new int[1];
        GLES20.glGenTextures((int)1, (int[])this.mGlTextures, (int)0);
        GLES20.glBindTexture((int)36197, (int)this.mGlTextures[0]);
        GLES20.glTexParameterf((int)36197, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)36197, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        this.mSurfaceTexture = new SurfaceTexture(this.mGlTextures[0]);
        this.mSurfaceTexture.setOnFrameAvailableListener(null);
        try {
            this.mCamera.setPreviewTexture(this.mSurfaceTexture);
        }
        catch (IOException ex) {
            Log.e((String)TAG, (String)("allocate: " + ex));
            return false;
        }
        this.allocateBuffers();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public int startCapture() {
        if (this.mCamera == null) {
            Log.e((String)TAG, (String)"startCapture: camera is null");
            return -1;
        }
        this.mPreviewBufferLock.lock();
        try {
            if (this.mIsRunning) {
                int n = 0;
                return n;
            }
            this.mIsRunning = true;
        }
        finally {
            this.mPreviewBufferLock.unlock();
        }
        this.setPreviewCallback(this);
        try {
            this.mCamera.startPreview();
        }
        catch (RuntimeException ex) {
            Log.e((String)TAG, (String)("startCapture: Camera.startPreview: " + ex));
            return -1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public int stopCapture() {
        if (this.mCamera == null) {
            Log.e((String)TAG, (String)"stopCapture: camera is null");
            return 0;
        }
        this.mPreviewBufferLock.lock();
        try {
            if (!this.mIsRunning) {
                int n = 0;
                return n;
            }
            this.mIsRunning = false;
        }
        finally {
            this.mPreviewBufferLock.unlock();
        }
        this.mCamera.stopPreview();
        this.setPreviewCallback(null);
        return 0;
    }

    @CalledByNative
    public void deallocate() {
        if (this.mCamera == null) {
            return;
        }
        this.stopCapture();
        try {
            this.mCamera.setPreviewTexture(null);
            if (this.mGlTextures != null) {
                GLES20.glDeleteTextures((int)1, (int[])this.mGlTextures, (int)0);
            }
            this.mCaptureFormat = null;
            this.mCamera.release();
            this.mCamera = null;
        }
        catch (IOException ex) {
            Log.e((String)TAG, (String)("deallocate: failed to deallocate camera, " + ex));
            return;
        }
    }

    abstract void setCaptureParameters(int var1, int var2, int var3, Camera.Parameters var4);

    abstract void allocateBuffers();

    abstract void setPreviewCallback(Camera.PreviewCallback var1);

    @CalledByNative
    public int queryWidth() {
        return this.mCaptureFormat.mWidth;
    }

    @CalledByNative
    public int queryHeight() {
        return this.mCaptureFormat.mHeight;
    }

    @CalledByNative
    public int queryFrameRate() {
        return this.mCaptureFormat.mFramerate;
    }

    @CalledByNative
    public int getColorspace() {
        switch (this.mCaptureFormat.mPixelFormat) {
            case 842094169: {
                return 842094169;
            }
            case 17: {
                return 17;
            }
        }
        return 0;
    }

    protected int getDeviceOrientation() {
        int orientation = 0;
        if (this.mContext != null) {
            WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
            switch (wm.getDefaultDisplay().getRotation()) {
                case 1: {
                    orientation = 90;
                    break;
                }
                case 2: {
                    orientation = 180;
                    break;
                }
                case 3: {
                    orientation = 270;
                    break;
                }
                default: {
                    orientation = 0;
                }
            }
        }
        return orientation;
    }

    public native void nativeOnFrameAvailable(long var1, byte[] var3, int var4, int var5);

    protected static Camera.Parameters getCameraParameters(Camera camera) {
        Camera.Parameters parameters;
        try {
            parameters = camera.getParameters();
        }
        catch (RuntimeException ex) {
            Log.e((String)TAG, (String)("getCameraParameters: Camera.getParameters: " + ex));
            camera.release();
            return null;
        }
        return parameters;
    }

    private Camera.CameraInfo getCameraInfo(int id2) {
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        try {
            Camera.getCameraInfo((int)id2, (Camera.CameraInfo)cameraInfo);
        }
        catch (RuntimeException ex) {
            Log.e((String)TAG, (String)("getCameraInfo: Camera.getCameraInfo: " + ex));
            return null;
        }
        return cameraInfo;
    }

    protected static class CaptureFormat {
        int mWidth;
        int mHeight;
        final int mFramerate;
        final int mPixelFormat;

        public CaptureFormat(int width, int height, int framerate, int pixelformat) {
            this.mWidth = width;
            this.mHeight = height;
            this.mFramerate = framerate;
            this.mPixelFormat = pixelformat;
        }

        public int getWidth() {
            return this.mWidth;
        }

        public int getHeight() {
            return this.mHeight;
        }

        public int getFramerate() {
            return this.mFramerate;
        }

        public int getPixelFormat() {
            return this.mPixelFormat;
        }
    }
}

