/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.media;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.media.UsbMidiDeviceAndroid;

@JNINamespace(value="media")
class UsbMidiDeviceFactoryAndroid {
    private UsbManager mUsbManager;
    private BroadcastReceiver mReceiver;
    private final List<UsbMidiDeviceAndroid> mDevices = new ArrayList<UsbMidiDeviceAndroid>();
    private Set<UsbDevice> mRequestedDevices;
    private long mNativePointer;
    private static final String ACTION_USB_PERMISSION = "org.chromium.media.USB_PERMISSION";

    UsbMidiDeviceFactoryAndroid(long nativePointer) {
        this.mNativePointer = nativePointer;
    }

    @CalledByNative
    static UsbMidiDeviceFactoryAndroid create(long nativePointer) {
        return new UsbMidiDeviceFactoryAndroid(nativePointer);
    }

    @CalledByNative
    boolean enumerateDevices(Context context) {
        this.mUsbManager = (UsbManager)context.getSystemService("usb");
        HashMap devices = this.mUsbManager.getDeviceList();
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent(ACTION_USB_PERMISSION), (int)0);
        this.mRequestedDevices = new HashSet<UsbDevice>();
        for (UsbDevice device : devices.values()) {
            boolean found = false;
            for (int i = 0; i < device.getInterfaceCount() && !found; ++i) {
                UsbInterface iface = device.getInterface(i);
                if (iface.getInterfaceClass() != 1 || iface.getInterfaceSubclass() != 3) continue;
                found = true;
            }
            if (!found) continue;
            this.mUsbManager.requestPermission(device, pendingIntent);
            this.mRequestedDevices.add(device);
        }
        if (this.mRequestedDevices.isEmpty()) {
            return false;
        }
        IntentFilter filter = new IntentFilter(ACTION_USB_PERMISSION);
        this.mReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (UsbMidiDeviceFactoryAndroid.ACTION_USB_PERMISSION.equals(intent.getAction())) {
                    UsbMidiDeviceFactoryAndroid.this.onRequestDone(context, intent);
                }
            }
        };
        context.registerReceiver(this.mReceiver, filter);
        return true;
    }

    private void onRequestDone(Context context, Intent intent) {
        UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
        if (!this.mRequestedDevices.contains(device)) {
            return;
        }
        this.mRequestedDevices.remove(device);
        if (!intent.getBooleanExtra("permission", false)) {
            device = null;
        }
        if (device != null) {
            this.mDevices.add(new UsbMidiDeviceAndroid(this.mUsbManager, device));
        }
        if (this.mRequestedDevices.isEmpty()) {
            context.unregisterReceiver(this.mReceiver);
            if (this.mNativePointer != 0L) {
                UsbMidiDeviceFactoryAndroid.nativeOnUsbMidiDeviceRequestDone(this.mNativePointer, this.mDevices.toArray());
            }
        }
    }

    @CalledByNative
    void close() {
        this.mNativePointer = 0L;
    }

    private static native void nativeOnUsbMidiDeviceRequestDone(long var0, Object[] var2);
}

