/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.media;

import android.media.AudioTrack;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaCrypto;
import android.media.MediaFormat;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.Surface;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;

@JNINamespace(value="media")
class MediaCodecBridge {
    private static final String TAG = "MediaCodecBridge";
    private static final int MEDIA_CODEC_OK = 0;
    private static final int MEDIA_CODEC_DEQUEUE_INPUT_AGAIN_LATER = 1;
    private static final int MEDIA_CODEC_DEQUEUE_OUTPUT_AGAIN_LATER = 2;
    private static final int MEDIA_CODEC_OUTPUT_BUFFERS_CHANGED = 3;
    private static final int MEDIA_CODEC_OUTPUT_FORMAT_CHANGED = 4;
    private static final int MEDIA_CODEC_INPUT_END_OF_STREAM = 5;
    private static final int MEDIA_CODEC_OUTPUT_END_OF_STREAM = 6;
    private static final int MEDIA_CODEC_NO_KEY = 7;
    private static final int MEDIA_CODEC_STOPPED = 8;
    private static final int MEDIA_CODEC_ERROR = 9;
    private static final int MEDIA_CODEC_DECODER = 0;
    private static final int MEDIA_CODEC_ENCODER = 1;
    private static final int MAX_ADAPTIVE_PLAYBACK_WIDTH = 1920;
    private static final int MAX_ADAPTIVE_PLAYBACK_HEIGHT = 1080;
    private static final long MAX_PRESENTATION_TIMESTAMP_SHIFT_US = 100000L;
    private ByteBuffer[] mInputBuffers;
    private ByteBuffer[] mOutputBuffers;
    private MediaCodec mMediaCodec;
    private AudioTrack mAudioTrack;
    private boolean mFlushed;
    private long mLastPresentationTimeUs;
    private String mMime;
    private boolean mAdaptivePlaybackSupported;

    @CalledByNative
    private static CodecInfo[] getCodecsInfo() {
        HashMap<String, CodecInfo> encoderInfoMap = new HashMap<String, CodecInfo>();
        HashMap decoderInfoMap = new HashMap();
        int count = MediaCodecList.getCodecCount();
        for (int i = 0; i < count; ++i) {
            MediaCodecInfo info = MediaCodecList.getCodecInfoAt((int)i);
            int direction = info.isEncoder() ? 1 : 0;
            String codecString = info.getName();
            String[] supportedTypes = info.getSupportedTypes();
            for (int j = 0; j < supportedTypes.length; ++j) {
                HashMap<String, CodecInfo> map;
                HashMap<String, CodecInfo> hashMap = map = info.isEncoder() ? encoderInfoMap : decoderInfoMap;
                if (map.containsKey(supportedTypes[j])) continue;
                map.put(supportedTypes[j], new CodecInfo(supportedTypes[j], codecString, direction));
            }
        }
        ArrayList codecInfos = new ArrayList(decoderInfoMap.size() + encoderInfoMap.size());
        codecInfos.addAll(encoderInfoMap.values());
        codecInfos.addAll(decoderInfoMap.values());
        return codecInfos.toArray(new CodecInfo[codecInfos.size()]);
    }

    private static String getDecoderNameForMime(String mime) {
        int count = MediaCodecList.getCodecCount();
        for (int i = 0; i < count; ++i) {
            MediaCodecInfo info = MediaCodecList.getCodecInfoAt((int)i);
            if (info.isEncoder()) continue;
            String[] supportedTypes = info.getSupportedTypes();
            for (int j = 0; j < supportedTypes.length; ++j) {
                if (!supportedTypes[j].equalsIgnoreCase(mime)) continue;
                return info.getName();
            }
        }
        return null;
    }

    private MediaCodecBridge(MediaCodec mediaCodec, String mime, boolean adaptivePlaybackSupported) {
        assert (mediaCodec != null);
        this.mMediaCodec = mediaCodec;
        this.mMime = mime;
        this.mLastPresentationTimeUs = 0L;
        this.mFlushed = true;
        this.mAdaptivePlaybackSupported = adaptivePlaybackSupported;
    }

    @CalledByNative
    private static MediaCodecBridge create(String mime, boolean isSecure, int direction) {
        if (isSecure && Build.VERSION.SDK_INT < 18) {
            return null;
        }
        MediaCodec mediaCodec = null;
        boolean adaptivePlaybackSupported = false;
        try {
            if (mime.startsWith("video") && isSecure && direction == 0) {
                String decoderName = MediaCodecBridge.getDecoderNameForMime(mime);
                if (decoderName == null) {
                    return null;
                }
                if (Build.VERSION.SDK_INT >= 19) {
                    MediaCodec insecureCodec = MediaCodec.createByCodecName((String)decoderName);
                    adaptivePlaybackSupported = MediaCodecBridge.codecSupportsAdaptivePlayback(insecureCodec, mime);
                    insecureCodec.release();
                }
                mediaCodec = MediaCodec.createByCodecName((String)(decoderName + ".secure"));
            } else if (direction == 1) {
                mediaCodec = MediaCodec.createEncoderByType((String)mime);
            } else {
                mediaCodec = MediaCodec.createDecoderByType((String)mime);
                adaptivePlaybackSupported = MediaCodecBridge.codecSupportsAdaptivePlayback(mediaCodec, mime);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Failed to create MediaCodec: " + mime + ", isSecure: " + isSecure + ", direction: " + direction), (Throwable)e);
        }
        if (mediaCodec == null) {
            return null;
        }
        return new MediaCodecBridge(mediaCodec, mime, adaptivePlaybackSupported);
    }

    @CalledByNative
    private void release() {
        try {
            this.mMediaCodec.release();
        }
        catch (IllegalStateException e) {
            Log.e((String)TAG, (String)"Cannot release media codec", (Throwable)e);
        }
        this.mMediaCodec = null;
        if (this.mAudioTrack != null) {
            this.mAudioTrack.release();
        }
    }

    @CalledByNative
    private boolean start() {
        try {
            this.mMediaCodec.start();
            this.mInputBuffers = this.mMediaCodec.getInputBuffers();
        }
        catch (IllegalStateException e) {
            Log.e((String)TAG, (String)"Cannot start the media codec", (Throwable)e);
            return false;
        }
        return true;
    }

    @CalledByNative
    private DequeueInputResult dequeueInputBuffer(long timeoutUs) {
        int status = 9;
        int index = -1;
        try {
            int indexOrStatus = this.mMediaCodec.dequeueInputBuffer(timeoutUs);
            if (indexOrStatus >= 0) {
                status = 0;
                index = indexOrStatus;
            } else if (indexOrStatus == -1) {
                Log.e((String)TAG, (String)"dequeueInputBuffer: MediaCodec.INFO_TRY_AGAIN_LATER");
                status = 1;
            } else {
                Log.e((String)TAG, (String)("Unexpected index_or_status: " + indexOrStatus));
                assert (false);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Failed to dequeue input buffer", (Throwable)e);
        }
        return new DequeueInputResult(status, index);
    }

    @CalledByNative
    private int flush() {
        try {
            this.mFlushed = true;
            if (this.mAudioTrack != null) {
                this.mAudioTrack.pause();
                this.mAudioTrack.flush();
            }
            this.mMediaCodec.flush();
        }
        catch (IllegalStateException e) {
            Log.e((String)TAG, (String)"Failed to flush MediaCodec", (Throwable)e);
            return 9;
        }
        return 0;
    }

    @CalledByNative
    private void stop() {
        this.mMediaCodec.stop();
        if (this.mAudioTrack != null) {
            this.mAudioTrack.pause();
        }
    }

    @CalledByNative
    private int getOutputHeight() {
        return this.mMediaCodec.getOutputFormat().getInteger("height");
    }

    @CalledByNative
    private int getOutputWidth() {
        return this.mMediaCodec.getOutputFormat().getInteger("width");
    }

    @CalledByNative
    private ByteBuffer getInputBuffer(int index) {
        return this.mInputBuffers[index];
    }

    @CalledByNative
    private ByteBuffer getOutputBuffer(int index) {
        return this.mOutputBuffers[index];
    }

    @CalledByNative
    private int getInputBuffersCount() {
        return this.mInputBuffers.length;
    }

    @CalledByNative
    private int getOutputBuffersCount() {
        return this.mOutputBuffers != null ? this.mOutputBuffers.length : -1;
    }

    @CalledByNative
    private int getOutputBuffersCapacity() {
        return this.mOutputBuffers != null ? this.mOutputBuffers[0].capacity() : -1;
    }

    @CalledByNative
    private boolean getOutputBuffers() {
        try {
            this.mOutputBuffers = this.mMediaCodec.getOutputBuffers();
        }
        catch (IllegalStateException e) {
            Log.e((String)TAG, (String)"Cannot get output buffers", (Throwable)e);
            return false;
        }
        return true;
    }

    @CalledByNative
    private int queueInputBuffer(int index, int offset, int size, long presentationTimeUs, int flags) {
        this.resetLastPresentationTimeIfNeeded(presentationTimeUs);
        try {
            this.mMediaCodec.queueInputBuffer(index, offset, size, presentationTimeUs, flags);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Failed to queue input buffer", (Throwable)e);
            return 9;
        }
        return 0;
    }

    @CalledByNative
    private void setVideoBitrate(int bps) {
        Bundle b = new Bundle();
        b.putInt("video-bitrate", bps);
        this.mMediaCodec.setParameters(b);
    }

    @CalledByNative
    private void requestKeyFrameSoon() {
        Bundle b = new Bundle();
        b.putInt("request-sync", 0);
        this.mMediaCodec.setParameters(b);
    }

    @CalledByNative
    private int queueSecureInputBuffer(int index, int offset, byte[] iv, byte[] keyId, int[] numBytesOfClearData, int[] numBytesOfEncryptedData, int numSubSamples, long presentationTimeUs) {
        this.resetLastPresentationTimeIfNeeded(presentationTimeUs);
        try {
            MediaCodec.CryptoInfo cryptoInfo = new MediaCodec.CryptoInfo();
            cryptoInfo.set(numSubSamples, numBytesOfClearData, numBytesOfEncryptedData, keyId, iv, 1);
            this.mMediaCodec.queueSecureInputBuffer(index, offset, cryptoInfo, presentationTimeUs, 0);
        }
        catch (MediaCodec.CryptoException e) {
            Log.e((String)TAG, (String)"Failed to queue secure input buffer", (Throwable)e);
            if (e.getErrorCode() == 1) {
                Log.e((String)TAG, (String)"MediaCodec.CryptoException.ERROR_NO_KEY");
                return 7;
            }
            Log.e((String)TAG, (String)("MediaCodec.CryptoException with error code " + e.getErrorCode()));
            return 9;
        }
        catch (IllegalStateException e) {
            Log.e((String)TAG, (String)"Failed to queue secure input buffer", (Throwable)e);
            return 9;
        }
        return 0;
    }

    @CalledByNative
    private void releaseOutputBuffer(int index, boolean render) {
        try {
            this.mMediaCodec.releaseOutputBuffer(index, render);
        }
        catch (IllegalStateException e) {
            Log.e((String)TAG, (String)"Failed to release output buffer", (Throwable)e);
        }
    }

    @CalledByNative
    private DequeueOutputResult dequeueOutputBuffer(long timeoutUs) {
        MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
        int status = 9;
        int index = -1;
        try {
            int indexOrStatus = this.mMediaCodec.dequeueOutputBuffer(info, timeoutUs);
            if (info.presentationTimeUs < this.mLastPresentationTimeUs) {
                info.presentationTimeUs = this.mLastPresentationTimeUs;
            }
            this.mLastPresentationTimeUs = info.presentationTimeUs;
            if (indexOrStatus >= 0) {
                status = 0;
                index = indexOrStatus;
            } else if (indexOrStatus == -3) {
                status = 3;
            } else if (indexOrStatus == -2) {
                status = 4;
            } else if (indexOrStatus == -1) {
                status = 2;
            } else {
                Log.e((String)TAG, (String)("Unexpected index_or_status: " + indexOrStatus));
                assert (false);
            }
        }
        catch (IllegalStateException e) {
            Log.e((String)TAG, (String)"Failed to dequeue output buffer", (Throwable)e);
        }
        return new DequeueOutputResult(status, index, info.flags, info.offset, info.presentationTimeUs, info.size);
    }

    @CalledByNative
    private boolean configureVideo(MediaFormat format, Surface surface, MediaCrypto crypto, int flags) {
        try {
            if (this.mAdaptivePlaybackSupported) {
                format.setInteger("max-width", 1920);
                format.setInteger("max-height", 1080);
            }
            this.mMediaCodec.configure(format, surface, crypto, flags);
            return true;
        }
        catch (IllegalStateException e) {
            Log.e((String)TAG, (String)"Cannot configure the video codec", (Throwable)e);
            return false;
        }
    }

    @CalledByNative
    private static MediaFormat createAudioFormat(String mime, int sampleRate, int channelCount) {
        return MediaFormat.createAudioFormat((String)mime, (int)sampleRate, (int)channelCount);
    }

    @CalledByNative
    private static MediaFormat createVideoDecoderFormat(String mime, int width, int height) {
        return MediaFormat.createVideoFormat((String)mime, (int)width, (int)height);
    }

    @CalledByNative
    private static MediaFormat createVideoEncoderFormat(String mime, int width, int height, int bitRate, int frameRate, int iFrameInterval, int colorFormat) {
        MediaFormat format = MediaFormat.createVideoFormat((String)mime, (int)width, (int)height);
        format.setInteger("bitrate", bitRate);
        format.setInteger("frame-rate", frameRate);
        format.setInteger("i-frame-interval", iFrameInterval);
        format.setInteger("color-format", colorFormat);
        return format;
    }

    @CalledByNative
    private boolean isAdaptivePlaybackSupported(int width, int height) {
        if (!this.mAdaptivePlaybackSupported) {
            return false;
        }
        return width <= 1920 && height <= 1080;
    }

    private static boolean codecSupportsAdaptivePlayback(MediaCodec mediaCodec, String mime) {
        if (Build.VERSION.SDK_INT < 19 || mediaCodec == null) {
            return false;
        }
        try {
            MediaCodecInfo info = mediaCodec.getCodecInfo();
            if (info.isEncoder()) {
                return false;
            }
            MediaCodecInfo.CodecCapabilities capabilities = info.getCapabilitiesForType(mime);
            return capabilities != null && capabilities.isFeatureSupported("adaptive-playback");
        }
        catch (IllegalArgumentException e) {
            Log.e((String)TAG, (String)"Cannot retrieve codec information", (Throwable)e);
            return false;
        }
    }

    @CalledByNative
    private static void setCodecSpecificData(MediaFormat format, int index, byte[] bytes) {
        String name = null;
        if (index == 0) {
            name = "csd-0";
        } else if (index == 1) {
            name = "csd-1";
        }
        if (name != null) {
            format.setByteBuffer(name, ByteBuffer.wrap(bytes));
        }
    }

    @CalledByNative
    private static void setFrameHasADTSHeader(MediaFormat format) {
        format.setInteger("is-adts", 1);
    }

    @CalledByNative
    private boolean configureAudio(MediaFormat format, MediaCrypto crypto, int flags, boolean playAudio) {
        try {
            this.mMediaCodec.configure(format, null, crypto, flags);
            if (playAudio) {
                int sampleRate = format.getInteger("sample-rate");
                int channelCount = format.getInteger("channel-count");
                int channelConfig = this.getAudioFormat(channelCount);
                int minBufferSize = AudioTrack.getMinBufferSize((int)sampleRate, (int)channelConfig, (int)2);
                this.mAudioTrack = new AudioTrack(3, sampleRate, channelConfig, 2, minBufferSize, 1);
                if (this.mAudioTrack.getState() == 0) {
                    this.mAudioTrack = null;
                    return false;
                }
            }
            return true;
        }
        catch (IllegalStateException e) {
            Log.e((String)TAG, (String)"Cannot configure the audio codec", (Throwable)e);
            return false;
        }
    }

    @CalledByNative
    private long playOutputBuffer(byte[] buf) {
        int size;
        if (this.mAudioTrack == null) {
            return 0L;
        }
        if (3 != this.mAudioTrack.getPlayState()) {
            this.mAudioTrack.play();
        }
        if (buf.length != (size = this.mAudioTrack.write(buf, 0, buf.length))) {
            Log.i((String)TAG, (String)("Failed to send all data to audio output, expected size: " + buf.length + ", actual size: " + size));
        }
        return this.mAudioTrack.getPlaybackHeadPosition();
    }

    @CalledByNative
    private void setVolume(double volume) {
        if (this.mAudioTrack != null) {
            this.mAudioTrack.setStereoVolume((float)volume, (float)volume);
        }
    }

    private void resetLastPresentationTimeIfNeeded(long presentationTimeUs) {
        if (this.mFlushed) {
            this.mLastPresentationTimeUs = Math.max(presentationTimeUs - 100000L, 0L);
            this.mFlushed = false;
        }
    }

    private int getAudioFormat(int channelCount) {
        switch (channelCount) {
            case 1: {
                return 4;
            }
            case 2: {
                return 12;
            }
            case 4: {
                return 204;
            }
            case 6: {
                return 252;
            }
            case 8: {
                return 1020;
            }
        }
        return 1;
    }

    private static class DequeueOutputResult {
        private final int mStatus;
        private final int mIndex;
        private final int mFlags;
        private final int mOffset;
        private final long mPresentationTimeMicroseconds;
        private final int mNumBytes;

        private DequeueOutputResult(int status, int index, int flags, int offset, long presentationTimeMicroseconds, int numBytes) {
            this.mStatus = status;
            this.mIndex = index;
            this.mFlags = flags;
            this.mOffset = offset;
            this.mPresentationTimeMicroseconds = presentationTimeMicroseconds;
            this.mNumBytes = numBytes;
        }

        @CalledByNative(value="DequeueOutputResult")
        private int status() {
            return this.mStatus;
        }

        @CalledByNative(value="DequeueOutputResult")
        private int index() {
            return this.mIndex;
        }

        @CalledByNative(value="DequeueOutputResult")
        private int flags() {
            return this.mFlags;
        }

        @CalledByNative(value="DequeueOutputResult")
        private int offset() {
            return this.mOffset;
        }

        @CalledByNative(value="DequeueOutputResult")
        private long presentationTimeMicroseconds() {
            return this.mPresentationTimeMicroseconds;
        }

        @CalledByNative(value="DequeueOutputResult")
        private int numBytes() {
            return this.mNumBytes;
        }
    }

    private static class CodecInfo {
        private final String mCodecType;
        private final String mCodecName;
        private final int mDirection;

        private CodecInfo(String codecType, String codecName, int direction) {
            this.mCodecType = codecType;
            this.mCodecName = codecName;
            this.mDirection = direction;
        }

        @CalledByNative(value="CodecInfo")
        private String codecType() {
            return this.mCodecType;
        }

        @CalledByNative(value="CodecInfo")
        private String codecName() {
            return this.mCodecName;
        }

        @CalledByNative(value="CodecInfo")
        private int direction() {
            return this.mDirection;
        }
    }

    private static class DequeueInputResult {
        private final int mStatus;
        private final int mIndex;

        private DequeueInputResult(int status, int index) {
            this.mStatus = status;
            this.mIndex = index;
        }

        @CalledByNative(value="DequeueInputResult")
        private int status() {
            return this.mStatus;
        }

        @CalledByNative(value="DequeueInputResult")
        private int index() {
            return this.mIndex;
        }
    }
}

