/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.media;

import android.annotation.SuppressLint;
import android.media.AudioRecord;
import android.media.audiofx.AcousticEchoCanceler;
import android.os.Process;
import android.util.Log;
import java.nio.ByteBuffer;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;

@JNINamespace(value="media")
class AudioRecordInput {
    private static final String TAG = "AudioRecordInput";
    private static final boolean DEBUG = false;
    private static final int HARDWARE_DELAY_MS = 100;
    private final long mNativeAudioRecordInputStream;
    private final int mSampleRate;
    private final int mChannels;
    private final int mBitsPerSample;
    private final int mHardwareDelayBytes;
    private final boolean mUsePlatformAEC;
    private ByteBuffer mBuffer;
    private AudioRecord mAudioRecord;
    private AudioRecordThread mAudioRecordThread;
    private AcousticEchoCanceler mAEC;

    @CalledByNative
    private static AudioRecordInput createAudioRecordInput(long nativeAudioRecordInputStream, int sampleRate, int channels, int bitsPerSample, int bytesPerBuffer, boolean usePlatformAEC) {
        return new AudioRecordInput(nativeAudioRecordInputStream, sampleRate, channels, bitsPerSample, bytesPerBuffer, usePlatformAEC);
    }

    private AudioRecordInput(long nativeAudioRecordInputStream, int sampleRate, int channels, int bitsPerSample, int bytesPerBuffer, boolean usePlatformAEC) {
        this.mNativeAudioRecordInputStream = nativeAudioRecordInputStream;
        this.mSampleRate = sampleRate;
        this.mChannels = channels;
        this.mBitsPerSample = bitsPerSample;
        this.mHardwareDelayBytes = 100 * sampleRate / 1000 * bitsPerSample / 8;
        this.mUsePlatformAEC = usePlatformAEC;
        this.mBuffer = ByteBuffer.allocateDirect(bytesPerBuffer);
        this.nativeCacheDirectBufferAddress(this.mNativeAudioRecordInputStream, this.mBuffer);
    }

    @SuppressLint(value={"NewApi"})
    @CalledByNative
    private boolean open() {
        int audioFormat;
        int channelConfig;
        if (this.mAudioRecord != null) {
            Log.e((String)TAG, (String)"open() called twice without a close()");
            return false;
        }
        if (this.mChannels == 1) {
            channelConfig = 16;
        } else if (this.mChannels == 2) {
            channelConfig = 12;
        } else {
            Log.e((String)TAG, (String)("Unsupported number of channels: " + this.mChannels));
            return false;
        }
        if (this.mBitsPerSample == 8) {
            audioFormat = 3;
        } else if (this.mBitsPerSample == 16) {
            audioFormat = 2;
        } else {
            Log.e((String)TAG, (String)("Unsupported bits per sample: " + this.mBitsPerSample));
            return false;
        }
        int minBufferSize = AudioRecord.getMinBufferSize((int)this.mSampleRate, (int)channelConfig, (int)audioFormat);
        if (minBufferSize < 0) {
            Log.e((String)TAG, (String)("getMinBufferSize error: " + minBufferSize));
            return false;
        }
        int audioRecordBufferSizeInBytes = Math.max(this.mBuffer.capacity(), minBufferSize);
        try {
            this.mAudioRecord = new AudioRecord(7, this.mSampleRate, channelConfig, audioFormat, audioRecordBufferSizeInBytes);
        }
        catch (IllegalArgumentException e) {
            Log.e((String)TAG, (String)"AudioRecord failed", (Throwable)e);
            return false;
        }
        if (AcousticEchoCanceler.isAvailable()) {
            this.mAEC = AcousticEchoCanceler.create((int)this.mAudioRecord.getAudioSessionId());
            if (this.mAEC == null) {
                Log.e((String)TAG, (String)"AcousticEchoCanceler.create failed");
                return false;
            }
            int ret = this.mAEC.setEnabled(this.mUsePlatformAEC);
            if (ret != 0) {
                Log.e((String)TAG, (String)("setEnabled error: " + ret));
                return false;
            }
        }
        return true;
    }

    @CalledByNative
    private void start() {
        if (this.mAudioRecord == null) {
            Log.e((String)TAG, (String)"start() called before open().");
            return;
        }
        if (this.mAudioRecordThread != null) {
            return;
        }
        this.mAudioRecordThread = new AudioRecordThread();
        this.mAudioRecordThread.start();
    }

    @CalledByNative
    private void stop() {
        if (this.mAudioRecordThread == null) {
            return;
        }
        this.mAudioRecordThread.joinRecordThread();
        this.mAudioRecordThread = null;
    }

    @SuppressLint(value={"NewApi"})
    @CalledByNative
    private void close() {
        if (this.mAudioRecordThread != null) {
            Log.e((String)TAG, (String)"close() called before stop().");
            return;
        }
        if (this.mAudioRecord == null) {
            return;
        }
        if (this.mAEC != null) {
            this.mAEC.release();
            this.mAEC = null;
        }
        this.mAudioRecord.release();
        this.mAudioRecord = null;
    }

    private native void nativeCacheDirectBufferAddress(long var1, ByteBuffer var3);

    private native void nativeOnData(long var1, int var3, int var4);

    private class AudioRecordThread
    extends Thread {
        private volatile boolean mKeepAlive = true;

        private AudioRecordThread() {
        }

        public void run() {
            Process.setThreadPriority((int)-19);
            try {
                AudioRecordInput.this.mAudioRecord.startRecording();
            }
            catch (IllegalStateException e) {
                Log.e((String)AudioRecordInput.TAG, (String)"startRecording failed", (Throwable)e);
                return;
            }
            while (this.mKeepAlive) {
                int bytesRead = AudioRecordInput.this.mAudioRecord.read(AudioRecordInput.this.mBuffer, AudioRecordInput.this.mBuffer.capacity());
                if (bytesRead > 0) {
                    AudioRecordInput.this.nativeOnData(AudioRecordInput.this.mNativeAudioRecordInputStream, bytesRead, AudioRecordInput.this.mHardwareDelayBytes);
                    continue;
                }
                Log.e((String)AudioRecordInput.TAG, (String)("read failed: " + bytesRead));
                if (bytesRead != -3) continue;
                this.mKeepAlive = false;
            }
            try {
                AudioRecordInput.this.mAudioRecord.stop();
            }
            catch (IllegalStateException e) {
                Log.e((String)AudioRecordInput.TAG, (String)"stop failed", (Throwable)e);
            }
        }

        public void joinRecordThread() {
            this.mKeepAlive = false;
            while (this.isAlive()) {
                try {
                    this.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

