/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.media;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothManager;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.media.AudioTrack;
import android.media.audiofx.AcousticEchoCanceler;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Process;
import android.provider.Settings;
import android.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;

@JNINamespace(value="media")
class AudioManagerAndroid {
    private static final String TAG = "AudioManagerAndroid";
    private static final boolean DEBUG = false;
    private static final String[] SUPPORTED_AEC_MODELS = new String[]{"GT-I9300", "GT-I9500", "GT-N7105", "Nexus 4", "Nexus 5", "Nexus 7", "SM-N9005", "SM-T310"};
    private static final int DEVICE_DEFAULT = -2;
    private static final int DEVICE_INVALID = -1;
    private static final int DEVICE_SPEAKERPHONE = 0;
    private static final int DEVICE_WIRED_HEADSET = 1;
    private static final int DEVICE_EARPIECE = 2;
    private static final int DEVICE_BLUETOOTH_HEADSET = 3;
    private static final int DEVICE_COUNT = 4;
    private static final String[] DEVICE_NAMES = new String[]{"Speakerphone", "Wired headset", "Headset earpiece", "Bluetooth headset"};
    private static final Integer[] VALID_DEVICES = new Integer[]{0, 1, 2, 3};
    private static final int STATE_BLUETOOTH_SCO_INVALID = -1;
    private static final int STATE_BLUETOOTH_SCO_OFF = 0;
    private static final int STATE_BLUETOOTH_SCO_ON = 1;
    private static final int STATE_BLUETOOTH_SCO_TURNING_ON = 2;
    private static final int STATE_BLUETOOTH_SCO_TURNING_OFF = 3;
    private static final int DEFAULT_SAMPLING_RATE = 44100;
    private static final int DEFAULT_FRAME_PER_BUFFER = 256;
    private final AudioManager mAudioManager;
    private final Context mContext;
    private final long mNativeAudioManagerAndroid;
    private boolean mHasModifyAudioSettingsPermission = false;
    private boolean mHasRecordAudioPermission = false;
    private boolean mHasBluetoothPermission = false;
    private int mSavedAudioMode = -2;
    private int mBluetoothScoState = -1;
    private boolean mIsInitialized = false;
    private boolean mSavedIsSpeakerphoneOn;
    private boolean mSavedIsMicrophoneMute;
    private int mRequestedAudioDevice = -1;
    private final NonThreadSafe mNonThreadSafe = new NonThreadSafe();
    private final Object mLock = new Object();
    private boolean[] mAudioDevices = new boolean[4];
    private final ContentResolver mContentResolver;
    private ContentObserver mSettingsObserver = null;
    private HandlerThread mSettingsObserverThread = null;
    private int mCurrentVolume;
    private BroadcastReceiver mWiredHeadsetReceiver;
    private BroadcastReceiver mBluetoothHeadsetReceiver;
    private BroadcastReceiver mBluetoothScoReceiver;

    private static boolean runningOnJellyBeanOrHigher() {
        return Build.VERSION.SDK_INT >= 16;
    }

    private static boolean runningOnJellyBeanMR1OrHigher() {
        return Build.VERSION.SDK_INT >= 17;
    }

    private static boolean runningOnJellyBeanMR2OrHigher() {
        return Build.VERSION.SDK_INT >= 18;
    }

    @CalledByNative
    private static AudioManagerAndroid createAudioManagerAndroid(Context context, long nativeAudioManagerAndroid) {
        return new AudioManagerAndroid(context, nativeAudioManagerAndroid);
    }

    private AudioManagerAndroid(Context context, long nativeAudioManagerAndroid) {
        this.mContext = context;
        this.mNativeAudioManagerAndroid = nativeAudioManagerAndroid;
        this.mAudioManager = (AudioManager)this.mContext.getSystemService("audio");
        this.mContentResolver = this.mContext.getContentResolver();
    }

    @CalledByNative
    private void init() {
        this.checkIfCalledOnValidThread();
        if (this.mIsInitialized) {
            return;
        }
        this.mHasModifyAudioSettingsPermission = this.hasPermission("android.permission.MODIFY_AUDIO_SETTINGS");
        this.mHasRecordAudioPermission = this.hasPermission("android.permission.RECORD_AUDIO");
        this.mAudioDevices[2] = this.hasEarpiece();
        this.mAudioDevices[1] = this.hasWiredHeadset();
        this.mAudioDevices[0] = true;
        this.registerBluetoothIntentsIfNeeded();
        this.registerForWiredHeadsetIntentBroadcast();
        this.mIsInitialized = true;
    }

    @CalledByNative
    private void close() {
        this.checkIfCalledOnValidThread();
        if (!this.mIsInitialized) {
            return;
        }
        this.stopObservingVolumeChanges();
        this.unregisterForWiredHeadsetIntentBroadcast();
        this.unregisterBluetoothIntentsIfNeeded();
        this.mIsInitialized = false;
    }

    @CalledByNative
    private void setCommunicationAudioModeOn(boolean on) {
        if (!this.mHasModifyAudioSettingsPermission) {
            Log.w((String)TAG, (String)"MODIFY_AUDIO_SETTINGS is missing => client will run with reduced functionality");
            return;
        }
        if (on) {
            if (this.mSavedAudioMode != -2) {
                throw new IllegalStateException("Audio mode has already been set");
            }
            try {
                this.mSavedAudioMode = this.mAudioManager.getMode();
            }
            catch (SecurityException e) {
                this.logDeviceInfo();
                throw e;
            }
            this.mSavedIsSpeakerphoneOn = this.mAudioManager.isSpeakerphoneOn();
            this.mSavedIsMicrophoneMute = this.mAudioManager.isMicrophoneMute();
            try {
                this.mAudioManager.setMode(3);
            }
            catch (SecurityException e) {
                this.logDeviceInfo();
                throw e;
            }
            this.startObservingVolumeChanges();
        } else {
            if (this.mSavedAudioMode == -2) {
                throw new IllegalStateException("Audio mode has not yet been set");
            }
            this.stopObservingVolumeChanges();
            this.setMicrophoneMute(this.mSavedIsMicrophoneMute);
            this.setSpeakerphoneOn(this.mSavedIsSpeakerphoneOn);
            try {
                this.mAudioManager.setMode(this.mSavedAudioMode);
            }
            catch (SecurityException e) {
                this.logDeviceInfo();
                throw e;
            }
            this.mSavedAudioMode = -2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private boolean setDevice(String deviceId) {
        int intDeviceId;
        if (!this.mIsInitialized) {
            return false;
        }
        if (!this.mHasModifyAudioSettingsPermission || !this.mHasRecordAudioPermission) {
            Log.w((String)TAG, (String)"Requires MODIFY_AUDIO_SETTINGS and RECORD_AUDIO");
            Log.w((String)TAG, (String)"Selected device will not be available for recording");
            return false;
        }
        int n = intDeviceId = deviceId.isEmpty() ? -2 : Integer.parseInt(deviceId);
        if (intDeviceId == -2) {
            boolean[] devices = null;
            Object object = this.mLock;
            synchronized (object) {
                devices = (boolean[])this.mAudioDevices.clone();
                this.mRequestedAudioDevice = -2;
            }
            int defaultDevice = AudioManagerAndroid.selectDefaultDevice(devices);
            this.setAudioDevice(defaultDevice);
            return true;
        }
        List<Integer> validIds = Arrays.asList(VALID_DEVICES);
        if (!validIds.contains(intDeviceId) || !this.mAudioDevices[intDeviceId]) {
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mRequestedAudioDevice = intDeviceId;
        }
        this.setAudioDevice(intDeviceId);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private AudioDeviceName[] getAudioInputDeviceNames() {
        if (!this.mIsInitialized) {
            return null;
        }
        if (!this.mHasModifyAudioSettingsPermission || !this.mHasRecordAudioPermission) {
            Log.w((String)TAG, (String)"Requires MODIFY_AUDIO_SETTINGS and RECORD_AUDIO");
            Log.w((String)TAG, (String)"No audio device will be available for recording");
            return null;
        }
        boolean[] devices = null;
        Object object = this.mLock;
        synchronized (object) {
            devices = (boolean[])this.mAudioDevices.clone();
        }
        ArrayList<String> list = new ArrayList<String>();
        AudioDeviceName[] array = new AudioDeviceName[AudioManagerAndroid.getNumOfAudioDevices(devices)];
        int i = 0;
        for (int id2 = 0; id2 < 4; ++id2) {
            if (!devices[id2]) continue;
            array[i] = new AudioDeviceName(id2, DEVICE_NAMES[id2]);
            list.add(DEVICE_NAMES[id2]);
            ++i;
        }
        return array;
    }

    @CalledByNative
    private int getNativeOutputSampleRate() {
        if (AudioManagerAndroid.runningOnJellyBeanMR1OrHigher()) {
            String sampleRateString = this.mAudioManager.getProperty("android.media.property.OUTPUT_SAMPLE_RATE");
            return sampleRateString == null ? 44100 : Integer.parseInt(sampleRateString);
        }
        return 44100;
    }

    @CalledByNative
    private static int getMinInputFrameSize(int sampleRate, int channels) {
        int channelConfig;
        if (channels == 1) {
            channelConfig = 16;
        } else if (channels == 2) {
            channelConfig = 12;
        } else {
            return -1;
        }
        return AudioRecord.getMinBufferSize((int)sampleRate, (int)channelConfig, (int)2) / 2 / channels;
    }

    @CalledByNative
    private static int getMinOutputFrameSize(int sampleRate, int channels) {
        int channelConfig;
        if (channels == 1) {
            channelConfig = 4;
        } else if (channels == 2) {
            channelConfig = 12;
        } else {
            return -1;
        }
        return AudioTrack.getMinBufferSize((int)sampleRate, (int)channelConfig, (int)2) / 2 / channels;
    }

    @CalledByNative
    private boolean isAudioLowLatencySupported() {
        return this.mContext.getPackageManager().hasSystemFeature("android.hardware.audio.low_latency");
    }

    @CalledByNative
    private int getAudioLowLatencyOutputFrameSize() {
        String framesPerBuffer = this.mAudioManager.getProperty("android.media.property.OUTPUT_FRAMES_PER_BUFFER");
        return framesPerBuffer == null ? 256 : Integer.parseInt(framesPerBuffer);
    }

    @CalledByNative
    private static boolean shouldUseAcousticEchoCanceler() {
        if (!AudioManagerAndroid.runningOnJellyBeanOrHigher()) {
            return false;
        }
        List<String> supportedModels = Arrays.asList(SUPPORTED_AEC_MODELS);
        if (!supportedModels.contains(Build.MODEL)) {
            return false;
        }
        return AcousticEchoCanceler.isAvailable();
    }

    private void checkIfCalledOnValidThread() {
    }

    private void registerBluetoothIntentsIfNeeded() {
        this.mHasBluetoothPermission = this.hasPermission("android.permission.BLUETOOTH");
        if (!this.mHasBluetoothPermission) {
            Log.w((String)TAG, (String)"Requires BLUETOOTH permission");
            return;
        }
        this.mAudioDevices[3] = this.hasBluetoothHeadset();
        this.registerForBluetoothHeadsetIntentBroadcast();
        this.registerForBluetoothScoIntentBroadcast();
    }

    private void unregisterBluetoothIntentsIfNeeded() {
        if (this.mHasBluetoothPermission) {
            this.mAudioManager.stopBluetoothSco();
            this.unregisterForBluetoothHeadsetIntentBroadcast();
            this.unregisterForBluetoothScoIntentBroadcast();
        }
    }

    private void setSpeakerphoneOn(boolean on) {
        boolean wasOn = this.mAudioManager.isSpeakerphoneOn();
        if (wasOn == on) {
            return;
        }
        this.mAudioManager.setSpeakerphoneOn(on);
    }

    private void setMicrophoneMute(boolean on) {
        boolean wasMuted = this.mAudioManager.isMicrophoneMute();
        if (wasMuted == on) {
            return;
        }
        this.mAudioManager.setMicrophoneMute(on);
    }

    private boolean isMicrophoneMute() {
        return this.mAudioManager.isMicrophoneMute();
    }

    private boolean hasEarpiece() {
        return this.mContext.getPackageManager().hasSystemFeature("android.hardware.telephony");
    }

    @Deprecated
    private boolean hasWiredHeadset() {
        return this.mAudioManager.isWiredHeadsetOn();
    }

    private boolean hasPermission(String permission) {
        return this.mContext.checkPermission(permission, Process.myPid(), Process.myUid()) == 0;
    }

    private boolean hasBluetoothHeadset() {
        if (!this.mHasBluetoothPermission) {
            Log.w((String)TAG, (String)"hasBluetoothHeadset() requires BLUETOOTH permission");
            return false;
        }
        BluetoothAdapter btAdapter = null;
        if (AudioManagerAndroid.runningOnJellyBeanMR2OrHigher()) {
            BluetoothManager btManager = (BluetoothManager)this.mContext.getSystemService("bluetooth");
            btAdapter = btManager.getAdapter();
        } else {
            btAdapter = BluetoothAdapter.getDefaultAdapter();
        }
        if (btAdapter == null) {
            return false;
        }
        int profileConnectionState = btAdapter.getProfileConnectionState(1);
        return btAdapter.isEnabled() && profileConnectionState == 2;
    }

    private void registerForWiredHeadsetIntentBroadcast() {
        IntentFilter filter = new IntentFilter("android.intent.action.HEADSET_PLUG");
        this.mWiredHeadsetReceiver = new BroadcastReceiver(){
            private static final int STATE_UNPLUGGED = 0;
            private static final int STATE_PLUGGED = 1;
            private static final int HAS_NO_MIC = 0;
            private static final int HAS_MIC = 1;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onReceive(Context context, Intent intent) {
                int state = intent.getIntExtra("state", 0);
                switch (state) {
                    case 0: {
                        Object object = AudioManagerAndroid.this.mLock;
                        synchronized (object) {
                            ((AudioManagerAndroid)AudioManagerAndroid.this).mAudioDevices[1] = false;
                            if (AudioManagerAndroid.this.hasEarpiece()) {
                                ((AudioManagerAndroid)AudioManagerAndroid.this).mAudioDevices[2] = true;
                            }
                            break;
                        }
                    }
                    case 1: {
                        Object object = AudioManagerAndroid.this.mLock;
                        synchronized (object) {
                            ((AudioManagerAndroid)AudioManagerAndroid.this).mAudioDevices[1] = true;
                            ((AudioManagerAndroid)AudioManagerAndroid.this).mAudioDevices[2] = false;
                            break;
                        }
                    }
                    default: {
                        AudioManagerAndroid.loge("Invalid state");
                    }
                }
                if (AudioManagerAndroid.this.deviceHasBeenRequested()) {
                    AudioManagerAndroid.this.updateDeviceActivation();
                }
            }
        };
        this.mContext.registerReceiver(this.mWiredHeadsetReceiver, filter);
    }

    private void unregisterForWiredHeadsetIntentBroadcast() {
        this.mContext.unregisterReceiver(this.mWiredHeadsetReceiver);
        this.mWiredHeadsetReceiver = null;
    }

    private void registerForBluetoothHeadsetIntentBroadcast() {
        IntentFilter filter = new IntentFilter("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED");
        this.mBluetoothHeadsetReceiver = new BroadcastReceiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onReceive(Context context, Intent intent) {
                int profileState = intent.getIntExtra("android.bluetooth.profile.extra.STATE", 0);
                switch (profileState) {
                    case 0: {
                        Object object = AudioManagerAndroid.this.mLock;
                        synchronized (object) {
                            ((AudioManagerAndroid)AudioManagerAndroid.this).mAudioDevices[3] = false;
                            break;
                        }
                    }
                    case 2: {
                        Object object = AudioManagerAndroid.this.mLock;
                        synchronized (object) {
                            ((AudioManagerAndroid)AudioManagerAndroid.this).mAudioDevices[3] = true;
                            break;
                        }
                    }
                    case 1: {
                        break;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        AudioManagerAndroid.loge("Invalid state");
                    }
                }
                if (AudioManagerAndroid.this.deviceHasBeenRequested()) {
                    AudioManagerAndroid.this.updateDeviceActivation();
                }
            }
        };
        this.mContext.registerReceiver(this.mBluetoothHeadsetReceiver, filter);
    }

    private void unregisterForBluetoothHeadsetIntentBroadcast() {
        this.mContext.unregisterReceiver(this.mBluetoothHeadsetReceiver);
        this.mBluetoothHeadsetReceiver = null;
    }

    private void registerForBluetoothScoIntentBroadcast() {
        IntentFilter filter = new IntentFilter("android.media.ACTION_SCO_AUDIO_STATE_UPDATED");
        this.mBluetoothScoReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                int state = intent.getIntExtra("android.media.extra.SCO_AUDIO_STATE", 0);
                switch (state) {
                    case 1: {
                        AudioManagerAndroid.this.mBluetoothScoState = 1;
                        break;
                    }
                    case 0: {
                        AudioManagerAndroid.this.mBluetoothScoState = 0;
                        break;
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        AudioManagerAndroid.loge("Invalid state");
                    }
                }
            }
        };
        this.mContext.registerReceiver(this.mBluetoothScoReceiver, filter);
    }

    private void unregisterForBluetoothScoIntentBroadcast() {
        this.mContext.unregisterReceiver(this.mBluetoothScoReceiver);
        this.mBluetoothScoReceiver = null;
    }

    private void startBluetoothSco() {
        if (!this.mHasBluetoothPermission) {
            return;
        }
        if (this.mBluetoothScoState == 1 || this.mBluetoothScoState == 2) {
            return;
        }
        if (this.mAudioManager.isBluetoothScoOn()) {
            this.mBluetoothScoState = 1;
            return;
        }
        this.mBluetoothScoState = 2;
        this.mAudioManager.startBluetoothSco();
    }

    private void stopBluetoothSco() {
        if (!this.mHasBluetoothPermission) {
            return;
        }
        if (this.mBluetoothScoState != 1 && this.mBluetoothScoState != 2) {
            return;
        }
        if (!this.mAudioManager.isBluetoothScoOn()) {
            AudioManagerAndroid.loge("Unable to stop BT SCO since it is already disabled");
            return;
        }
        this.mBluetoothScoState = 3;
        this.mAudioManager.stopBluetoothSco();
    }

    private void setAudioDevice(int device) {
        if (device == 3) {
            this.startBluetoothSco();
        } else {
            this.stopBluetoothSco();
        }
        switch (device) {
            case 3: {
                break;
            }
            case 0: {
                this.setSpeakerphoneOn(true);
                break;
            }
            case 1: {
                this.setSpeakerphoneOn(false);
                break;
            }
            case 2: {
                this.setSpeakerphoneOn(false);
                break;
            }
            default: {
                AudioManagerAndroid.loge("Invalid audio device selection");
            }
        }
        this.reportUpdate();
    }

    private static int selectDefaultDevice(boolean[] devices) {
        if (devices[1]) {
            return 1;
        }
        if (devices[3]) {
            return 3;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deviceHasBeenRequested() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mRequestedAudioDevice != -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDeviceActivation() {
        boolean[] devices = null;
        int requested = -1;
        Object object = this.mLock;
        synchronized (object) {
            requested = this.mRequestedAudioDevice;
            devices = (boolean[])this.mAudioDevices.clone();
        }
        if (requested == -1) {
            AudioManagerAndroid.loge("Unable to activate device since no device is selected");
            return;
        }
        if (requested == -2 || !devices[requested]) {
            int defaultDevice = AudioManagerAndroid.selectDefaultDevice(devices);
            this.setAudioDevice(defaultDevice);
        } else {
            this.setAudioDevice(requested);
        }
    }

    private static int getNumOfAudioDevices(boolean[] devices) {
        int count = 0;
        for (int i = 0; i < 4; ++i) {
            if (!devices[i]) continue;
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportUpdate() {
        Object object = this.mLock;
        synchronized (object) {
            ArrayList<String> devices = new ArrayList<String>();
            for (int i = 0; i < 4; ++i) {
                if (!this.mAudioDevices[i]) continue;
                devices.add(DEVICE_NAMES[i]);
            }
        }
    }

    private void logDeviceInfo() {
        AudioManagerAndroid.logd("Android SDK: " + Build.VERSION.SDK_INT + ", " + "Release: " + Build.VERSION.RELEASE + ", " + "Brand: " + Build.BRAND + ", " + "CPU_ABI: " + Build.CPU_ABI + ", " + "Device: " + Build.DEVICE + ", " + "Id: " + Build.ID + ", " + "Hardware: " + Build.HARDWARE + ", " + "Manufacturer: " + Build.MANUFACTURER + ", " + "Model: " + Build.MODEL + ", " + "Product: " + Build.PRODUCT);
    }

    private static void logd(String msg) {
        Log.d((String)TAG, (String)msg);
    }

    private static void loge(String msg) {
        Log.e((String)TAG, (String)msg);
    }

    private void startObservingVolumeChanges() {
        if (this.mSettingsObserverThread != null) {
            return;
        }
        this.mSettingsObserverThread = new HandlerThread("SettingsObserver");
        this.mSettingsObserverThread.start();
        this.mSettingsObserver = new ContentObserver(new Handler(this.mSettingsObserverThread.getLooper())){

            public void onChange(boolean selfChange) {
                super.onChange(selfChange);
                if (AudioManagerAndroid.this.mAudioManager.getMode() != 3) {
                    throw new IllegalStateException("Only enable SettingsObserver in COMM mode");
                }
                int volume = AudioManagerAndroid.this.mAudioManager.getStreamVolume(0);
                AudioManagerAndroid.this.nativeSetMute(AudioManagerAndroid.this.mNativeAudioManagerAndroid, volume == 0);
            }
        };
        this.mContentResolver.registerContentObserver(Settings.System.CONTENT_URI, true, this.mSettingsObserver);
    }

    private void stopObservingVolumeChanges() {
        if (this.mSettingsObserverThread == null) {
            return;
        }
        this.mContentResolver.unregisterContentObserver(this.mSettingsObserver);
        this.mSettingsObserver = null;
        this.mSettingsObserverThread.quit();
        try {
            this.mSettingsObserverThread.join();
        }
        catch (InterruptedException e) {
            Log.e((String)TAG, (String)"Thread.join() exception: ", (Throwable)e);
        }
        this.mSettingsObserverThread = null;
    }

    private native void nativeSetMute(long var1, boolean var3);

    private static class AudioDeviceName {
        private final int mId;
        private final String mName;

        private AudioDeviceName(int id2, String name) {
            this.mId = id2;
            this.mName = name;
        }

        @CalledByNative(value="AudioDeviceName")
        private String id() {
            return String.valueOf(this.mId);
        }

        @CalledByNative(value="AudioDeviceName")
        private String name() {
            return this.mName;
        }
    }

    private static class NonThreadSafe {
        private final Long mThreadId = 0L;

        public boolean calledOnValidThread() {
            return true;
        }
    }
}

