/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.webcontents;

import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.content_public.browser.NavigationController;
import org.chromium.content_public.browser.WebContents;

@JNINamespace(value="content")
class WebContentsImpl
implements WebContents {
    private long mNativeWebContentsAndroid;
    private NavigationController mNavigationController;

    private WebContentsImpl(long nativeWebContentsAndroid, NavigationController navigationController) {
        this.mNativeWebContentsAndroid = nativeWebContentsAndroid;
        this.mNavigationController = navigationController;
    }

    @CalledByNative
    private static WebContentsImpl create(long nativeWebContentsAndroid, NavigationController navigationController) {
        return new WebContentsImpl(nativeWebContentsAndroid, navigationController);
    }

    @CalledByNative
    private void destroy() {
        this.mNativeWebContentsAndroid = 0L;
        this.mNavigationController = null;
    }

    @CalledByNative
    private long getNativePointer() {
        return this.mNativeWebContentsAndroid;
    }

    public NavigationController getNavigationController() {
        return this.mNavigationController;
    }

    public String getTitle() {
        return this.nativeGetTitle(this.mNativeWebContentsAndroid);
    }

    public String getVisibleUrl() {
        return this.nativeGetVisibleURL(this.mNativeWebContentsAndroid);
    }

    public void stop() {
        this.nativeStop(this.mNativeWebContentsAndroid);
    }

    private native String nativeGetTitle(long var1);

    private native String nativeGetVisibleURL(long var1);

    private native void nativeStop(long var1);
}

