/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.input;

import android.view.View;
import com.google.common.annotations.VisibleForTesting;
import org.chromium.content.browser.PositionObserver;
import org.chromium.content.browser.input.CursorController;
import org.chromium.content.browser.input.HandleView;

public abstract class SelectionHandleController
implements CursorController {
    private static final int TEXT_DIRECTION_DEFAULT = 0;
    private static final int TEXT_DIRECTION_LTR = 1;
    private static final int TEXT_DIRECTION_RTL = 2;
    private HandleView mStartHandle;
    private HandleView mEndHandle;
    private boolean mAllowAutomaticShowing = true;
    private boolean mIsShowing;
    private View mParent;
    private int mFixedHandleX;
    private int mFixedHandleY;
    private PositionObserver mPositionObserver;

    public SelectionHandleController(View parent, PositionObserver positionObserver) {
        this.mParent = parent;
        this.mPositionObserver = positionObserver;
    }

    public void allowAutomaticShowing() {
        this.mAllowAutomaticShowing = true;
    }

    public void hideAndDisallowAutomaticShowing() {
        this.hide();
        this.mAllowAutomaticShowing = false;
    }

    public boolean isShowing() {
        return this.mIsShowing;
    }

    public void hide() {
        if (this.mIsShowing) {
            if (this.mStartHandle != null) {
                this.mStartHandle.hide();
            }
            if (this.mEndHandle != null) {
                this.mEndHandle.hide();
            }
            this.mIsShowing = false;
        }
    }

    void cancelFadeOutAnimation() {
        this.hide();
    }

    public void updatePosition(HandleView handle, int x, int y) {
        this.selectBetweenCoordinates(this.mFixedHandleX, this.mFixedHandleY, x, y);
    }

    public void beforeStartUpdatingPosition(HandleView handle) {
        HandleView fixedHandle = handle == this.mStartHandle ? this.mEndHandle : this.mStartHandle;
        this.mFixedHandleX = fixedHandle.getAdjustedPositionX();
        this.mFixedHandleY = fixedHandle.getLineAdjustedPositionY();
    }

    protected abstract void selectBetweenCoordinates(int var1, int var2, int var3, int var4);

    boolean isSelectionStartDragged() {
        return this.mStartHandle != null && this.mStartHandle.isDragging();
    }

    public boolean isDragging() {
        return this.mStartHandle != null && this.mStartHandle.isDragging() || this.mEndHandle != null && this.mEndHandle.isDragging();
    }

    public void onTouchModeChanged(boolean isInTouchMode) {
        if (!isInTouchMode) {
            this.hide();
        }
    }

    public void onDetached() {
    }

    public void setStartHandlePosition(float x, float y) {
        this.mStartHandle.positionAt((int)x, (int)y);
    }

    public void setEndHandlePosition(float x, float y) {
        this.mEndHandle.positionAt((int)x, (int)y);
    }

    public void beginHandleFadeIn() {
        this.mStartHandle.beginFadeIn();
        this.mEndHandle.beginFadeIn();
    }

    public void setHandleVisibility(int visibility) {
        this.mStartHandle.setVisibility(visibility);
        this.mEndHandle.setVisibility(visibility);
    }

    public void onSelectionChanged(int startDir, int endDir) {
        if (this.mAllowAutomaticShowing) {
            this.showHandles(startDir, endDir);
        }
    }

    public void showHandles(int startDir, int endDir) {
        this.createHandlesIfNeeded(startDir, endDir);
        this.showHandlesIfNeeded();
    }

    @VisibleForTesting
    public HandleView getStartHandleViewForTest() {
        return this.mStartHandle;
    }

    @VisibleForTesting
    public HandleView getEndHandleViewForTest() {
        return this.mEndHandle;
    }

    private void createHandlesIfNeeded(int startDir, int endDir) {
        if (this.mStartHandle == null) {
            this.mStartHandle = new HandleView(this, startDir == 2 ? 2 : 0, this.mParent, this.mPositionObserver);
        }
        if (this.mEndHandle == null) {
            this.mEndHandle = new HandleView(this, endDir == 2 ? 0 : 2, this.mParent, this.mPositionObserver);
        }
    }

    private void showHandlesIfNeeded() {
        if (!this.mIsShowing) {
            this.mIsShowing = true;
            this.mStartHandle.show();
            this.mEndHandle.show();
            this.setHandleVisibility(0);
        }
    }
}

