/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.input;

import android.content.Context;
import android.graphics.Rect;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.PopupWindow;
import java.util.List;
import org.chromium.content.browser.ContentViewCore;
import org.chromium.content.browser.RenderCoordinates;
import org.chromium.content.browser.input.SelectPopup;
import org.chromium.content.browser.input.SelectPopupItem;
import org.chromium.ui.DropdownAdapter;
import org.chromium.ui.DropdownItem;
import org.chromium.ui.DropdownPopupWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectPopupDropdown
implements SelectPopup {
    private final ContentViewCore mContentViewCore;
    private final Context mContext;
    private DropdownPopupWindow mDropdownPopupWindow;
    private int mInitialSelection = -1;
    private boolean mAlreadySelectedItems = false;

    public SelectPopupDropdown(ContentViewCore contentViewCore, List<SelectPopupItem> items, Rect bounds, int[] selected) {
        this.mContentViewCore = contentViewCore;
        this.mContext = this.mContentViewCore.getContext();
        this.mDropdownPopupWindow = new DropdownPopupWindow(this.mContext, this.mContentViewCore.getViewAndroidDelegate());
        this.mDropdownPopupWindow.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                int[] selectedIndices = new int[]{position};
                SelectPopupDropdown.this.mContentViewCore.selectPopupMenuItems(selectedIndices);
                SelectPopupDropdown.this.mAlreadySelectedItems = true;
                SelectPopupDropdown.this.hide();
            }
        });
        if (selected.length > 0) {
            this.mInitialSelection = selected[0];
        }
        DropdownItem[] dropdownItems = items.toArray(new DropdownItem[items.size()]);
        this.mDropdownPopupWindow.setAdapter((ListAdapter)new DropdownAdapter(this.mContext, dropdownItems, null));
        RenderCoordinates renderCoordinates = this.mContentViewCore.getRenderCoordinates();
        float anchorX = renderCoordinates.fromPixToDip(renderCoordinates.fromLocalCssToPix(bounds.left));
        float anchorY = renderCoordinates.fromPixToDip(renderCoordinates.fromLocalCssToPix(bounds.top));
        float anchorWidth = renderCoordinates.fromPixToDip(renderCoordinates.fromLocalCssToPix(bounds.right)) - anchorX;
        float anchorHeight = renderCoordinates.fromPixToDip(renderCoordinates.fromLocalCssToPix(bounds.bottom)) - anchorY;
        this.mDropdownPopupWindow.setAnchorRect(anchorX, anchorY, anchorWidth, anchorHeight);
        this.mDropdownPopupWindow.setOnDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                if (!SelectPopupDropdown.this.mAlreadySelectedItems) {
                    SelectPopupDropdown.this.mContentViewCore.selectPopupMenuItems(null);
                }
            }
        });
    }

    @Override
    public void show() {
        this.mDropdownPopupWindow.show();
        if (this.mInitialSelection >= 0) {
            this.mDropdownPopupWindow.getListView().setSelection(this.mInitialSelection);
        }
    }

    @Override
    public void hide() {
        this.mDropdownPopupWindow.dismiss();
    }
}

