/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.input;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.CheckedTextView;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import org.chromium.content.browser.input.SelectPopupItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectPopupAdapter
extends ArrayAdapter<SelectPopupItem> {
    private List<SelectPopupItem> mItems;
    private boolean mAreAllItemsEnabled;

    public SelectPopupAdapter(Context context, int layoutResource, List<SelectPopupItem> items) {
        super(context, layoutResource, items);
        this.mItems = new ArrayList<SelectPopupItem>(items);
        this.mAreAllItemsEnabled = true;
        for (int i = 0; i < this.mItems.size(); ++i) {
            if (this.mItems.get(i).getType() == 2) continue;
            this.mAreAllItemsEnabled = false;
            break;
        }
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (position < 0 || position >= this.getCount()) {
            return null;
        }
        convertView = super.getView(position, null, parent);
        ((TextView)convertView).setText((CharSequence)this.mItems.get(position).getLabel());
        if (this.mItems.get(position).getType() != 2) {
            if (this.mItems.get(position).getType() == 0) {
                if (convertView instanceof CheckedTextView) {
                    ((CheckedTextView)convertView).setCheckMarkDrawable(null);
                }
            } else {
                convertView.setEnabled(false);
            }
        }
        return convertView;
    }

    public boolean areAllItemsEnabled() {
        return this.mAreAllItemsEnabled;
    }

    public boolean isEnabled(int position) {
        if (position < 0 || position >= this.getCount()) {
            return false;
        }
        return this.mItems.get(position).getType() == 2;
    }
}

