/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.input;

import android.content.Context;
import java.text.DateFormatSymbols;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.chromium.content.R;
import org.chromium.content.browser.input.TwoFieldDatePicker;

public class MonthPicker
extends TwoFieldDatePicker {
    private static final int MONTHS_NUMBER = 12;
    private final String[] mShortMonths;

    public MonthPicker(Context context, double minValue, double maxValue) {
        super(context, minValue, maxValue);
        this.getPositionInYearSpinner().setContentDescription((CharSequence)this.getResources().getString(R.string.accessibility_date_picker_month));
        this.mShortMonths = DateFormatSymbols.getInstance(Locale.getDefault()).getShortMonths();
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        this.init(cal.get(1), cal.get(2), null);
    }

    public static Calendar createDateFromValue(double value) {
        int year = (int)Math.min(value / 12.0 + 1970.0, 2.147483647E9);
        int month = (int)(value % 12.0);
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.clear();
        cal.set(year, month, 1);
        return cal;
    }

    protected Calendar getDateForValue(double value) {
        return MonthPicker.createDateFromValue(value);
    }

    protected void setCurrentDate(int year, int month) {
        Calendar date = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        date.set(year, month, 1);
        if (date.before(this.getMinDate())) {
            this.setCurrentDate(this.getMinDate());
        } else if (date.after(this.getMaxDate())) {
            this.setCurrentDate(this.getMaxDate());
        } else {
            this.setCurrentDate(date);
        }
    }

    protected void updateSpinners() {
        super.updateSpinners();
        String[] displayedValues = Arrays.copyOfRange(this.mShortMonths, this.getPositionInYearSpinner().getMinValue(), this.getPositionInYearSpinner().getMaxValue() + 1);
        this.getPositionInYearSpinner().setDisplayedValues(displayedValues);
    }

    public int getMonth() {
        return this.getCurrentDate().get(2);
    }

    public int getPositionInYear() {
        return this.getMonth();
    }

    protected int getMaxYear() {
        return this.getMaxDate().get(1);
    }

    protected int getMinYear() {
        return this.getMinDate().get(1);
    }

    protected int getMaxPositionInYear(int year) {
        if (year == this.getMaxDate().get(1)) {
            return this.getMaxDate().get(2);
        }
        return 11;
    }

    protected int getMinPositionInYear(int year) {
        if (year == this.getMinDate().get(1)) {
            return this.getMinDate().get(2);
        }
        return 0;
    }
}

