/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.input;

import android.os.Handler;
import android.os.ResultReceiver;
import android.os.SystemClock;
import android.text.Editable;
import android.text.SpannableString;
import android.text.style.BackgroundColorSpan;
import android.text.style.CharacterStyle;
import android.text.style.UnderlineSpan;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import com.google.common.annotations.VisibleForTesting;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.content.browser.input.AdapterInputConnection;
import org.chromium.content.browser.input.InputDialogContainer;
import org.chromium.content.browser.input.InputMethodManagerWrapper;

@JNINamespace(value="content")
public class ImeAdapter {
    private static final int COMPOSITION_KEY_CODE = 229;
    private static final int INPUT_DISMISS_DELAY = 150;
    static int sEventTypeRawKeyDown;
    static int sEventTypeKeyUp;
    static int sEventTypeChar;
    static int sTextInputTypeNone;
    static int sTextInputTypeText;
    static int sTextInputTypeTextArea;
    static int sTextInputTypePassword;
    static int sTextInputTypeSearch;
    static int sTextInputTypeUrl;
    static int sTextInputTypeEmail;
    static int sTextInputTypeTel;
    static int sTextInputTypeNumber;
    static int sTextInputTypeContentEditable;
    static int sModifierShift;
    static int sModifierAlt;
    static int sModifierCtrl;
    static int sModifierCapsLockOn;
    static int sModifierNumLockOn;
    private long mNativeImeAdapterAndroid;
    private InputMethodManagerWrapper mInputMethodManagerWrapper;
    private AdapterInputConnection mInputConnection;
    private final ImeAdapterDelegate mViewEmbedder;
    private final Handler mHandler;
    private DelayedDismissInput mDismissInput = null;
    private int mTextInputType;
    @VisibleForTesting
    boolean mIsShowWithoutHideOutstanding = false;

    public ImeAdapter(InputMethodManagerWrapper wrapper, ImeAdapterDelegate embedder) {
        this.mInputMethodManagerWrapper = wrapper;
        this.mViewEmbedder = embedder;
        this.mHandler = new Handler();
    }

    @VisibleForTesting
    public void setInputMethodManagerWrapper(InputMethodManagerWrapper immw) {
        this.mInputMethodManagerWrapper = immw;
    }

    InputMethodManagerWrapper getInputMethodManagerWrapper() {
        return this.mInputMethodManagerWrapper;
    }

    void setInputConnection(AdapterInputConnection inputConnection) {
        this.mInputConnection = inputConnection;
    }

    int getTextInputType() {
        return this.mTextInputType;
    }

    public static int getTextInputTypeNone() {
        return sTextInputTypeNone;
    }

    private static int getModifiers(int metaState) {
        int modifiers = 0;
        if ((metaState & 1) != 0) {
            modifiers |= sModifierShift;
        }
        if ((metaState & 2) != 0) {
            modifiers |= sModifierAlt;
        }
        if ((metaState & 0x1000) != 0) {
            modifiers |= sModifierCtrl;
        }
        if ((metaState & 0x100000) != 0) {
            modifiers |= sModifierCapsLockOn;
        }
        if ((metaState & 0x200000) != 0) {
            modifiers |= sModifierNumLockOn;
        }
        return modifiers;
    }

    public void updateKeyboardVisibility(long nativeImeAdapter, int textInputType, boolean showIfNeeded) {
        this.mHandler.removeCallbacks((Runnable)this.mDismissInput);
        if (this.mTextInputType == sTextInputTypeNone && !showIfNeeded) {
            return;
        }
        if (this.mNativeImeAdapterAndroid != nativeImeAdapter || this.mTextInputType != textInputType) {
            if (textInputType == sTextInputTypeNone) {
                this.mDismissInput = new DelayedDismissInput(nativeImeAdapter);
                this.mHandler.postDelayed((Runnable)this.mDismissInput, 150L);
                return;
            }
            this.attach(nativeImeAdapter, textInputType);
            this.mInputMethodManagerWrapper.restartInput(this.mViewEmbedder.getAttachedView());
            if (showIfNeeded) {
                this.showKeyboard();
            }
        } else if (this.hasInputType() && showIfNeeded) {
            this.showKeyboard();
        }
    }

    public void attach(long nativeImeAdapter, int textInputType) {
        if (this.mNativeImeAdapterAndroid != 0L) {
            this.nativeResetImeAdapter(this.mNativeImeAdapterAndroid);
        }
        this.mNativeImeAdapterAndroid = nativeImeAdapter;
        this.mTextInputType = textInputType;
        if (nativeImeAdapter != 0L) {
            this.nativeAttachImeAdapter(this.mNativeImeAdapterAndroid);
        }
        if (this.mTextInputType == sTextInputTypeNone) {
            this.dismissInput(false);
        }
    }

    public void attach(long nativeImeAdapter) {
        this.attach(nativeImeAdapter, sTextInputTypeNone);
    }

    private void showKeyboard() {
        this.mIsShowWithoutHideOutstanding = true;
        this.mInputMethodManagerWrapper.showSoftInput(this.mViewEmbedder.getAttachedView(), 0, this.mViewEmbedder.getNewShowKeyboardReceiver());
    }

    private void dismissInput(boolean unzoomIfNeeded) {
        this.mIsShowWithoutHideOutstanding = false;
        View view = this.mViewEmbedder.getAttachedView();
        if (this.mInputMethodManagerWrapper.isActive(view)) {
            this.mInputMethodManagerWrapper.hideSoftInputFromWindow(view.getWindowToken(), 0, unzoomIfNeeded ? this.mViewEmbedder.getNewShowKeyboardReceiver() : null);
        }
        this.mViewEmbedder.onDismissInput();
    }

    private boolean hasInputType() {
        return this.mTextInputType != sTextInputTypeNone;
    }

    private static boolean isTextInputType(int type) {
        return type != sTextInputTypeNone && !InputDialogContainer.isDialogInputType(type);
    }

    public boolean hasTextInputType() {
        return ImeAdapter.isTextInputType(this.mTextInputType);
    }

    public boolean isSelectionPassword() {
        return this.mTextInputType == sTextInputTypePassword;
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        return this.translateAndSendNativeEvents(event);
    }

    private int shouldSendKeyEventWithKeyCode(String text) {
        if (text.length() != 1) {
            return 229;
        }
        if (text.equals("\n")) {
            return 66;
        }
        if (text.equals("\t")) {
            return 61;
        }
        return 229;
    }

    void sendKeyEventWithKeyCode(int keyCode, int flags) {
        long eventTime = SystemClock.uptimeMillis();
        this.translateAndSendNativeEvents(new KeyEvent(eventTime, eventTime, 0, keyCode, 0, 0, -1, 0, flags));
        this.translateAndSendNativeEvents(new KeyEvent(SystemClock.uptimeMillis(), eventTime, 1, keyCode, 0, 0, -1, 0, flags));
    }

    boolean checkCompositionQueueAndCallNative(CharSequence text, int newCursorPosition, boolean isCommit) {
        if (this.mNativeImeAdapterAndroid == 0L) {
            return false;
        }
        String textStr = ((Object)text).toString();
        boolean isFinish = textStr.isEmpty();
        this.mViewEmbedder.onImeEvent(isFinish);
        int keyCode = this.shouldSendKeyEventWithKeyCode(textStr);
        long timeStampMs = SystemClock.uptimeMillis();
        if (keyCode != 229) {
            this.sendKeyEventWithKeyCode(keyCode, 6);
        } else {
            this.nativeSendSyntheticKeyEvent(this.mNativeImeAdapterAndroid, sEventTypeRawKeyDown, timeStampMs, keyCode, 0);
            if (isCommit) {
                this.nativeCommitText(this.mNativeImeAdapterAndroid, textStr);
            } else {
                this.nativeSetComposingText(this.mNativeImeAdapterAndroid, text, textStr, newCursorPosition);
            }
            this.nativeSendSyntheticKeyEvent(this.mNativeImeAdapterAndroid, sEventTypeKeyUp, timeStampMs, keyCode, 0);
        }
        return true;
    }

    void finishComposingText() {
        if (this.mNativeImeAdapterAndroid == 0L) {
            return;
        }
        this.nativeFinishComposingText(this.mNativeImeAdapterAndroid);
    }

    boolean translateAndSendNativeEvents(KeyEvent event) {
        if (this.mNativeImeAdapterAndroid == 0L) {
            return false;
        }
        int action = event.getAction();
        if (action != 0 && action != 1) {
            return false;
        }
        this.mViewEmbedder.onImeEvent(false);
        return this.nativeSendKeyEvent(this.mNativeImeAdapterAndroid, event, event.getAction(), ImeAdapter.getModifiers(event.getMetaState()), event.getEventTime(), event.getKeyCode(), false, event.getUnicodeChar());
    }

    boolean sendSyntheticKeyEvent(int eventType, long timestampMs, int keyCode, int unicodeChar) {
        if (this.mNativeImeAdapterAndroid == 0L) {
            return false;
        }
        this.nativeSendSyntheticKeyEvent(this.mNativeImeAdapterAndroid, eventType, timestampMs, keyCode, unicodeChar);
        return true;
    }

    boolean deleteSurroundingText(int beforeLength, int afterLength) {
        if (this.mNativeImeAdapterAndroid == 0L) {
            return false;
        }
        this.nativeDeleteSurroundingText(this.mNativeImeAdapterAndroid, beforeLength, afterLength);
        return true;
    }

    boolean setEditableSelectionOffsets(int start, int end) {
        if (this.mNativeImeAdapterAndroid == 0L) {
            return false;
        }
        this.nativeSetEditableSelectionOffsets(this.mNativeImeAdapterAndroid, start, end);
        return true;
    }

    boolean setComposingRegion(int start, int end) {
        if (this.mNativeImeAdapterAndroid == 0L) {
            return false;
        }
        this.nativeSetComposingRegion(this.mNativeImeAdapterAndroid, start, end);
        return true;
    }

    public boolean unselect() {
        if (this.mNativeImeAdapterAndroid == 0L) {
            return false;
        }
        this.nativeUnselect(this.mNativeImeAdapterAndroid);
        return true;
    }

    public boolean selectAll() {
        if (this.mNativeImeAdapterAndroid == 0L) {
            return false;
        }
        this.nativeSelectAll(this.mNativeImeAdapterAndroid);
        return true;
    }

    public boolean cut() {
        if (this.mNativeImeAdapterAndroid == 0L) {
            return false;
        }
        this.nativeCut(this.mNativeImeAdapterAndroid);
        return true;
    }

    public boolean copy() {
        if (this.mNativeImeAdapterAndroid == 0L) {
            return false;
        }
        this.nativeCopy(this.mNativeImeAdapterAndroid);
        return true;
    }

    public boolean paste() {
        if (this.mNativeImeAdapterAndroid == 0L) {
            return false;
        }
        this.nativePaste(this.mNativeImeAdapterAndroid);
        return true;
    }

    @CalledByNative
    private static void initializeWebInputEvents(int eventTypeRawKeyDown, int eventTypeKeyUp, int eventTypeChar, int modifierShift, int modifierAlt, int modifierCtrl, int modifierCapsLockOn, int modifierNumLockOn) {
        sEventTypeRawKeyDown = eventTypeRawKeyDown;
        sEventTypeKeyUp = eventTypeKeyUp;
        sEventTypeChar = eventTypeChar;
        sModifierShift = modifierShift;
        sModifierAlt = modifierAlt;
        sModifierCtrl = modifierCtrl;
        sModifierCapsLockOn = modifierCapsLockOn;
        sModifierNumLockOn = modifierNumLockOn;
    }

    @CalledByNative
    private static void initializeTextInputTypes(int textInputTypeNone, int textInputTypeText, int textInputTypeTextArea, int textInputTypePassword, int textInputTypeSearch, int textInputTypeUrl, int textInputTypeEmail, int textInputTypeTel, int textInputTypeNumber, int textInputTypeContentEditable) {
        sTextInputTypeNone = textInputTypeNone;
        sTextInputTypeText = textInputTypeText;
        sTextInputTypeTextArea = textInputTypeTextArea;
        sTextInputTypePassword = textInputTypePassword;
        sTextInputTypeSearch = textInputTypeSearch;
        sTextInputTypeUrl = textInputTypeUrl;
        sTextInputTypeEmail = textInputTypeEmail;
        sTextInputTypeTel = textInputTypeTel;
        sTextInputTypeNumber = textInputTypeNumber;
        sTextInputTypeContentEditable = textInputTypeContentEditable;
    }

    @CalledByNative
    private void focusedNodeChanged(boolean isEditable) {
        if (this.mInputConnection != null && isEditable) {
            this.mInputConnection.restartInput();
        }
    }

    @CalledByNative
    private void populateUnderlinesFromSpans(CharSequence text, long underlines) {
        CharacterStyle[] spans;
        if (!(text instanceof SpannableString)) {
            return;
        }
        SpannableString spannableString = (SpannableString)text;
        for (CharacterStyle span : spans = (CharacterStyle[])spannableString.getSpans(0, text.length(), CharacterStyle.class)) {
            if (span instanceof BackgroundColorSpan) {
                ImeAdapter.nativeAppendBackgroundColorSpan(underlines, spannableString.getSpanStart((Object)span), spannableString.getSpanEnd((Object)span), ((BackgroundColorSpan)span).getBackgroundColor());
                continue;
            }
            if (!(span instanceof UnderlineSpan)) continue;
            ImeAdapter.nativeAppendUnderlineSpan(underlines, spannableString.getSpanStart((Object)span), spannableString.getSpanEnd((Object)span));
        }
    }

    @CalledByNative
    private void cancelComposition() {
        if (this.mInputConnection != null) {
            this.mInputConnection.restartInput();
        }
    }

    @CalledByNative
    void detach() {
        if (this.mDismissInput != null) {
            this.mHandler.removeCallbacks((Runnable)this.mDismissInput);
        }
        this.mNativeImeAdapterAndroid = 0L;
        this.mTextInputType = 0;
    }

    private native boolean nativeSendSyntheticKeyEvent(long var1, int var3, long var4, int var6, int var7);

    private native boolean nativeSendKeyEvent(long var1, KeyEvent var3, int var4, int var5, long var6, int var8, boolean var9, int var10);

    private static native void nativeAppendUnderlineSpan(long var0, int var2, int var3);

    private static native void nativeAppendBackgroundColorSpan(long var0, int var2, int var3, int var4);

    private native void nativeSetComposingText(long var1, CharSequence var3, String var4, int var5);

    private native void nativeCommitText(long var1, String var3);

    private native void nativeFinishComposingText(long var1);

    private native void nativeAttachImeAdapter(long var1);

    private native void nativeSetEditableSelectionOffsets(long var1, int var3, int var4);

    private native void nativeSetComposingRegion(long var1, int var3, int var4);

    private native void nativeDeleteSurroundingText(long var1, int var3, int var4);

    private native void nativeUnselect(long var1);

    private native void nativeSelectAll(long var1);

    private native void nativeCut(long var1);

    private native void nativeCopy(long var1);

    private native void nativePaste(long var1);

    private native void nativeResetImeAdapter(long var1);

    public static class AdapterInputConnectionFactory {
        public AdapterInputConnection get(View view, ImeAdapter imeAdapter, Editable editable, EditorInfo outAttrs) {
            return new AdapterInputConnection(view, imeAdapter, editable, outAttrs);
        }
    }

    private class DelayedDismissInput
    implements Runnable {
        private final long mNativeImeAdapter;

        DelayedDismissInput(long nativeImeAdapter) {
            this.mNativeImeAdapter = nativeImeAdapter;
        }

        public void run() {
            ImeAdapter.this.attach(this.mNativeImeAdapter, sTextInputTypeNone);
            ImeAdapter.this.dismissInput(true);
        }
    }

    public static interface ImeAdapterDelegate {
        public void onImeEvent(boolean var1);

        public void onDismissInput();

        public View getAttachedView();

        public ResultReceiver getNewShowKeyboardReceiver();
    }
}

