/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.input;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.hardware.input.InputManager;
import android.os.Build;
import android.view.InputDevice;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.MotionEvent;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.base.ThreadUtils;
import org.chromium.content.browser.input.GamepadDevice;

@JNINamespace(value="content")
public class GamepadList {
    private static final int MAX_GAMEPADS = 4;
    private final Object mLock = new Object();
    private final GamepadDevice[] mGamepadDevices = new GamepadDevice[4];
    private InputManager mInputManager;
    private int mAttachedToWindowCounter;
    private boolean mIsGamepadAccessed;
    private InputManager.InputDeviceListener mInputDeviceListener = new InputManager.InputDeviceListener(){

        public void onInputDeviceChanged(int deviceId) {
            GamepadList.this.onInputDeviceChangedImpl(deviceId);
        }

        public void onInputDeviceRemoved(int deviceId) {
            GamepadList.this.onInputDeviceRemovedImpl(deviceId);
        }

        public void onInputDeviceAdded(int deviceId) {
            GamepadList.this.onInputDeviceAddedImpl(deviceId);
        }
    };

    @TargetApi(value=16)
    private GamepadList() {
    }

    @TargetApi(value=16)
    private void initializeDevices() {
        int[] deviceIds = this.mInputManager.getInputDeviceIds();
        for (int i = 0; i < deviceIds.length; ++i) {
            InputDevice inputDevice = InputDevice.getDevice((int)deviceIds[i]);
            if (!GamepadList.isGamepadDevice(inputDevice)) continue;
            this.registerGamepad(inputDevice);
        }
    }

    public static void onAttachedToWindow(Context context) {
        assert (ThreadUtils.runningOnUiThread());
        if (!GamepadList.isGamepadSupported()) {
            return;
        }
        GamepadList.getInstance().attachedToWindow(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=16)
    private void attachedToWindow(Context context) {
        if (this.mAttachedToWindowCounter++ == 0) {
            this.mInputManager = (InputManager)context.getSystemService("input");
            Object object = this.mLock;
            synchronized (object) {
                this.initializeDevices();
            }
            this.mInputManager.registerInputDeviceListener(this.mInputDeviceListener, null);
        }
    }

    @SuppressLint(value={"MissingSuperCall"})
    public static void onDetachedFromWindow() {
        assert (ThreadUtils.runningOnUiThread());
        if (!GamepadList.isGamepadSupported()) {
            return;
        }
        GamepadList.getInstance().detachedFromWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=16)
    private void detachedFromWindow() {
        if (--this.mAttachedToWindowCounter == 0) {
            Object object = this.mLock;
            synchronized (object) {
                for (int i = 0; i < 4; ++i) {
                    this.mGamepadDevices[i] = null;
                }
            }
            this.mInputManager.unregisterInputDeviceListener(this.mInputDeviceListener);
            this.mInputManager = null;
        }
    }

    private void onInputDeviceChangedImpl(int deviceId) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onInputDeviceRemovedImpl(int deviceId) {
        Object object = this.mLock;
        synchronized (object) {
            this.unregisterGamepad(deviceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onInputDeviceAddedImpl(int deviceId) {
        InputDevice inputDevice = InputDevice.getDevice((int)deviceId);
        if (!GamepadList.isGamepadDevice(inputDevice)) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.registerGamepad(inputDevice);
        }
    }

    private static GamepadList getInstance() {
        assert (GamepadList.isGamepadSupported());
        return LazyHolder.INSTANCE;
    }

    private int getDeviceCount() {
        int count = 0;
        for (int i = 0; i < 4; ++i) {
            if (this.getDevice(i) == null) continue;
            ++count;
        }
        return count;
    }

    private boolean isDeviceConnected(int index) {
        return index < 4 && this.getDevice(index) != null;
    }

    private GamepadDevice getDeviceById(int deviceId) {
        for (int i = 0; i < 4; ++i) {
            GamepadDevice gamepad = this.mGamepadDevices[i];
            if (gamepad == null || gamepad.getId() != deviceId) continue;
            return gamepad;
        }
        return null;
    }

    private GamepadDevice getDevice(int index) {
        assert (index >= 0 && index < 4);
        return this.mGamepadDevices[index];
    }

    public static boolean dispatchKeyEvent(KeyEvent event) {
        if (!GamepadList.isGamepadSupported()) {
            return false;
        }
        if (!GamepadList.isGamepadEvent(event)) {
            return false;
        }
        return GamepadList.getInstance().handleKeyEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleKeyEvent(KeyEvent event) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mIsGamepadAccessed) {
                return false;
            }
            GamepadDevice gamepad = this.getGamepadForEvent((InputEvent)event);
            if (gamepad == null) {
                return false;
            }
            return gamepad.handleKeyEvent(event);
        }
    }

    public static boolean onGenericMotionEvent(MotionEvent event) {
        if (!GamepadList.isGamepadSupported()) {
            return false;
        }
        if (!GamepadList.isGamepadEvent(event)) {
            return false;
        }
        return GamepadList.getInstance().handleMotionEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleMotionEvent(MotionEvent event) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mIsGamepadAccessed) {
                return false;
            }
            GamepadDevice gamepad = this.getGamepadForEvent((InputEvent)event);
            if (gamepad == null) {
                return false;
            }
            return gamepad.handleMotionEvent(event);
        }
    }

    private int getNextAvailableIndex() {
        for (int i = 0; i < 4; ++i) {
            if (this.getDevice(i) != null) continue;
            return i;
        }
        return -1;
    }

    private boolean registerGamepad(InputDevice inputDevice) {
        GamepadDevice gamepad;
        int index = this.getNextAvailableIndex();
        if (index == -1) {
            return false;
        }
        this.mGamepadDevices[index] = gamepad = new GamepadDevice(index, inputDevice);
        return true;
    }

    private void unregisterGamepad(int deviceId) {
        GamepadDevice gamepadDevice = this.getDeviceById(deviceId);
        if (gamepadDevice == null) {
            return;
        }
        int index = gamepadDevice.getIndex();
        this.mGamepadDevices[index] = null;
    }

    private static boolean isGamepadDevice(InputDevice inputDevice) {
        return (inputDevice.getSources() & 0x1000010) == 0x1000010;
    }

    private GamepadDevice getGamepadForEvent(InputEvent event) {
        return this.getDeviceById(event.getDeviceId());
    }

    public static boolean isGamepadEvent(MotionEvent event) {
        return (event.getSource() & 0x1000010) == 0x1000010;
    }

    public static boolean isGamepadEvent(KeyEvent event) {
        int keyCode = event.getKeyCode();
        switch (keyCode) {
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                return true;
            }
        }
        return KeyEvent.isGamepadButton((int)keyCode);
    }

    private static boolean isGamepadSupported() {
        return Build.VERSION.SDK_INT >= 16;
    }

    @CalledByNative
    static void updateGamepadData(long webGamepadsPtr) {
        if (!GamepadList.isGamepadSupported()) {
            return;
        }
        GamepadList.getInstance().grabGamepadData(webGamepadsPtr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void grabGamepadData(long webGamepadsPtr) {
        Object object = this.mLock;
        synchronized (object) {
            for (int i = 0; i < 4; ++i) {
                GamepadDevice device = this.getDevice(i);
                if (device != null) {
                    device.updateButtonsAndAxesMapping();
                    this.nativeSetGamepadData(webGamepadsPtr, i, device.isStandardGamepad(), true, device.getName(), device.getTimestamp(), device.getAxes(), device.getButtons());
                    continue;
                }
                this.nativeSetGamepadData(webGamepadsPtr, i, false, false, null, 0L, null, null);
            }
        }
    }

    @CalledByNative
    static void notifyForGamepadsAccess(boolean isAccessPaused) {
        if (!GamepadList.isGamepadSupported()) {
            return;
        }
        GamepadList.getInstance().setIsGamepadAccessed(!isAccessPaused);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setIsGamepadAccessed(boolean isGamepadAccessed) {
        Object object = this.mLock;
        synchronized (object) {
            this.mIsGamepadAccessed = isGamepadAccessed;
            if (isGamepadAccessed) {
                for (int i = 0; i < 4; ++i) {
                    GamepadDevice gamepadDevice = this.getDevice(i);
                    if (gamepadDevice == null) continue;
                    gamepadDevice.clearData();
                }
            }
        }
    }

    private native void nativeSetGamepadData(long var1, int var3, boolean var4, boolean var5, String var6, long var7, float[] var9, float[] var10);

    private static class LazyHolder {
        private static final GamepadList INSTANCE = new GamepadList();

        private LazyHolder() {
        }
    }
}

