/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.input;

import android.os.SystemClock;
import android.view.InputDevice;
import android.view.KeyEvent;
import android.view.MotionEvent;
import java.util.Arrays;
import java.util.List;
import org.chromium.content.browser.input.GamepadList;
import org.chromium.content.browser.input.GamepadMappings;

class GamepadDevice {
    private int mDeviceId;
    private int mDeviceIndex;
    private long mTimestamp;
    private boolean mIsStandardGamepad;
    private final float[] mAxisValues = new float[4];
    private final float[] mButtonsValues = new float[17];
    private final float[] mRawButtons = new float[256];
    private final float[] mRawAxes = new float[256];
    private String mDeviceName;
    private int[] mAxes;

    GamepadDevice(int index, InputDevice inputDevice) {
        this.mDeviceIndex = index;
        this.mDeviceId = inputDevice.getId();
        this.mDeviceName = inputDevice.getName();
        this.mTimestamp = SystemClock.uptimeMillis();
        List ranges = inputDevice.getMotionRanges();
        this.mAxes = new int[ranges.size()];
        int i = 0;
        for (InputDevice.MotionRange range : ranges) {
            if ((range.getSource() & 0x10) == 0) continue;
            int axis = range.getAxis();
            assert (axis < 256);
            this.mAxes[i++] = axis;
        }
    }

    public void updateButtonsAndAxesMapping() {
        this.mIsStandardGamepad = GamepadMappings.mapToStandardGamepad(this.mAxisValues, this.mButtonsValues, this.mRawAxes, this.mRawButtons, this.mDeviceName);
    }

    public int getId() {
        return this.mDeviceId;
    }

    public boolean isStandardGamepad() {
        return this.mIsStandardGamepad;
    }

    public String getName() {
        return this.mDeviceName;
    }

    public int getIndex() {
        return this.mDeviceIndex;
    }

    public long getTimestamp() {
        return this.mTimestamp;
    }

    public float[] getAxes() {
        return this.mAxisValues;
    }

    public float[] getButtons() {
        return this.mButtonsValues;
    }

    public void clearData() {
        Arrays.fill(this.mAxisValues, 0.0f);
        Arrays.fill(this.mRawAxes, 0.0f);
        Arrays.fill(this.mButtonsValues, 0.0f);
        Arrays.fill(this.mRawButtons, 0.0f);
    }

    public boolean handleKeyEvent(KeyEvent event) {
        if (!GamepadList.isGamepadEvent(event)) {
            return false;
        }
        int keyCode = event.getKeyCode();
        assert (keyCode < 256);
        if (event.getAction() == 0) {
            this.mRawButtons[keyCode] = 1.0f;
        } else if (event.getAction() == 1) {
            this.mRawButtons[keyCode] = 0.0f;
        }
        this.mTimestamp = event.getEventTime();
        return true;
    }

    public boolean handleMotionEvent(MotionEvent event) {
        if (!GamepadList.isGamepadEvent(event)) {
            return false;
        }
        for (int i = 0; i < this.mAxes.length; ++i) {
            int axis = this.mAxes[i];
            this.mRawAxes[axis] = event.getAxisValue(axis);
        }
        this.mTimestamp = event.getEventTime();
        return true;
    }
}

