/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.input;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.text.format.Time;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.DatePicker;
import android.widget.TimePicker;
import org.chromium.content.R;
import org.chromium.content.browser.input.DateDialogNormalizer;

class DateTimePickerDialog
extends AlertDialog
implements DialogInterface.OnClickListener,
DatePicker.OnDateChangedListener,
TimePicker.OnTimeChangedListener {
    private final DatePicker mDatePicker;
    private final TimePicker mTimePicker;
    private final OnDateTimeSetListener mCallBack;
    private final long mMinTimeMillis;
    private final long mMaxTimeMillis;

    public DateTimePickerDialog(Context context, OnDateTimeSetListener callBack, int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minute, boolean is24HourView, double min, double max) {
        super(context, 0);
        this.mMinTimeMillis = (long)min;
        this.mMaxTimeMillis = (long)max;
        this.mCallBack = callBack;
        this.setButton(-1, context.getText(R.string.date_picker_dialog_set), this);
        this.setButton(-2, context.getText(0x1040000), null);
        this.setIcon(0);
        this.setTitle(context.getText(R.string.date_time_picker_dialog_title));
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        View view = inflater.inflate(R.layout.date_time_picker_dialog, null);
        this.setView(view);
        this.mDatePicker = (DatePicker)view.findViewById(R.id.date_picker);
        DateDialogNormalizer.normalize(this.mDatePicker, this, year, monthOfYear, dayOfMonth, hourOfDay, minute, this.mMinTimeMillis, this.mMaxTimeMillis);
        this.mTimePicker = (TimePicker)view.findViewById(R.id.time_picker);
        this.mTimePicker.setIs24HourView(Boolean.valueOf(is24HourView));
        this.mTimePicker.setCurrentHour(Integer.valueOf(hourOfDay));
        this.mTimePicker.setCurrentMinute(Integer.valueOf(minute));
        this.mTimePicker.setOnTimeChangedListener((TimePicker.OnTimeChangedListener)this);
        this.onTimeChanged(this.mTimePicker, this.mTimePicker.getCurrentHour(), this.mTimePicker.getCurrentMinute());
    }

    public void onClick(DialogInterface dialog, int which) {
        this.tryNotifyDateTimeSet();
    }

    private void tryNotifyDateTimeSet() {
        if (this.mCallBack != null) {
            this.mDatePicker.clearFocus();
            this.mCallBack.onDateTimeSet(this.mDatePicker, this.mTimePicker, this.mDatePicker.getYear(), this.mDatePicker.getMonth(), this.mDatePicker.getDayOfMonth(), this.mTimePicker.getCurrentHour(), this.mTimePicker.getCurrentMinute());
        }
    }

    public void onDateChanged(DatePicker view, int year, int month, int day) {
        if (this.mTimePicker != null) {
            this.onTimeChanged(this.mTimePicker, this.mTimePicker.getCurrentHour(), this.mTimePicker.getCurrentMinute());
        }
    }

    public void onTimeChanged(TimePicker view, int hourOfDay, int minute) {
        Time time = new Time();
        time.set(0, this.mTimePicker.getCurrentMinute().intValue(), this.mTimePicker.getCurrentHour().intValue(), this.mDatePicker.getDayOfMonth(), this.mDatePicker.getMonth(), this.mDatePicker.getYear());
        if (time.toMillis(true) < this.mMinTimeMillis) {
            time.set(this.mMinTimeMillis);
        } else if (time.toMillis(true) > this.mMaxTimeMillis) {
            time.set(this.mMaxTimeMillis);
        }
        this.mTimePicker.setCurrentHour(Integer.valueOf(time.hour));
        this.mTimePicker.setCurrentMinute(Integer.valueOf(time.minute));
    }

    public void updateDateTime(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minutOfHour) {
        this.mDatePicker.updateDate(year, monthOfYear, dayOfMonth);
        this.mTimePicker.setCurrentHour(Integer.valueOf(hourOfDay));
        this.mTimePicker.setCurrentMinute(Integer.valueOf(minutOfHour));
    }

    public static interface OnDateTimeSetListener {
        public void onDateTimeSet(DatePicker var1, TimePicker var2, int var3, int var4, int var5, int var6, int var7);
    }
}

