/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.input;

import android.content.Context;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.content.browser.ContentViewCore;
import org.chromium.content.browser.input.DateTimeSuggestion;
import org.chromium.content.browser.input.InputDialogContainer;

@JNINamespace(value="content")
class DateTimeChooserAndroid {
    private final long mNativeDateTimeChooserAndroid;
    private final InputDialogContainer mInputDialogContainer;

    private DateTimeChooserAndroid(Context context, long nativeDateTimeChooserAndroid) {
        this.mNativeDateTimeChooserAndroid = nativeDateTimeChooserAndroid;
        this.mInputDialogContainer = new InputDialogContainer(context, new InputDialogContainer.InputActionDelegate(){

            public void replaceDateTime(double value) {
                DateTimeChooserAndroid.this.nativeReplaceDateTime(DateTimeChooserAndroid.this.mNativeDateTimeChooserAndroid, value);
            }

            public void cancelDateTimeDialog() {
                DateTimeChooserAndroid.this.nativeCancelDialog(DateTimeChooserAndroid.this.mNativeDateTimeChooserAndroid);
            }
        });
    }

    private void showDialog(int dialogType, double dialogValue, double min, double max, double step, DateTimeSuggestion[] suggestions) {
        this.mInputDialogContainer.showDialog(dialogType, dialogValue, min, max, step, suggestions);
    }

    @CalledByNative
    private static DateTimeChooserAndroid createDateTimeChooser(ContentViewCore contentViewCore, long nativeDateTimeChooserAndroid, int dialogType, double dialogValue, double min, double max, double step, DateTimeSuggestion[] suggestions) {
        DateTimeChooserAndroid chooser = new DateTimeChooserAndroid(contentViewCore.getContext(), nativeDateTimeChooserAndroid);
        chooser.showDialog(dialogType, dialogValue, min, max, step, suggestions);
        return chooser;
    }

    @CalledByNative
    private static DateTimeSuggestion[] createSuggestionsArray(int size) {
        return new DateTimeSuggestion[size];
    }

    @CalledByNative
    private static void setDateTimeSuggestionAt(DateTimeSuggestion[] array, int index, double value, String localizedValue, String label) {
        array[index] = new DateTimeSuggestion(value, localizedValue, label);
    }

    @CalledByNative
    private static void initializeDateInputTypes(int textInputTypeDate, int textInputTypeDateTime, int textInputTypeDateTimeLocal, int textInputTypeMonth, int textInputTypeTime, int textInputTypeWeek) {
        InputDialogContainer.initializeInputTypes(textInputTypeDate, textInputTypeDateTime, textInputTypeDateTimeLocal, textInputTypeMonth, textInputTypeTime, textInputTypeWeek);
    }

    private native void nativeReplaceDateTime(long var1, double var3);

    private native void nativeCancelDialog(long var1);
}

