/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.input;

import android.os.SystemClock;
import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import com.google.common.annotations.VisibleForTesting;
import org.chromium.content.browser.input.ImeAdapter;
import org.chromium.content.browser.input.InputMethodManagerWrapper;

public class AdapterInputConnection
extends BaseInputConnection {
    private static final String TAG = "AdapterInputConnection";
    private static final boolean DEBUG = false;
    public static final int INVALID_SELECTION = -1;
    public static final int INVALID_COMPOSITION = -1;
    private final View mInternalView;
    private final ImeAdapter mImeAdapter;
    private final Editable mEditable;
    private boolean mSingleLine;
    private int mNumNestedBatchEdits = 0;
    private int mLastUpdateSelectionStart = -1;
    private int mLastUpdateSelectionEnd = -1;
    private int mLastUpdateCompositionStart = -1;
    private int mLastUpdateCompositionEnd = -1;

    @VisibleForTesting
    AdapterInputConnection(View view, ImeAdapter imeAdapter, Editable editable, EditorInfo outAttrs) {
        super(view, true);
        this.mInternalView = view;
        this.mImeAdapter = imeAdapter;
        this.mImeAdapter.setInputConnection(this);
        this.mEditable = editable;
        AdapterInputConnection.removeComposingSpans((Spannable)this.mEditable);
        this.mSingleLine = true;
        outAttrs.imeOptions = 0x12000000;
        outAttrs.inputType = 161;
        if (imeAdapter.getTextInputType() == ImeAdapter.sTextInputTypeText) {
            outAttrs.inputType |= 0x8000;
            outAttrs.imeOptions |= 2;
        } else if (imeAdapter.getTextInputType() == ImeAdapter.sTextInputTypeTextArea || imeAdapter.getTextInputType() == ImeAdapter.sTextInputTypeContentEditable) {
            outAttrs.inputType |= 0x2C000;
            outAttrs.imeOptions |= 1;
            this.mSingleLine = false;
        } else if (imeAdapter.getTextInputType() == ImeAdapter.sTextInputTypePassword) {
            outAttrs.inputType = 225;
            outAttrs.imeOptions |= 2;
        } else if (imeAdapter.getTextInputType() == ImeAdapter.sTextInputTypeSearch) {
            outAttrs.imeOptions |= 3;
        } else if (imeAdapter.getTextInputType() == ImeAdapter.sTextInputTypeUrl) {
            outAttrs.inputType = 17;
            outAttrs.imeOptions |= 2;
        } else if (imeAdapter.getTextInputType() == ImeAdapter.sTextInputTypeEmail) {
            outAttrs.inputType = 209;
            outAttrs.imeOptions |= 2;
        } else if (imeAdapter.getTextInputType() == ImeAdapter.sTextInputTypeTel) {
            outAttrs.inputType = 3;
            outAttrs.imeOptions |= 5;
        } else if (imeAdapter.getTextInputType() == ImeAdapter.sTextInputTypeNumber) {
            outAttrs.inputType = 8194;
            outAttrs.imeOptions |= 5;
        }
        outAttrs.initialSelStart = Selection.getSelectionStart((CharSequence)this.mEditable);
        outAttrs.initialSelEnd = Selection.getSelectionEnd((CharSequence)this.mEditable);
        this.mLastUpdateSelectionStart = Selection.getSelectionStart((CharSequence)this.mEditable);
        this.mLastUpdateSelectionEnd = Selection.getSelectionEnd((CharSequence)this.mEditable);
        Selection.setSelection((Spannable)this.mEditable, (int)outAttrs.initialSelStart, (int)outAttrs.initialSelEnd);
        this.updateSelectionIfRequired();
    }

    @VisibleForTesting
    public void updateState(String text, int selectionStart, int selectionEnd, int compositionStart, int compositionEnd, boolean isNonImeChange) {
        if (!isNonImeChange) {
            return;
        }
        text = text.replace('\u00a0', ' ');
        selectionStart = Math.min(selectionStart, text.length());
        selectionEnd = Math.min(selectionEnd, text.length());
        compositionStart = Math.min(compositionStart, text.length());
        compositionEnd = Math.min(compositionEnd, text.length());
        String prevText = this.mEditable.toString();
        boolean textUnchanged = prevText.equals(text);
        if (!textUnchanged) {
            this.mEditable.replace(0, this.mEditable.length(), (CharSequence)text);
        }
        Selection.setSelection((Spannable)this.mEditable, (int)selectionStart, (int)selectionEnd);
        if (compositionStart == compositionEnd) {
            AdapterInputConnection.removeComposingSpans((Spannable)this.mEditable);
        } else {
            super.setComposingRegion(compositionStart, compositionEnd);
        }
        this.updateSelectionIfRequired();
    }

    public Editable getEditable() {
        return this.mEditable;
    }

    private void updateSelectionIfRequired() {
        if (this.mNumNestedBatchEdits != 0) {
            return;
        }
        int selectionStart = Selection.getSelectionStart((CharSequence)this.mEditable);
        int selectionEnd = Selection.getSelectionEnd((CharSequence)this.mEditable);
        int compositionStart = AdapterInputConnection.getComposingSpanStart((Spannable)this.mEditable);
        int compositionEnd = AdapterInputConnection.getComposingSpanEnd((Spannable)this.mEditable);
        if (this.mLastUpdateSelectionStart == selectionStart && this.mLastUpdateSelectionEnd == selectionEnd && this.mLastUpdateCompositionStart == compositionStart && this.mLastUpdateCompositionEnd == compositionEnd) {
            return;
        }
        this.getInputMethodManagerWrapper().updateSelection(this.mInternalView, selectionStart, selectionEnd, compositionStart, compositionEnd);
        this.mLastUpdateSelectionStart = selectionStart;
        this.mLastUpdateSelectionEnd = selectionEnd;
        this.mLastUpdateCompositionStart = compositionStart;
        this.mLastUpdateCompositionEnd = compositionEnd;
    }

    public boolean setComposingText(CharSequence text, int newCursorPosition) {
        if (this.maybePerformEmptyCompositionWorkaround(text)) {
            return true;
        }
        super.setComposingText(text, newCursorPosition);
        this.updateSelectionIfRequired();
        return this.mImeAdapter.checkCompositionQueueAndCallNative(text, newCursorPosition, false);
    }

    public boolean commitText(CharSequence text, int newCursorPosition) {
        if (this.maybePerformEmptyCompositionWorkaround(text)) {
            return true;
        }
        super.commitText(text, newCursorPosition);
        this.updateSelectionIfRequired();
        return this.mImeAdapter.checkCompositionQueueAndCallNative(text, newCursorPosition, text.length() > 0);
    }

    public boolean performEditorAction(int actionCode) {
        if (actionCode == 5) {
            this.restartInput();
            long timeStampMs = SystemClock.uptimeMillis();
            this.mImeAdapter.sendSyntheticKeyEvent(ImeAdapter.sEventTypeRawKeyDown, timeStampMs, 61, 0);
        } else {
            this.mImeAdapter.sendKeyEventWithKeyCode(66, 22);
        }
        return true;
    }

    public boolean performContextMenuAction(int id2) {
        switch (id2) {
            case 16908319: {
                return this.mImeAdapter.selectAll();
            }
            case 0x1020020: {
                return this.mImeAdapter.cut();
            }
            case 0x1020021: {
                return this.mImeAdapter.copy();
            }
            case 0x1020022: {
                return this.mImeAdapter.paste();
            }
        }
        return false;
    }

    public ExtractedText getExtractedText(ExtractedTextRequest request, int flags) {
        ExtractedText et = new ExtractedText();
        et.text = this.mEditable.toString();
        et.partialEndOffset = this.mEditable.length();
        et.selectionStart = Selection.getSelectionStart((CharSequence)this.mEditable);
        et.selectionEnd = Selection.getSelectionEnd((CharSequence)this.mEditable);
        et.flags = this.mSingleLine ? 1 : 0;
        return et;
    }

    public boolean beginBatchEdit() {
        ++this.mNumNestedBatchEdits;
        return true;
    }

    public boolean endBatchEdit() {
        if (this.mNumNestedBatchEdits == 0) {
            return false;
        }
        --this.mNumNestedBatchEdits;
        if (this.mNumNestedBatchEdits == 0) {
            this.updateSelectionIfRequired();
        }
        return this.mNumNestedBatchEdits != 0;
    }

    public boolean deleteSurroundingText(int beforeLength, int afterLength) {
        int availableBefore = Selection.getSelectionStart((CharSequence)this.mEditable);
        int availableAfter = this.mEditable.length() - Selection.getSelectionEnd((CharSequence)this.mEditable);
        beforeLength = Math.min(beforeLength, availableBefore);
        afterLength = Math.min(afterLength, availableAfter);
        super.deleteSurroundingText(beforeLength, afterLength);
        this.updateSelectionIfRequired();
        return this.mImeAdapter.deleteSurroundingText(beforeLength, afterLength);
    }

    public boolean sendKeyEvent(KeyEvent event) {
        if (event.getAction() == 1) {
            if (event.getKeyCode() == 67) {
                this.deleteSurroundingText(1, 0);
                return true;
            }
            if (event.getKeyCode() == 112) {
                this.deleteSurroundingText(0, 1);
                return true;
            }
            int unicodeChar = event.getUnicodeChar();
            if (unicodeChar != 0) {
                int selectionEnd;
                int selectionStart = Selection.getSelectionStart((CharSequence)this.mEditable);
                if (selectionStart > (selectionEnd = Selection.getSelectionEnd((CharSequence)this.mEditable))) {
                    int temp = selectionStart;
                    selectionStart = selectionEnd;
                    selectionEnd = temp;
                }
                this.mEditable.replace(selectionStart, selectionEnd, (CharSequence)Character.toString((char)unicodeChar));
            }
        } else if (event.getAction() == 0) {
            if (event.getKeyCode() == 66) {
                this.beginBatchEdit();
                this.finishComposingText();
                this.mImeAdapter.translateAndSendNativeEvents(event);
                this.endBatchEdit();
                return true;
            }
            if (event.getKeyCode() == 67) {
                return true;
            }
            if (event.getKeyCode() == 112) {
                return true;
            }
        }
        this.mImeAdapter.translateAndSendNativeEvents(event);
        return true;
    }

    public boolean finishComposingText() {
        if (AdapterInputConnection.getComposingSpanStart((Spannable)this.mEditable) == AdapterInputConnection.getComposingSpanEnd((Spannable)this.mEditable)) {
            return true;
        }
        super.finishComposingText();
        this.updateSelectionIfRequired();
        this.mImeAdapter.finishComposingText();
        return true;
    }

    public boolean setSelection(int start, int end) {
        int textLength = this.mEditable.length();
        if (start < 0 || end < 0 || start > textLength || end > textLength) {
            return true;
        }
        super.setSelection(start, end);
        this.updateSelectionIfRequired();
        return this.mImeAdapter.setEditableSelectionOffsets(start, end);
    }

    void restartInput() {
        this.getInputMethodManagerWrapper().restartInput(this.mInternalView);
        this.mNumNestedBatchEdits = 0;
    }

    public boolean setComposingRegion(int start, int end) {
        int textLength = this.mEditable.length();
        int a = Math.min(start, end);
        int b = Math.max(start, end);
        if (a < 0) {
            a = 0;
        }
        if (b < 0) {
            b = 0;
        }
        if (a > textLength) {
            a = textLength;
        }
        if (b > textLength) {
            b = textLength;
        }
        if (a == b) {
            AdapterInputConnection.removeComposingSpans((Spannable)this.mEditable);
        } else {
            super.setComposingRegion(a, b);
        }
        this.updateSelectionIfRequired();
        return this.mImeAdapter.setComposingRegion(a, b);
    }

    boolean isActive() {
        return this.getInputMethodManagerWrapper().isActive(this.mInternalView);
    }

    private InputMethodManagerWrapper getInputMethodManagerWrapper() {
        return this.mImeAdapter.getInputMethodManagerWrapper();
    }

    private boolean maybePerformEmptyCompositionWorkaround(CharSequence text) {
        int selectionStart = Selection.getSelectionStart((CharSequence)this.mEditable);
        int selectionEnd = Selection.getSelectionEnd((CharSequence)this.mEditable);
        int compositionStart = AdapterInputConnection.getComposingSpanStart((Spannable)this.mEditable);
        int compositionEnd = AdapterInputConnection.getComposingSpanEnd((Spannable)this.mEditable);
        if (TextUtils.isEmpty((CharSequence)text) && selectionStart == selectionEnd && compositionStart != -1 && compositionEnd != -1) {
            this.beginBatchEdit();
            this.finishComposingText();
            int selection = Selection.getSelectionStart((CharSequence)this.mEditable);
            this.deleteSurroundingText(selection - compositionStart, selection - compositionEnd);
            this.endBatchEdit();
            return true;
        }
        return false;
    }

    @VisibleForTesting
    ImeState getImeStateForTesting() {
        String text = this.mEditable.toString();
        int selectionStart = Selection.getSelectionStart((CharSequence)this.mEditable);
        int selectionEnd = Selection.getSelectionEnd((CharSequence)this.mEditable);
        int compositionStart = AdapterInputConnection.getComposingSpanStart((Spannable)this.mEditable);
        int compositionEnd = AdapterInputConnection.getComposingSpanEnd((Spannable)this.mEditable);
        return new ImeState(text, selectionStart, selectionEnd, compositionStart, compositionEnd);
    }

    @VisibleForTesting
    static class ImeState {
        public final String text;
        public final int selectionStart;
        public final int selectionEnd;
        public final int compositionStart;
        public final int compositionEnd;

        public ImeState(String text, int selectionStart, int selectionEnd, int compositionStart, int compositionEnd) {
            this.text = text;
            this.selectionStart = selectionStart;
            this.selectionEnd = selectionEnd;
            this.compositionStart = compositionStart;
            this.compositionEnd = compositionEnd;
        }
    }
}

