/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.framehost;

import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.content_public.browser.NavigationController;

@JNINamespace(value="content")
class NavigationControllerImpl
implements NavigationController {
    private long mNativeNavigationControllerAndroid;

    private NavigationControllerImpl(long nativeNavigationControllerAndroid) {
        this.mNativeNavigationControllerAndroid = nativeNavigationControllerAndroid;
    }

    @CalledByNative
    private static NavigationControllerImpl create(long nativeNavigationControllerAndroid) {
        return new NavigationControllerImpl(nativeNavigationControllerAndroid);
    }

    @CalledByNative
    private void destroy() {
        this.mNativeNavigationControllerAndroid = 0L;
    }

    public boolean canGoBack() {
        return this.mNativeNavigationControllerAndroid != 0L && this.nativeCanGoBack(this.mNativeNavigationControllerAndroid);
    }

    public boolean canGoForward() {
        return this.mNativeNavigationControllerAndroid != 0L && this.nativeCanGoForward(this.mNativeNavigationControllerAndroid);
    }

    public boolean canGoToOffset(int offset) {
        return this.mNativeNavigationControllerAndroid != 0L && this.nativeCanGoToOffset(this.mNativeNavigationControllerAndroid, offset);
    }

    public void goToOffset(int offset) {
        if (this.mNativeNavigationControllerAndroid != 0L) {
            this.nativeGoToOffset(this.mNativeNavigationControllerAndroid, offset);
        }
    }

    public void goToNavigationIndex(int index) {
        if (this.mNativeNavigationControllerAndroid != 0L) {
            this.nativeGoToNavigationIndex(this.mNativeNavigationControllerAndroid, index);
        }
    }

    public void goBack() {
        if (this.mNativeNavigationControllerAndroid != 0L) {
            this.nativeGoBack(this.mNativeNavigationControllerAndroid);
        }
    }

    public void goForward() {
        if (this.mNativeNavigationControllerAndroid != 0L) {
            this.nativeGoForward(this.mNativeNavigationControllerAndroid);
        }
    }

    private native boolean nativeCanGoBack(long var1);

    private native boolean nativeCanGoForward(long var1);

    private native boolean nativeCanGoToOffset(long var1, int var3);

    private native void nativeGoBack(long var1);

    private native void nativeGoForward(long var1);

    private native void nativeGoToOffset(long var1, int var3);

    private native void nativeGoToNavigationIndex(long var1, int var3);
}

