/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.crypto;

import android.os.AsyncTask;
import android.os.Bundle;
import android.util.Log;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.annotation.concurrent.ThreadSafe;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.chromium.content.browser.crypto.ByteArrayGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class CipherFactory {
    private static final String TAG = "CipherFactory";
    static final int NUM_BYTES = 16;
    static final String BUNDLE_IV = "org.chromium.content.browser.crypto.CipherFactory.IV";
    static final String BUNDLE_KEY = "org.chromium.content.browser.crypto.CipherFactory.KEY";
    private final Object mDataLock = new Object();
    private FutureTask<CipherData> mDataGenerator;
    private CipherData mData;
    private ByteArrayGenerator mRandomNumberProvider = new ByteArrayGenerator();

    public static CipherFactory getInstance() {
        return LazyHolder.sInstance;
    }

    public Cipher getCipher(int opmode) {
        CipherData data = this.getCipherData(true);
        if (data != null) {
            try {
                Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
                cipher.init(opmode, data.key, new IvParameterSpec(data.iv));
                return cipher;
            }
            catch (GeneralSecurityException generalSecurityException) {
                // empty catch block
            }
        }
        Log.e((String)TAG, (String)"Error in creating cipher instance.");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CipherData getCipherData(boolean generateIfNeeded) {
        if (this.mData == null && generateIfNeeded) {
            CipherData data;
            this.triggerKeyGeneration();
            try {
                data = this.mDataGenerator.get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
            Object object = this.mDataLock;
            synchronized (object) {
                if (this.mData == null) {
                    this.mData = data;
                }
            }
        }
        return this.mData;
    }

    private Callable<CipherData> createGeneratorCallable() {
        return new Callable<CipherData>(){

            @Override
            public CipherData call() {
                byte[] iv;
                byte[] seed;
                try {
                    seed = CipherFactory.this.mRandomNumberProvider.getBytes(16);
                    iv = CipherFactory.this.mRandomNumberProvider.getBytes(16);
                }
                catch (Exception e) {
                    Log.e((String)CipherFactory.TAG, (String)"Couldn't get generator data.");
                    return null;
                }
                try {
                    SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
                    random.setSeed(seed);
                    KeyGenerator generator = KeyGenerator.getInstance("AES");
                    generator.init(128, random);
                    return new CipherData(generator.generateKey(), iv);
                }
                catch (GeneralSecurityException e) {
                    Log.e((String)CipherFactory.TAG, (String)"Couldn't get generator instances.");
                    return null;
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerKeyGeneration() {
        if (this.mData != null) {
            return;
        }
        Object object = this.mDataLock;
        synchronized (object) {
            if (this.mDataGenerator == null) {
                this.mDataGenerator = new FutureTask<CipherData>(this.createGeneratorCallable());
                AsyncTask.THREAD_POOL_EXECUTOR.execute(this.mDataGenerator);
            }
        }
    }

    public void saveToBundle(Bundle outState) {
        CipherData data = this.getCipherData(false);
        if (data == null) {
            return;
        }
        byte[] wrappedKey = data.key.getEncoded();
        if (wrappedKey != null && data.iv != null) {
            outState.putByteArray(BUNDLE_KEY, wrappedKey);
            outState.putByteArray(BUNDLE_IV, data.iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean restoreFromBundle(Bundle savedInstanceState) {
        if (savedInstanceState == null) {
            return false;
        }
        byte[] wrappedKey = savedInstanceState.getByteArray(BUNDLE_KEY);
        byte[] iv = savedInstanceState.getByteArray(BUNDLE_IV);
        if (wrappedKey == null || iv == null) {
            return false;
        }
        try {
            SecretKeySpec bundledKey = new SecretKeySpec(wrappedKey, "AES");
            Object object = this.mDataLock;
            synchronized (object) {
                if (this.mData == null) {
                    this.mData = new CipherData(bundledKey, iv);
                    return true;
                }
                if (this.mData.key.equals(bundledKey) && Arrays.equals(this.mData.iv, iv)) {
                    return true;
                }
                Log.e((String)TAG, (String)"Attempted to restore different cipher data.");
            }
        }
        catch (IllegalArgumentException e) {
            Log.e((String)TAG, (String)"Error in restoring the key from the bundle.");
        }
        return false;
    }

    void setRandomNumberProviderForTests(ByteArrayGenerator mockProvider) {
        this.mRandomNumberProvider = mockProvider;
    }

    private CipherFactory() {
    }

    private static class LazyHolder {
        private static CipherFactory sInstance = new CipherFactory();

        private LazyHolder() {
        }
    }

    private static class CipherData {
        public final Key key;
        public final byte[] iv;

        public CipherData(Key key, byte[] iv) {
            this.key = key;
            this.iv = iv;
        }
    }
}

